/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.admin.cli;

import com.swiftmq.admin.cli.CLIException;
import com.swiftmq.admin.cli.CLIReconnectedException;
import com.swiftmq.admin.cli.event.RouterListener;
import com.swiftmq.admin.cli.v400.RequestProcessor;
import com.swiftmq.admin.mgmt.ConnectionHolder;
import com.swiftmq.admin.mgmt.Endpoint;
import com.swiftmq.admin.mgmt.EndpointRegistry;
import com.swiftmq.admin.mgmt.EndpointRegistryClosedException;
import com.swiftmq.admin.mgmt.ExceptionListener;
import com.swiftmq.admin.mgmt.JMSConnectionHolder;
import com.swiftmq.admin.mgmt.RequestServiceFactory;
import com.swiftmq.jms.ReconnectListener;
import com.swiftmq.mgmt.Command;
import com.swiftmq.mgmt.CommandExecutor;
import com.swiftmq.mgmt.CommandRegistry;
import com.swiftmq.mgmt.Entity;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.requestreply.RequestService;
import com.swiftmq.util.SwiftUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.TerminalBuilder;

public class CLI
implements ReconnectListener {
    private static String INIT_FILE_PROP = "swiftmq.cli.init";
    private static String DEFAULT_INIT_FILE = System.getProperty("user.home") + File.separatorChar + ".init.cli";
    ConnectionHolder connectionHolder = null;
    LineReader inReader = null;
    BufferedReader scriptReader = null;
    boolean programmatic = false;
    Object waitSem = new Object();
    Object closeSem = new Object();
    String waitFor = null;
    Vector listeners = new Vector();
    Set availableRouters = Collections.synchronizedSet(new TreeSet());
    CommandRegistry commandRegistry = new CommandRegistry("CLI shell", null);
    Endpoint actRouter = null;
    EndpointRegistry endpointRegistry = new EndpointRegistry();
    Map aliases = Collections.synchronizedMap(new TreeMap());
    PrintWriter outWriter = null;
    boolean reconnected = false;
    boolean substitute = false;
    boolean verbose = false;
    Map vars = new HashMap();
    Semaphore waitForRouters = new Semaphore();

    private CLI() {
        CommandExecutor exitExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 1) {
                    return new String[]{"Error:", "Invalid command, please try 'exit'"};
                }
                CLI.this.close();
                System.exit(-1);
                return null;
            }
        };
        Command exitCommand = new Command("exit", "exit", "Exit CLI", true, exitExecutor);
        this.commandRegistry.addCommand(exitCommand);
        CommandExecutor switchExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 2) {
                    return new String[]{"Error:", "Invalid command, please try 'sr <router>'"};
                }
                if (CLI.this.availableRouters.contains(cmd[1])) {
                    try {
                        Endpoint routerContext = CLI.this.endpointRegistry.get(cmd[1]);
                        if (routerContext == null) {
                            routerContext = CLI.this.createEndpoint(cmd[1], false);
                        }
                        CLI.this.actRouter = routerContext;
                        CLI.this.commandRegistry.setDefaultCommand(CLI.this.actRouter);
                        CLI.this.vars.put("routername", cmd[1]);
                    }
                    catch (Exception e) {
                        return new String[]{"Error:", e.toString()};
                    }
                    return null;
                }
                return new String[]{"Error:", "Router '" + cmd[1] + "' is unknown."};
            }
        };
        Command switchCommand = new Command("sr", "sr <router>", "Switch to Router <router>", true, switchExecutor);
        this.commandRegistry.addCommand(switchCommand);
        CommandExecutor availExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 1) {
                    return new String[]{"Error:", "Invalid command, please try 'ar'"};
                }
                ArrayList<String> al = new ArrayList<String>();
                al.add("Result:");
                al.add("Available Routers:");
                al.add("");
                String[] s = CLI.this.availableRouters.toArray(new String[CLI.this.availableRouters.size()]);
                for (int i = 0; i < s.length; ++i) {
                    al.add(s[i]);
                }
                al.add("");
                return al.toArray(new String[al.size()]);
            }
        };
        Command availCommand = new Command("ar", "ar", "Show all available Routers", true, availExecutor);
        this.commandRegistry.addCommand(availCommand);
        CommandExecutor wrExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length < 2 || cmd.length > 3) {
                    return new String[]{"Error:", "Invalid command, please try 'wr <router> [<timeout millisecs>]'"};
                }
                if (cmd.length == 2) {
                    CLI.this.waitForRouter(cmd[1]);
                } else {
                    CLI.this.waitForRouter(cmd[1], Long.valueOf(cmd[2]));
                }
                return null;
            }
        };
        Command wrCommand = new Command("wr", "wr <router> [<timeout millisecs>]", "Wait for availability of router <router>", true, wrExecutor);
        this.commandRegistry.addCommand(wrCommand);
        CommandExecutor substituteExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 2) {
                    return new String[]{"Error:", "Invalid command, please try 'substitute on | off'"};
                }
                if (cmd[1].equals("on")) {
                    CLI.this.substitute = true;
                } else if (cmd[1].equals("off")) {
                    CLI.this.substitute = false;
                } else {
                    return new String[]{"Error:", "Invalid command, please try 'substitute on | off'"};
                }
                return null;
            }
        };
        Command substituteCommand = new Command("substitute", "substitute on | off", "Substitutes variables in a command", true, substituteExecutor);
        this.commandRegistry.addCommand(substituteCommand);
        CommandExecutor verboseExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 2) {
                    return new String[]{"Error:", "Invalid command, please try 'verbose on | off'"};
                }
                if (cmd[1].equals("on")) {
                    CLI.this.verbose = true;
                } else if (cmd[1].equals("off")) {
                    CLI.this.verbose = false;
                } else {
                    return new String[]{"Error:", "Invalid command, please try 'verbose on | off'"};
                }
                return null;
            }
        };
        Command verboseCommand = new Command("verbose", "verbose on | off", "Displays each CLI script command before execution", true, verboseExecutor);
        this.commandRegistry.addCommand(verboseCommand);
        CommandExecutor outputExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 2) {
                    return new String[]{"Error:", "Invalid command, please try 'output <filename> | console'"};
                }
                try {
                    if (cmd[1].equals("console")) {
                        CLI.this.outWriter = null;
                    } else {
                        File f = new File(cmd[1]);
                        if (f.exists()) {
                            f.delete();
                        }
                        CLI.this.outWriter = new PrintWriter((Writer)new FileWriter(f), true);
                    }
                }
                catch (IOException e) {
                    return new String[]{"Error:", e.getMessage()};
                }
                return null;
            }
        };
        Command outputCommand = new Command("output", "output <filename> | console", "Redirect result output", true, outputExecutor);
        this.commandRegistry.addCommand(outputCommand);
        CommandExecutor echoExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                StringBuffer b = new StringBuffer("");
                if (cmd.length > 1) {
                    for (int i = 1; i < cmd.length; ++i) {
                        if (i != 1) {
                            b.append(' ');
                        }
                        b.append(cmd[i]);
                    }
                }
                return new String[]{"Result:", b.toString()};
            }
        };
        Command echoCommand = new Command("echo", "echo [<message>]", "Echos a message", true, echoExecutor);
        this.commandRegistry.addCommand(echoCommand);
        CommandExecutor varExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length > 3) {
                    return new String[]{"Error:", "Invalid command, please try 'var [<variable> [<value>]]'"};
                }
                if (cmd.length == 3) {
                    CLI.this.vars.put(cmd[1], cmd[2]);
                } else if (cmd.length == 2) {
                    CLI.this.vars.remove(cmd[1]);
                } else {
                    for (Map.Entry entry : CLI.this.vars.entrySet()) {
                        System.out.println(entry.getKey() + "=" + entry.getValue());
                    }
                }
                return null;
            }
        };
        Command varCommand = new Command("var", "var [<variable> [<value>]]", "Lists, sets or deletes variables", true, varExecutor);
        this.commandRegistry.addCommand(varCommand);
        CommandExecutor asetExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length < 3) {
                    return new String[]{"Error:", "Invalid command, please try 'aset <alias> <command>'"};
                }
                String alias = cmd[1];
                StringBuffer b = new StringBuffer();
                for (int i = 2; i < cmd.length; ++i) {
                    if (i != 2) {
                        b.append(' ');
                    }
                    b.append(cmd[i]);
                }
                CLI.this.aliases.put(alias, b.toString());
                return null;
            }
        };
        Command asetCommand = new Command("aset", "aset <alias> <command>", "Set a command alias", true, asetExecutor);
        this.commandRegistry.addCommand(asetCommand);
        CommandExecutor adelExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 2) {
                    return new String[]{"Error:", "Invalid command, please try 'adel <alias>'"};
                }
                CLI.this.aliases.remove(cmd[1]);
                return null;
            }
        };
        Command adelCommand = new Command("adel", "adel <alias>", "Remove a command alias", true, adelExecutor);
        this.commandRegistry.addCommand(adelCommand);
        CommandExecutor alistExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length > 2) {
                    return new String[]{"Error:", "Invalid command, please try 'alist [<alias>]'"};
                }
                System.out.println();
                StringBuffer b = new StringBuffer();
                b.append(SwiftUtilities.fillToLength("Alias", 33));
                b.append("Command");
                System.out.println(b.toString());
                System.out.println(SwiftUtilities.fillLeft("", 72, '-'));
                if (cmd.length == 2) {
                    String value = (String)CLI.this.aliases.get(cmd[1]);
                    if (value == null) {
                        System.out.println("Alias not defined.");
                    } else {
                        StringBuffer s = new StringBuffer();
                        s.append(SwiftUtilities.fillToLength(cmd[1], 33));
                        s.append(value);
                        System.out.println(s.toString());
                    }
                } else if (CLI.this.aliases.size() == 0) {
                    System.out.println("No aliases defined.");
                } else {
                    for (String key : CLI.this.aliases.keySet()) {
                        String value = (String)CLI.this.aliases.get(key);
                        StringBuffer s = new StringBuffer();
                        s.append(SwiftUtilities.fillToLength(key, 33));
                        s.append(value);
                        System.out.println(s.toString());
                    }
                }
                System.out.println();
                return null;
            }
        };
        Command alistCommand = new Command("alist", "alist [<alias>]", "List one or all alias(es)", true, alistExecutor);
        this.commandRegistry.addCommand(alistCommand);
        CommandExecutor asaveExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length > 2) {
                    return new String[]{"Error:", "Invalid command, please try 'execute [<filename>]'"};
                }
                String filename = null;
                filename = cmd.length == 2 ? cmd[1] : System.getProperty("user.home") + File.separatorChar + ".init.cli";
                System.out.println("Saving aliases to file: " + filename);
                try {
                    PrintWriter pw = new PrintWriter(new FileWriter(filename));
                    pw.println("# CLI aliases, saved: " + new Date());
                    for (String key : CLI.this.aliases.keySet()) {
                        String value = (String)CLI.this.aliases.get(key);
                        pw.println("aset " + key + " " + value);
                    }
                    pw.flush();
                    pw.close();
                }
                catch (IOException e) {
                    return new String[]{"Error:", "Unable to saves aliases, exception = " + e};
                }
                return null;
            }
        };
        Command asaveCommand = new Command("asave", "asave [<filename>]", "Saves all aliases into a file", true, asaveExecutor);
        this.commandRegistry.addCommand(asaveCommand);
        CommandExecutor executeExecutor = new CommandExecutor(){

            @Override
            public String[] execute(String[] context, Entity entity, String[] cmd) {
                if (cmd.length != 2) {
                    return new String[]{"Error:", "Invalid command, please try 'execute <filename>'"};
                }
                String filename = cmd[1];
                try {
                    CLI.this.executeScript(filename);
                }
                catch (Exception e) {
                    return new String[]{"Error:", "Unable to execute " + filename + ", exception = " + e};
                }
                return null;
            }
        };
        Command executeCommand = new Command("execute", "execute <filename>", "Executes a CLI script", true, executeExecutor);
        this.commandRegistry.addCommand(executeCommand);
    }

    CLI(String smqpURL, String qcfName, String scriptFile) throws Exception {
        this();
        this.inReader = LineReaderBuilder.builder().terminal(TerminalBuilder.terminal()).build();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.swiftmq.jndi.InitialContextFactoryImpl");
        env.put("java.naming.provider.url", smqpURL);
        InitialContext ctx = new InitialContext(env);
        this.connectionHolder = new JMSConnectionHolder((QueueConnectionFactory)ctx.lookup(qcfName));
        ctx.close();
        String filename = System.getProperty(INIT_FILE_PROP, DEFAULT_INIT_FILE);
        if (new File(filename).exists()) {
            this.executeScript(filename);
        }
        if (scriptFile != null) {
            try {
                this.scriptReader = new BufferedReader(new InputStreamReader(new FileInputStream(scriptFile)));
            }
            catch (Exception e) {
                throw new Exception("Exception opening Script File: " + e.getMessage());
            }
        }
    }

    public CLI(ConnectionHolder connectionHolder, String scriptFile) throws Exception {
        this();
        this.inReader = LineReaderBuilder.builder().terminal(TerminalBuilder.terminal()).build();
        this.connectionHolder = connectionHolder;
        String filename = System.getProperty(INIT_FILE_PROP, DEFAULT_INIT_FILE);
        if (new File(filename).exists()) {
            this.executeScript(filename);
        }
        if (scriptFile != null) {
            try {
                this.scriptReader = new BufferedReader(new InputStreamReader(new FileInputStream(scriptFile)));
            }
            catch (Exception e) {
                throw new Exception("Exception opening Script File: " + e.getMessage());
            }
        }
    }

    public CLI(QueueConnection queueConnection) throws Exception {
        this();
        this.programmatic = true;
        this.connectionHolder = new JMSConnectionHolder(queueConnection);
        this.connectionHolder.start();
        this.init();
        this.connectionHolder.addReconnectListener(this);
        String filename = System.getProperty(INIT_FILE_PROP, DEFAULT_INIT_FILE);
        if (new File(filename).exists()) {
            this.executeScript(filename);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println();
            System.out.println("usage: java com.swiftmq.admin.cli.CLI <smqp-url> <qcf> [<scriptfile>]");
            System.out.println();
            System.out.println("<smqp-url>   is the JNDI-Provider-URL like 'smqp://localhost:4001/timeout=10000'");
            System.out.println("<qcf>        is the name of the queue connection factory");
            System.out.println("             like 'QueueConnectionFactory'");
            System.out.println("<scriptfile> name of an optional file with CLI commands");
            System.out.println();
            System.out.println("See SwiftMQ's documentation for details");
            System.out.println();
            System.exit(-1);
        }
        try {
            CLI cli = new CLI(args[0], args[1], args.length == 3 ? args[2] : null);
            cli.run();
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(-1);
        }
    }

    @Override
    public void reconnected(String host, int port) {
        this.reconnected = true;
        EndpointRegistry old = this.endpointRegistry;
        this.endpointRegistry = new EndpointRegistry();
        this.actRouter = null;
        this.commandRegistry.setDefaultCommand(null);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        old.close();
    }

    public String getActRouter() {
        return this.actRouter != null ? this.actRouter.getRouterName() : null;
    }

    public String getActContext() {
        String[] context = this.actRouter != null ? this.actRouter.getActContext() : null;
        return context != null ? "/" + SwiftUtilities.concat(context, "/") : null;
    }

    public String getContextProperty(String name) throws CLIException {
        String[] context;
        String[] stringArray = context = this.actRouter != null ? this.actRouter.getActContext() : null;
        if (context == null) {
            throw new CLIException("No actual context set!");
        }
        String[] result = this.commandRegistry.executeCommand(context, new String[]{"getcontextprop", name});
        if (result == null) {
            throw new CLIException("Property '" + name + "' is unknown in this context!");
        }
        if (result[0].equals("Error:")) {
            if (this.reconnected) {
                this.reconnected = false;
                throw new CLIReconnectedException(result[1]);
            }
            throw new CLIException(result[1]);
        }
        return result.length == 2 ? result[1] : null;
    }

    public String[] getContextEntities() throws CLIException {
        String[] context;
        String[] stringArray = context = this.actRouter != null ? this.actRouter.getActContext() : null;
        if (context == null) {
            throw new CLIException("No actual context set!");
        }
        return this.commandRegistry.executeCommand(context, new String[]{"getcontextent"});
    }

    public String[] getAvailableRouters() {
        return this.availableRouters.toArray(new String[this.availableRouters.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRouter(String routerName) {
        Object object = this.waitSem;
        synchronized (object) {
            this.waitFor = routerName;
            if (!this.availableRouters.contains(routerName)) {
                try {
                    if (!this.programmatic) {
                        System.out.println("Waiting for router '" + routerName + "'");
                    }
                    this.waitSem.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.waitFor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRouter(String routerName, long timeout) {
        Object object = this.waitSem;
        synchronized (object) {
            this.waitFor = routerName;
            if (!this.availableRouters.contains(routerName)) {
                try {
                    if (!this.programmatic) {
                        System.out.println("Waiting for router '" + routerName + "' with timeout " + timeout + " ms");
                    }
                    this.waitSem.wait(timeout);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.waitFor = null;
        }
    }

    public void executeCommand(String cmd) throws CLIException {
        try {
            List cmdList = SwiftUtilities.parseCLICommandList(cmd);
            for (String[] parsedCmd : cmdList) {
                String aliasValue = (String)this.aliases.get(parsedCmd[0]);
                if (aliasValue != null) {
                    this._processAlias(aliasValue, parsedCmd);
                    continue;
                }
                String[] result = this.commandRegistry.executeCommand(this.actRouter == null ? null : this.actRouter.getActContext(), this.substitute(parsedCmd));
                if (result == null) continue;
                if (result[0].equals("Error:")) {
                    String s = SwiftUtilities.concat(SwiftUtilities.cutFirst(result), " ");
                    if (this.reconnected) {
                        this.reconnected = false;
                        throw new CLIReconnectedException(s);
                    }
                    throw new CLIException(s);
                }
                if (!result[0].equals("Result:")) continue;
                throw new CLIException("Invalid method; command returns a result!");
            }
        }
        catch (CLIException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new CLIException(e1.getMessage());
        }
    }

    private String[] substitute(String[] cmd) {
        String[] result = cmd;
        if (this.substitute) {
            for (int i = 0; i < result.length; ++i) {
                for (Map.Entry entry : this.vars.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    result[i] = SwiftUtilities.substitute(result[i], name, value);
                }
            }
        }
        try {
            if (this.verbose) {
                this.out(SwiftUtilities.concat(result, " "));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private void _processAlias(String aliasValue, String[] aliasCmd) throws Exception {
        String s = aliasValue;
        String[] t = SwiftUtilities.parseCLICommand(s);
        if (t.length == 1) {
            if (aliasCmd.length > 1) {
                StringBuffer b = new StringBuffer(t[0]);
                for (int i = 1; i < aliasCmd.length; ++i) {
                    b.append(" ");
                    b.append(aliasCmd[i]);
                }
                s = b.toString();
            } else {
                s = aliasValue;
            }
        } else if (aliasCmd.length > 1 && t.length > 1) {
            s = SwiftUtilities.substitute(s, SwiftUtilities.cutFirst(aliasCmd));
            for (int i = 1; i < aliasCmd.length; ++i) {
                s = SwiftUtilities.substitute(s, String.valueOf(i), aliasCmd[i]);
            }
        }
        this.executeCommand(s);
    }

    public void addRouterListener(RouterListener l) {
        this.listeners.addElement(l);
    }

    public void removeRouterListener(RouterListener l) {
        this.listeners.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRouterEvent(String routerName, boolean available) {
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((RouterListener)this.listeners.elementAt(i)).onRouterEvent(routerName, available);
            }
        }
    }

    public boolean isProgrammatic() {
        return this.programmatic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRouter(String routerName, boolean available) {
        if (available) {
            this.availableRouters.add(routerName);
            Object object = this.waitSem;
            synchronized (object) {
                if (this.waitFor != null && this.waitFor.equals(routerName)) {
                    this.waitSem.notify();
                }
            }
            if (this.programmatic) {
                this.fireRouterEvent(routerName, true);
            } else {
                System.out.println("Router '" + routerName + "' is available for administration.");
                this.waitForRouters.notifySingleWaiter();
            }
        } else {
            this.availableRouters.remove(routerName);
            this.removeEndpoint(routerName);
            if (this.programmatic) {
                this.fireRouterEvent(routerName, false);
            } else {
                System.out.println("Router '" + routerName + "' is unavailable for administration.");
            }
        }
    }

    public Endpoint createEndpoint(String routerName, boolean routeInfos) throws Exception {
        Endpoint endpoint = this.connectionHolder.createEndpoint(routerName, new RequestServiceFactory(){

            @Override
            public RequestService createRequestService(int protocolVersion) {
                if (protocolVersion == 750) {
                    return new com.swiftmq.admin.cli.v750.RequestProcessor(CLI.this);
                }
                return new RequestProcessor(CLI.this);
            }
        }, this.programmatic);
        endpoint.setRouteInfos(routeInfos);
        String name = null;
        endpoint.connect(0, InetAddress.getLocalHost().getHostName(), "CLI" + (this.programmatic ? " Admin API" : ""), routeInfos, false, false);
        endpoint.setStarted(true);
        name = endpoint.getRouterName();
        try {
            this.endpointRegistry.put(endpoint.getRouterName(), endpoint);
        }
        catch (EndpointRegistryClosedException e) {
            endpoint.close();
            endpoint = null;
        }
        return endpoint;
    }

    public void removeEndpoint(String routerName) {
        Endpoint routerContext = this.endpointRegistry.remove(routerName);
        if (routerContext != null) {
            if (routerContext == this.actRouter) {
                this.actRouter = null;
                this.commandRegistry.setDefaultCommand(null);
            }
            routerContext.close();
        }
    }

    private void init() throws Exception {
        Endpoint endpoint = this.createEndpoint(null, true);
        this.markRouter(endpoint.getRouterName(), true);
    }

    private String readLine(boolean nullOnEmpty, boolean isPassword) {
        String line = null;
        boolean ok = false;
        try {
            while (!ok) {
                if (this.scriptReader != null && (line = this.scriptReader.readLine()) == null) {
                    this.scriptReader.close();
                    this.scriptReader = null;
                }
                if (line == null) {
                    line = isPassword ? this.inReader.readLine(new Character('*')) : this.inReader.readLine();
                }
                ok = line != null && !line.trim().startsWith("#") || line == null;
            }
            if (nullOnEmpty && line != null && line.equals("")) {
                line = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return line;
    }

    private void out(String line) throws Exception {
        if (this.outWriter == null) {
            System.out.println(line);
        } else {
            this.outWriter.println(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(String filename) throws Exception {
        this.vars.put("scriptpath", new File(filename).getParent());
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.trim().length() <= 0) continue;
                this.processCommand(line);
            }
        }
        finally {
            this.vars.remove("scriptpath");
        }
    }

    private void processAlias(String aliasValue, String[] aliasCmd) throws Exception {
        String s = aliasValue;
        String[] t = SwiftUtilities.parseCLICommand(s);
        if (t.length == 1) {
            if (aliasCmd.length > 1) {
                StringBuffer b = new StringBuffer(t[0]);
                for (int i = 1; i < aliasCmd.length; ++i) {
                    b.append(" ");
                    b.append(aliasCmd[i]);
                }
                s = b.toString();
            } else {
                s = aliasValue;
            }
        } else if (aliasCmd.length > 1 && t.length > 1) {
            s = SwiftUtilities.substitute(s, SwiftUtilities.cutFirst(aliasCmd));
            for (int i = 1; i < aliasCmd.length; ++i) {
                s = SwiftUtilities.substitute(s, String.valueOf(i), aliasCmd[i]);
            }
        }
        this.processCommand(s.trim());
    }

    private void processCommand(String command) throws Exception {
        List cmdList = SwiftUtilities.parseCLICommandList(command);
        for (String[] parsedCmd : cmdList) {
            parsedCmd[0] = parsedCmd[0].trim();
            String aliasValue = (String)this.aliases.get(parsedCmd[0]);
            if (aliasValue != null) {
                this.processAlias(aliasValue, parsedCmd);
                continue;
            }
            String[] result = this.commandRegistry.executeCommand(this.actRouter == null ? null : this.actRouter.getActContext(), this.substitute(parsedCmd));
            if (result == null) continue;
            if (result[0].equals("Error:") && result.length > 1) {
                System.out.println(result[1]);
                continue;
            }
            for (int i = 0; i < result.length; ++i) {
                if (result[i].equals("Result:") || result[i].equals("Information:")) continue;
                this.out(result[i]);
            }
        }
    }

    private void mainLoop() {
        String prompt = null;
        String[] context = null;
        boolean shouldExit = false;
        while (!shouldExit) {
            String command;
            if (this.actRouter != null) {
                prompt = this.actRouter.getRouterName();
                if (this.actRouter.getActContext() != null) {
                    prompt = prompt + '/' + SwiftUtilities.concat(this.actRouter.getActContext(), "/");
                }
                context = this.actRouter.getActContext();
            } else {
                prompt = "";
            }
            prompt = prompt + "> ";
            if (this.scriptReader == null) {
                System.out.print(prompt);
            }
            if ((command = this.readLine(false, false)) == null) {
                System.out.println("Bye.");
                return;
            }
            if ((command = command.trim()).length() <= 0) continue;
            try {
                this.processCommand(command);
            }
            catch (Exception e) {
                System.out.println();
                System.out.println(e.getMessage());
                System.out.println();
            }
        }
    }

    public void run() {
        String userName = null;
        String password = null;
        if (this.scriptReader == null) {
            System.out.println();
            System.out.println("Welcome to SwiftMQ!");
            System.out.println();
            System.out.print("Username: ");
            userName = this.readLine(true, false);
            System.out.print("Password: ");
            password = this.readLine(true, true);
        } else {
            userName = System.getProperty("cli.username");
            password = System.getProperty("cli.password");
        }
        if (this.scriptReader == null) {
            System.out.print("Trying to connect ... ");
        }
        try {
            this.connectionHolder.connect(userName, password);
            if (this.scriptReader == null) {
                System.out.println("connected");
            }
        }
        catch (Exception e) {
            System.out.println("failed, exception: " + e.getMessage());
            this.close();
            return;
        }
        try {
            this.connectionHolder.setExceptionListener(new ExceptionListener(){

                @Override
                public void onException(Exception e) {
                    if (e.getMessage() == null) {
                        System.out.println("Connection lost.");
                    } else {
                        System.out.println("Exception occurred: " + e.getMessage());
                    }
                    System.exit(-1);
                }
            });
            this.connectionHolder.start();
            this.init();
            this.connectionHolder.addReconnectListener(this);
        }
        catch (Exception e) {
            System.out.println("failed to establish route listener, exception: " + e.getMessage());
            this.close();
            return;
        }
        if (this.scriptReader == null) {
            System.out.println("Type 'help' to get a list of available commands.");
        } else {
            this.waitForRouters.waitHere();
        }
        this.mainLoop();
        this.close();
    }

    public void close() {
        if (this.connectionHolder == null) {
            return;
        }
        this.connectionHolder.removeReconnectListener(this);
        this.endpointRegistry.close();
        if (!this.programmatic) {
            try {
                this.connectionHolder.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

