/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.admin.cli.v400;

import com.swiftmq.admin.cli.CLI;
import com.swiftmq.mgmt.protocol.v400.BulkRequest;
import com.swiftmq.mgmt.protocol.v400.DisconnectedRequest;
import com.swiftmq.mgmt.protocol.v400.ProtocolVisitorAdapter;
import com.swiftmq.mgmt.protocol.v400.RouterAvailableRequest;
import com.swiftmq.mgmt.protocol.v400.RouterUnavailableRequest;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestService;

public class RequestProcessor
extends ProtocolVisitorAdapter
implements RequestService {
    CLI cli = null;

    public RequestProcessor(CLI cli) {
        this.cli = cli;
    }

    @Override
    public void serviceRequest(Request request) {
        request.accept(this);
    }

    @Override
    public void visit(BulkRequest request) {
        for (int i = 0; i < request.len; ++i) {
            ((Request)request.dumpables[i]).accept(this);
        }
    }

    @Override
    public void visit(RouterAvailableRequest request) {
        try {
            this.cli.markRouter(request.getRoutername(), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void visit(RouterUnavailableRequest request) {
        this.cli.markRouter(request.getRoutername(), false);
    }

    @Override
    public void visit(DisconnectedRequest request) {
        if (!this.cli.isProgrammatic()) {
            System.out.println("Router '" + request.getRouterName() + "' has been disconnected! Reason: " + request.getReason());
        }
        this.cli.markRouter(request.getRouterName(), false);
    }
}

