/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.admin.mgmt;

import com.swiftmq.admin.mgmt.Endpoint;
import com.swiftmq.admin.mgmt.RequestServiceFactory;
import com.swiftmq.admin.mgmt.v400.EndpointImpl;
import com.swiftmq.jms.BytesMessageImpl;
import com.swiftmq.jms.QueueImpl;
import com.swiftmq.mgmt.protocol.ProtocolFactory;
import com.swiftmq.mgmt.protocol.ProtocolReply;
import com.swiftmq.mgmt.protocol.ProtocolRequest;
import com.swiftmq.tools.dump.Dumpalizer;
import com.swiftmq.tools.requestreply.Reply;
import com.swiftmq.tools.requestreply.Request;
import com.swiftmq.tools.requestreply.RequestRegistry;
import com.swiftmq.tools.requestreply.RequestServiceRegistry;
import com.swiftmq.tools.requestreply.TimeoutException;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class EndpointFactory {
    static final String MGMT_QUEUE = "swiftmqmgmt";
    static final int MGMT_PROTOCOL_VERSION = Integer.parseInt(System.getProperty("swiftmq.mgmt.protocol.version", "750"));

    public static Endpoint createEndpoint(String routerName, QueueConnection connection, RequestServiceFactory rsf, boolean createInternalCommands) throws Exception {
        return new EndpointCreator(routerName, connection).create(rsf, createInternalCommands);
    }

    private static class EndpointCreator {
        String routerName = null;
        QueueConnection connection = null;
        QueueSession senderSession = null;
        QueueSender sender = null;
        QueueSession receiverSession = null;
        QueueReceiver receiver = null;
        TemporaryQueue replyQueue = null;

        private EndpointCreator(String routerName, QueueConnection connection) throws Exception {
            this.routerName = routerName;
            this.connection = connection;
            String queueName = null;
            queueName = routerName == null ? EndpointFactory.MGMT_QUEUE : "swiftmqmgmt@" + routerName;
            try {
                this.senderSession = connection.createQueueSession(false, 1);
                this.sender = this.senderSession.createSender((Queue)new QueueImpl(queueName));
                this.sender.setDeliveryMode(1);
                this.sender.setPriority(8);
                this.receiverSession = connection.createQueueSession(false, 1);
                this.replyQueue = this.receiverSession.createTemporaryQueue();
                this.receiver = this.receiverSession.createReceiver((Queue)this.replyQueue);
            }
            catch (JMSException e) {
                this.cleanup();
                throw e;
            }
        }

        private BytesMessageImpl requestToMessage(Request request) throws Exception {
            DataByteArrayOutputStream dos = new DataByteArrayOutputStream();
            dos.rewind();
            Dumpalizer.dump(dos, request);
            BytesMessageImpl msg = new BytesMessageImpl();
            msg.writeBytes(dos.getBuffer(), 0, dos.getCount());
            return msg;
        }

        private Reply messageToReply(BytesMessageImpl msg) throws Exception {
            int len = (int)msg._getBodyLength();
            byte[] buffer = new byte[len];
            msg.readBytes(buffer);
            DataByteArrayInputStream dis = new DataByteArrayInputStream(buffer);
            return (Reply)Dumpalizer.construct(dis, new ProtocolFactory());
        }

        private Reply request(Request request) throws Exception {
            BytesMessageImpl msg = this.requestToMessage(request);
            msg.setJMSReplyTo((Destination)this.replyQueue);
            this.sender.send((Message)msg);
            msg = (BytesMessageImpl)this.receiver.receive(RequestRegistry.SWIFTMQ_REQUEST_TIMEOUT);
            if (msg == null) {
                throw new TimeoutException("Request timeout occured (" + RequestRegistry.SWIFTMQ_REQUEST_TIMEOUT + ") ms");
            }
            return this.messageToReply(msg);
        }

        public Endpoint create(RequestServiceFactory rsf, boolean createInternalCommands) throws Exception {
            RequestServiceRegistry endpoint = null;
            try {
                switch (MGMT_PROTOCOL_VERSION) {
                    case 750: {
                        ProtocolReply pr = (ProtocolReply)this.request(new ProtocolRequest(750));
                        if (pr.isOk()) {
                            endpoint = new com.swiftmq.admin.mgmt.v750.EndpointImpl(this.connection, this.senderSession, this.sender, this.receiverSession, this.receiver, this.replyQueue, rsf.createRequestService(750), createInternalCommands);
                            endpoint.setSubscriptionFilterEnabled(true);
                            break;
                        }
                        pr = (ProtocolReply)this.request(new ProtocolRequest(400));
                        if (!pr.isOk()) {
                            throw pr.getException();
                        }
                        endpoint = new EndpointImpl(this.connection, this.senderSession, this.sender, this.receiverSession, this.receiver, this.replyQueue, rsf.createRequestService(400), createInternalCommands);
                        break;
                    }
                    case 400: {
                        ProtocolReply pr = (ProtocolReply)this.request(new ProtocolRequest(400));
                        if (!pr.isOk()) {
                            throw pr.getException();
                        }
                        endpoint = new EndpointImpl(this.connection, this.senderSession, this.sender, this.receiverSession, this.receiver, this.replyQueue, rsf.createRequestService(400), createInternalCommands);
                        break;
                    }
                    default: {
                        throw new Exception("Invalid management protocol version (set via swiftmq.mgmt.protocol.version): " + MGMT_PROTOCOL_VERSION);
                    }
                }
            }
            catch (Exception e) {
                this.cleanup();
                throw e;
            }
            return endpoint;
        }

        private void cleanup() {
            if (this.senderSession != null) {
                try {
                    this.senderSession.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            if (this.receiverSession != null) {
                try {
                    this.receiverSession.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }
    }
}

