/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.admin.mgmt;

import com.swiftmq.admin.mgmt.Endpoint;
import com.swiftmq.admin.mgmt.EndpointRegistryClosedException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EndpointRegistry {
    Map endpoints = new HashMap();
    boolean closed = false;

    public synchronized void put(String routerName, Endpoint endpoint) throws EndpointRegistryClosedException {
        if (this.closed) {
            throw new EndpointRegistryClosedException("EndpointRegistry already closed!");
        }
        this.endpoints.put(routerName, endpoint);
    }

    public synchronized Endpoint get(String routerName) {
        return (Endpoint)this.endpoints.get(routerName);
    }

    public synchronized Endpoint remove(String routerName) {
        return (Endpoint)this.endpoints.remove(routerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map map;
        EndpointRegistry endpointRegistry = this;
        synchronized (endpointRegistry) {
            map = (Map)((HashMap)this.endpoints).clone();
            this.endpoints.clear();
            this.closed = true;
        }
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Endpoint endpoint = (Endpoint)iter.next().getValue();
            endpoint.close();
        }
    }
}

