/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.admin.mgmt;

import com.swiftmq.admin.mgmt.ConnectionHolder;
import com.swiftmq.admin.mgmt.Endpoint;
import com.swiftmq.admin.mgmt.EndpointFactory;
import com.swiftmq.admin.mgmt.ExceptionListener;
import com.swiftmq.admin.mgmt.RequestServiceFactory;
import com.swiftmq.jms.ReconnectListener;
import com.swiftmq.jms.SwiftMQConnection;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;

public class JMSConnectionHolder
implements ConnectionHolder {
    QueueConnectionFactory connectionFactory = null;
    QueueConnection connection = null;

    public JMSConnectionHolder(QueueConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public JMSConnectionHolder(QueueConnection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void connect(String username, String password) throws Exception {
        if (this.connectionFactory != null) {
            this.connection = this.connectionFactory.createQueueConnection(username, password);
        }
    }

    @Override
    public void start() throws Exception {
        this.connection.start();
    }

    @Override
    public void setExceptionListener(final ExceptionListener listener) throws Exception {
        this.connection.setExceptionListener(new javax.jms.ExceptionListener(){

            public void onException(JMSException e) {
                listener.onException((Exception)((Object)e));
            }
        });
    }

    @Override
    public void addReconnectListener(ReconnectListener listener) {
        ((SwiftMQConnection)this.connection).addReconnectListener(listener);
    }

    @Override
    public void removeReconnectListener(ReconnectListener listener) {
        ((SwiftMQConnection)this.connection).removeReconnectListener(listener);
    }

    @Override
    public Endpoint createEndpoint(String routerName, RequestServiceFactory rsf, boolean createInternalCommands) throws Exception {
        return EndpointFactory.createEndpoint(routerName, this.connection, rsf, createInternalCommands);
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

