/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp;

import com.swiftmq.amqp.Writable;
import com.swiftmq.tools.concurrent.AsyncCompletionCallback;
import com.swiftmq.tools.concurrent.Semaphore;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ProtocolHeader
implements Writable {
    Charset charset = Charset.forName("US-ASCII");
    byte[] b = new byte[8];

    public ProtocolHeader(String name, int id, int major, int minor, int revision) {
        byte[] bytes = this.charset.encode(name).array();
        System.arraycopy(bytes, 0, this.b, 0, 4);
        this.b[4] = (byte)id;
        this.b[5] = (byte)major;
        this.b[6] = (byte)minor;
        this.b[7] = (byte)revision;
    }

    public ProtocolHeader() {
    }

    public String getName() {
        return this.charset.decode(ByteBuffer.wrap(this.b, 0, 4)).toString();
    }

    public int getId() {
        return this.b[4];
    }

    public int getMajor() {
        return this.b[5];
    }

    public int getMinor() {
        return this.b[6];
    }

    public int getRevision() {
        return this.b[7];
    }

    @Override
    public Semaphore getSemaphore() {
        return null;
    }

    @Override
    public AsyncCompletionCallback getCallback() {
        return null;
    }

    public void readContent(DataInput in) throws IOException {
        in.readFully(this.b);
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        out.write(this.b);
    }

    public boolean equals(Object o) {
        ProtocolHeader that = (ProtocolHeader)o;
        return this.getName().equals(that.getName()) && this.getId() == that.getId() && this.getMajor() == that.getMajor() && this.getMinor() == that.getMinor() && this.getRevision() == that.getRevision();
    }

    public String toString() {
        return "[ProtocolHeader, name=" + this.getName() + ", id=" + this.getId() + ", major=" + this.getMajor() + ", minor=" + this.getMinor() + ", revision=" + this.getRevision() + "]";
    }
}

