/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v091.generated;

import com.swiftmq.amqp.v091.generated.basic.Ack;
import com.swiftmq.amqp.v091.generated.basic.BasicMethod;
import com.swiftmq.amqp.v091.generated.basic.Cancel;
import com.swiftmq.amqp.v091.generated.basic.CancelOk;
import com.swiftmq.amqp.v091.generated.basic.Consume;
import com.swiftmq.amqp.v091.generated.basic.ConsumeOk;
import com.swiftmq.amqp.v091.generated.basic.Deliver;
import com.swiftmq.amqp.v091.generated.basic.Get;
import com.swiftmq.amqp.v091.generated.basic.GetEmpty;
import com.swiftmq.amqp.v091.generated.basic.GetOk;
import com.swiftmq.amqp.v091.generated.basic.Nack;
import com.swiftmq.amqp.v091.generated.basic.Publish;
import com.swiftmq.amqp.v091.generated.basic.Qos;
import com.swiftmq.amqp.v091.generated.basic.QosOk;
import com.swiftmq.amqp.v091.generated.basic.Recover;
import com.swiftmq.amqp.v091.generated.basic.RecoverAsync;
import com.swiftmq.amqp.v091.generated.basic.RecoverOk;
import com.swiftmq.amqp.v091.generated.basic.Reject;
import com.swiftmq.amqp.v091.generated.basic.Return;
import com.swiftmq.amqp.v091.generated.channel.ChannelMethod;
import com.swiftmq.amqp.v091.generated.channel.Close;
import com.swiftmq.amqp.v091.generated.channel.CloseOk;
import com.swiftmq.amqp.v091.generated.channel.Flow;
import com.swiftmq.amqp.v091.generated.channel.FlowOk;
import com.swiftmq.amqp.v091.generated.channel.Open;
import com.swiftmq.amqp.v091.generated.confirm.ConfirmMethod;
import com.swiftmq.amqp.v091.generated.confirm.SelectOk;
import com.swiftmq.amqp.v091.generated.connection.ConnectionMethod;
import com.swiftmq.amqp.v091.generated.connection.OpenOk;
import com.swiftmq.amqp.v091.generated.connection.Secure;
import com.swiftmq.amqp.v091.generated.connection.SecureOk;
import com.swiftmq.amqp.v091.generated.connection.Start;
import com.swiftmq.amqp.v091.generated.connection.StartOk;
import com.swiftmq.amqp.v091.generated.connection.Tune;
import com.swiftmq.amqp.v091.generated.connection.TuneOk;
import com.swiftmq.amqp.v091.generated.exchange.Declare;
import com.swiftmq.amqp.v091.generated.exchange.DeclareOk;
import com.swiftmq.amqp.v091.generated.exchange.DeleteOk;
import com.swiftmq.amqp.v091.generated.exchange.ExchangeMethod;
import com.swiftmq.amqp.v091.generated.exchange.UnbindOk;
import com.swiftmq.amqp.v091.generated.queue.Bind;
import com.swiftmq.amqp.v091.generated.queue.BindOk;
import com.swiftmq.amqp.v091.generated.queue.Delete;
import com.swiftmq.amqp.v091.generated.queue.Purge;
import com.swiftmq.amqp.v091.generated.queue.PurgeOk;
import com.swiftmq.amqp.v091.generated.queue.QueueMethod;
import com.swiftmq.amqp.v091.generated.queue.Unbind;
import com.swiftmq.amqp.v091.generated.tx.Commit;
import com.swiftmq.amqp.v091.generated.tx.CommitOk;
import com.swiftmq.amqp.v091.generated.tx.Rollback;
import com.swiftmq.amqp.v091.generated.tx.RollbackOk;
import com.swiftmq.amqp.v091.generated.tx.Select;
import com.swiftmq.amqp.v091.generated.tx.TxMethod;
import com.swiftmq.amqp.v091.types.Coder;
import com.swiftmq.amqp.v091.types.Method;
import java.io.DataInput;
import java.io.IOException;

public class MethodReader {
    private static Method createConnectionMethod(int methodId) throws IOException {
        ConnectionMethod method = null;
        switch (methodId) {
            case 10: {
                method = new Start();
                break;
            }
            case 11: {
                method = new StartOk();
                break;
            }
            case 20: {
                method = new Secure();
                break;
            }
            case 21: {
                method = new SecureOk();
                break;
            }
            case 30: {
                method = new Tune();
                break;
            }
            case 31: {
                method = new TuneOk();
                break;
            }
            case 40: {
                method = new com.swiftmq.amqp.v091.generated.connection.Open();
                break;
            }
            case 41: {
                method = new OpenOk();
                break;
            }
            case 50: {
                method = new com.swiftmq.amqp.v091.generated.connection.Close();
                break;
            }
            case 51: {
                method = new com.swiftmq.amqp.v091.generated.connection.CloseOk();
                break;
            }
            default: {
                throw new IOException("Invalid methodId: " + methodId);
            }
        }
        return method;
    }

    private static Method createChannelMethod(int methodId) throws IOException {
        ChannelMethod method = null;
        switch (methodId) {
            case 10: {
                method = new Open();
                break;
            }
            case 11: {
                method = new com.swiftmq.amqp.v091.generated.channel.OpenOk();
                break;
            }
            case 20: {
                method = new Flow();
                break;
            }
            case 21: {
                method = new FlowOk();
                break;
            }
            case 40: {
                method = new Close();
                break;
            }
            case 41: {
                method = new CloseOk();
                break;
            }
            default: {
                throw new IOException("Invalid methodId: " + methodId);
            }
        }
        return method;
    }

    private static Method createExchangeMethod(int methodId) throws IOException {
        ExchangeMethod method = null;
        switch (methodId) {
            case 10: {
                method = new Declare();
                break;
            }
            case 11: {
                method = new DeclareOk();
                break;
            }
            case 20: {
                method = new com.swiftmq.amqp.v091.generated.exchange.Delete();
                break;
            }
            case 21: {
                method = new DeleteOk();
                break;
            }
            case 30: {
                method = new com.swiftmq.amqp.v091.generated.exchange.Bind();
                break;
            }
            case 31: {
                method = new com.swiftmq.amqp.v091.generated.exchange.BindOk();
                break;
            }
            case 40: {
                method = new com.swiftmq.amqp.v091.generated.exchange.Unbind();
                break;
            }
            case 51: {
                method = new UnbindOk();
                break;
            }
            default: {
                throw new IOException("Invalid methodId: " + methodId);
            }
        }
        return method;
    }

    private static Method createQueueMethod(int methodId) throws IOException {
        QueueMethod method = null;
        switch (methodId) {
            case 10: {
                method = new com.swiftmq.amqp.v091.generated.queue.Declare();
                break;
            }
            case 11: {
                method = new com.swiftmq.amqp.v091.generated.queue.DeclareOk();
                break;
            }
            case 20: {
                method = new Bind();
                break;
            }
            case 21: {
                method = new BindOk();
                break;
            }
            case 50: {
                method = new Unbind();
                break;
            }
            case 51: {
                method = new com.swiftmq.amqp.v091.generated.queue.UnbindOk();
                break;
            }
            case 30: {
                method = new Purge();
                break;
            }
            case 31: {
                method = new PurgeOk();
                break;
            }
            case 40: {
                method = new Delete();
                break;
            }
            case 41: {
                method = new com.swiftmq.amqp.v091.generated.queue.DeleteOk();
                break;
            }
            default: {
                throw new IOException("Invalid methodId: " + methodId);
            }
        }
        return method;
    }

    private static Method createBasicMethod(int methodId) throws IOException {
        BasicMethod method = null;
        switch (methodId) {
            case 10: {
                method = new Qos();
                break;
            }
            case 11: {
                method = new QosOk();
                break;
            }
            case 20: {
                method = new Consume();
                break;
            }
            case 21: {
                method = new ConsumeOk();
                break;
            }
            case 30: {
                method = new Cancel();
                break;
            }
            case 31: {
                method = new CancelOk();
                break;
            }
            case 40: {
                method = new Publish();
                break;
            }
            case 50: {
                method = new Return();
                break;
            }
            case 60: {
                method = new Deliver();
                break;
            }
            case 70: {
                method = new Get();
                break;
            }
            case 71: {
                method = new GetOk();
                break;
            }
            case 72: {
                method = new GetEmpty();
                break;
            }
            case 80: {
                method = new Ack();
                break;
            }
            case 90: {
                method = new Reject();
                break;
            }
            case 100: {
                method = new RecoverAsync();
                break;
            }
            case 110: {
                method = new Recover();
                break;
            }
            case 111: {
                method = new RecoverOk();
                break;
            }
            case 120: {
                method = new Nack();
                break;
            }
            default: {
                throw new IOException("Invalid methodId: " + methodId);
            }
        }
        return method;
    }

    private static Method createTxMethod(int methodId) throws IOException {
        TxMethod method = null;
        switch (methodId) {
            case 10: {
                method = new Select();
                break;
            }
            case 11: {
                method = new com.swiftmq.amqp.v091.generated.tx.SelectOk();
                break;
            }
            case 20: {
                method = new Commit();
                break;
            }
            case 21: {
                method = new CommitOk();
                break;
            }
            case 30: {
                method = new Rollback();
                break;
            }
            case 31: {
                method = new RollbackOk();
                break;
            }
            default: {
                throw new IOException("Invalid methodId: " + methodId);
            }
        }
        return method;
    }

    private static Method createConfirmMethod(int methodId) throws IOException {
        ConfirmMethod method = null;
        switch (methodId) {
            case 10: {
                method = new com.swiftmq.amqp.v091.generated.confirm.Select();
                break;
            }
            case 11: {
                method = new SelectOk();
                break;
            }
            default: {
                throw new IOException("Invalid methodId: " + methodId);
            }
        }
        return method;
    }

    public static Method createMethod(DataInput in) throws IOException {
        Method method = null;
        short classId = Coder.readShort(in);
        short methodId = Coder.readShort(in);
        switch (classId) {
            case 10: {
                method = MethodReader.createConnectionMethod(methodId);
                break;
            }
            case 20: {
                method = MethodReader.createChannelMethod(methodId);
                break;
            }
            case 40: {
                method = MethodReader.createExchangeMethod(methodId);
                break;
            }
            case 50: {
                method = MethodReader.createQueueMethod(methodId);
                break;
            }
            case 60: {
                method = MethodReader.createBasicMethod(methodId);
                break;
            }
            case 90: {
                method = MethodReader.createTxMethod(methodId);
                break;
            }
            case 85: {
                method = MethodReader.createConfirmMethod(methodId);
                break;
            }
            default: {
                throw new IOException("Invalid classId: " + classId);
            }
        }
        method.readContent(in);
        return method;
    }
}

