/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v091.io;

import com.swiftmq.amqp.v091.io.BitSupportDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.BitSet;

public class BitSupportDataInputStream
implements BitSupportDataInput {
    DataInput in;
    BitSet bitSet = null;
    int bitIndex = 0;

    public BitSupportDataInputStream(DataInput in) {
        this.in = in;
    }

    @Override
    public boolean readBit() throws IOException {
        if (this.bitSet == null) {
            this.bitSet = new BitSet(8);
            byte b = this.in.readByte();
            for (int i = 0; i < 8; ++i) {
                if ((b & 1 << i % 8) <= 0) continue;
                this.bitSet.set(i);
            }
            this.bitIndex = 0;
        }
        boolean rc = this.bitSet.get(this.bitIndex++);
        if (this.bitIndex == 8) {
            this.bitSet = null;
        }
        return rc;
    }

    @Override
    public void readFully(byte[] bytes) throws IOException {
        this.bitSet = null;
        this.in.readFully(bytes);
    }

    @Override
    public void readFully(byte[] bytes, int i, int i1) throws IOException {
        this.bitSet = null;
        this.in.readFully(bytes, i, i1);
    }

    @Override
    public int skipBytes(int i) throws IOException {
        this.bitSet = null;
        return this.in.skipBytes(i);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.bitSet = null;
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        this.bitSet = null;
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.bitSet = null;
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        this.bitSet = null;
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.bitSet = null;
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        this.bitSet = null;
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        this.bitSet = null;
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        this.bitSet = null;
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.bitSet = null;
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.bitSet = null;
        return this.in.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        this.bitSet = null;
        return this.in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        this.bitSet = null;
        return this.in.readUTF();
    }
}

