/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v091.io;

import com.swiftmq.amqp.v091.io.BitSupportDataOutput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;

public class BitSupportDataOutputStream
implements BitSupportDataOutput {
    DataOutput out = null;
    BitSet bitSet = null;
    int nBits = 0;

    public BitSupportDataOutputStream(DataOutput out) {
        this.out = out;
    }

    @Override
    public void writeBit(boolean b) throws IOException {
        if (this.bitSet == null) {
            this.bitSet = new BitSet(8);
        }
        this.bitSet.set(this.nBits++, b);
        if (this.nBits == 8) {
            this.bitFlush();
        }
    }

    @Override
    public void bitFlush() throws IOException {
        if (this.bitSet != null) {
            int b = 0;
            for (int i = 0; i < this.nBits; ++i) {
                if (!this.bitSet.get(i)) continue;
                b = (byte)(b | 1 << i % 8);
            }
            this.out.writeByte(b);
            this.bitSet = null;
            this.nBits = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.bitFlush();
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.bitFlush();
        this.out.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.bitFlush();
        this.out.write(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.bitFlush();
        this.out.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.bitFlush();
        this.out.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.bitFlush();
        this.out.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.bitFlush();
        this.out.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.bitFlush();
        this.out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.bitFlush();
        this.out.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.bitFlush();
        this.out.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.bitFlush();
        this.out.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.bitFlush();
        this.out.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.bitFlush();
        this.out.writeChars(s);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.bitFlush();
        this.out.writeUTF(str);
    }
}

