/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v091.types;

import com.swiftmq.amqp.v091.io.BitSupportDataInput;
import com.swiftmq.amqp.v091.io.BitSupportDataOutput;
import com.swiftmq.amqp.v091.types.Field;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Coder {
    public static String toHex(byte[] bytes, int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(String.format("0x%1$02X ", bytes[i]));
        }
        return sb.toString();
    }

    public static short readShort(byte[] b, int offset) {
        int pos = offset;
        int i1 = b[pos++] & 0xFF;
        int i2 = b[pos++] & 0xFF;
        return (short)((i1 << 8) + (i2 << 0));
    }

    public static int readUnsignedShort(byte[] b, int offset) {
        int pos = offset;
        int i1 = b[pos++] & 0xFF;
        int i2 = b[pos++] & 0xFF;
        return (i1 << 8) + (i2 << 0);
    }

    public static int readInt(byte[] b, int offset) {
        int pos = offset;
        int i1 = b[pos++] & 0xFF;
        int i2 = b[pos++] & 0xFF;
        int i3 = b[pos++] & 0xFF;
        int i4 = b[pos++] & 0xFF;
        int i = (i1 << 24) + (i2 << 16) + (i3 << 8) + (i4 << 0);
        return i;
    }

    public static long readLong(byte[] b, int offset) {
        long l = ((long)Coder.readInt(b, offset) << 32) + ((long)Coder.readInt(b, offset + 4) & 0xFFFFFFFFL);
        return l;
    }

    public static float readFloat(byte[] b, int offset) {
        return Float.intBitsToFloat(Coder.readInt(b, offset));
    }

    public static double readDouble(byte[] b, int offset) {
        return Double.longBitsToDouble(Coder.readLong(b, offset));
    }

    public static void writeShort(int s, byte[] b, int offset) {
        int pos = offset;
        b[pos++] = (byte)(s >>> 8 & 0xFF);
        b[pos++] = (byte)(s >>> 0 & 0xFF);
    }

    public static void writeInt(int i, byte[] b, int offset) {
        int pos = offset;
        b[pos++] = (byte)(i >>> 24 & 0xFF);
        b[pos++] = (byte)(i >>> 16 & 0xFF);
        b[pos++] = (byte)(i >>> 8 & 0xFF);
        b[pos++] = (byte)(i >>> 0 & 0xFF);
    }

    public static void writeLong(long l, byte[] b, int offset) {
        int pos = offset;
        b[pos++] = (byte)(l >>> 56 & 0xFFL);
        b[pos++] = (byte)(l >>> 48 & 0xFFL);
        b[pos++] = (byte)(l >>> 40 & 0xFFL);
        b[pos++] = (byte)(l >>> 32 & 0xFFL);
        b[pos++] = (byte)(l >>> 24 & 0xFFL);
        b[pos++] = (byte)(l >>> 16 & 0xFFL);
        b[pos++] = (byte)(l >>> 8 & 0xFFL);
        b[pos++] = (byte)(l >>> 0 & 0xFFL);
    }

    public static void writeFloat(float v, byte[] b, int offset) {
        Coder.writeInt(Float.floatToIntBits(v), b, offset);
    }

    public static void writeDouble(double v, byte[] b, int offset) {
        Coder.writeLong(Double.doubleToLongBits(v), b, offset);
    }

    public static byte readByte(DataInput in) throws IOException {
        return in.readByte();
    }

    public static boolean readBit(BitSupportDataInput in) throws IOException {
        return in.readBit();
    }

    public static int readUnsignedByte(DataInput in) throws IOException {
        return Coder.readByte(in) & 0xFF;
    }

    public static byte[] readBytes(DataInput in, int len) throws IOException {
        byte[] dest = new byte[len];
        in.readFully(dest);
        return dest;
    }

    public static short readShort(DataInput in) throws IOException {
        return in.readShort();
    }

    public static int readUnsignedShort(DataInput in) throws IOException {
        return in.readUnsignedShort();
    }

    public static int readInt(DataInput in) throws IOException {
        return in.readInt();
    }

    public static long readUnsignedInt(DataInput in) throws IOException {
        return (long)Coder.readInt(in) & 0xFFFFFFFFL;
    }

    public static long readLong(DataInput in) throws IOException {
        return in.readLong();
    }

    public static String readShortString(DataInput in) throws IOException {
        int len = Coder.readUnsignedByte(in);
        Charset charset = Charset.forName("UTF-8");
        String s = charset.decode(ByteBuffer.wrap(Coder.readBytes(in, len))).toString();
        return s;
    }

    public static byte[] readLongString(DataInput in) throws IOException {
        int len = (int)Coder.readUnsignedInt(in);
        return Coder.readBytes(in, len);
    }

    public static float readFloat(DataInput in) throws IOException {
        return Float.intBitsToFloat(Coder.readInt(in));
    }

    public static double readDouble(DataInput in) throws IOException {
        return Double.longBitsToDouble(Coder.readLong(in));
    }

    private static Object readFieldValue(DataInput in) throws IOException {
        Field f = new Field().readContent(in);
        return f;
    }

    public static List readArray(DataInput in) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        DataByteArrayInputStream dbis = new DataByteArrayInputStream(Coder.readLongString(in));
        while (dbis.available() > 0) {
            list.add(Coder.readFieldValue(in));
        }
        return list;
    }

    public static Map<String, Object> readTable(DataInput in) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DataByteArrayInputStream dbis = new DataByteArrayInputStream(Coder.readLongString(in));
        while (dbis.available() > 0) {
            map.put(Coder.readShortString(dbis), Coder.readFieldValue(dbis));
        }
        return map;
    }

    public static void writeShort(int s, DataOutput out) throws IOException {
        out.writeShort(s);
    }

    public static void writeByte(int i, DataOutput out) throws IOException {
        out.writeByte(i);
    }

    public static void writeBit(boolean b, BitSupportDataOutput out) throws IOException {
        out.writeBit(b);
    }

    public static void writeBytes(byte[] src, int srcPos, int srcLen, DataOutput out) throws IOException {
        out.write(src, srcPos, srcLen);
    }

    public static void writeBytes(byte[] src, DataOutput out) throws IOException {
        Coder.writeBytes(src, 0, src.length, out);
    }

    public static void writeInt(int i, DataOutput out) throws IOException {
        out.writeInt(i);
    }

    public static void writeLong(long l, DataOutput out) throws IOException {
        out.writeLong(l);
    }

    public static void writeShortString(String s, DataOutput out) throws IOException {
        Coder.writeByte(s.length(), out);
        Charset charset = Charset.forName("UTF-8");
        ByteBuffer buffer = charset.encode(s);
        buffer.rewind();
        out.write(buffer.array(), 0, buffer.remaining());
    }

    public static void writeLongString(byte[] ls, DataOutput out) throws IOException {
        Coder.writeInt(ls.length, out);
        out.write(ls);
    }

    public static void writeFloat(float v, DataOutput out) throws IOException {
        Coder.writeInt(Float.floatToIntBits(v), out);
    }

    public static void writeDouble(double v, DataOutput out) throws IOException {
        Coder.writeLong(Double.doubleToLongBits(v), out);
    }

    public static void writeArray(List l, DataOutput out) throws IOException {
        if (l == null) {
            Coder.writeInt(0, out);
            return;
        }
        DataByteArrayOutputStream dbos = new DataByteArrayOutputStream();
        for (int i = 0; i < l.size(); ++i) {
            ((Field)l.get(i)).writeContent(dbos);
        }
    }

    public static void writeTable(Map<String, Object> m, DataOutput out) throws IOException {
        if (m == null || m.size() == 0) {
            Coder.writeInt(0, out);
            return;
        }
        DataByteArrayOutputStream dbos = new DataByteArrayOutputStream();
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            Coder.writeShortString(entry.getKey(), dbos);
            ((Field)entry.getValue()).writeContent(dbos);
        }
        Coder.writeInt(dbos.getCount(), out);
        Coder.writeBytes(dbos.getBuffer(), 0, dbos.getCount(), out);
    }
}

