/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v091.types;

import com.swiftmq.amqp.v091.types.Coder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class ContentHeaderProperties {
    Integer classId = null;
    Integer weight = null;
    Long bodySize = null;
    String contentType = null;
    String contentEncoding = null;
    Map<String, Object> headers = null;
    Integer deliveryMode = null;
    Integer priority = null;
    String correlationId = null;
    String replyTo = null;
    String expiration = null;
    String messageId = null;
    Long timestamp = null;
    String type = null;
    String userId = null;
    String appId = null;
    String clusterId = null;
    int flags = 0;
    int cnt = 0;

    public Integer getClassId() {
        return this.classId;
    }

    public void setClassId(Integer classId) {
        this.classId = classId;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public Long getBodySize() {
        return this.bodySize;
    }

    public void setBodySize(Long bodySize) {
        this.bodySize = bodySize;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public Integer getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(Integer deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    private void setFlag(boolean set) {
        if (set) {
            this.flags |= 1 << 15 - this.cnt;
        }
        ++this.cnt;
    }

    public void writeContent(DataOutput out) throws IOException {
        Coder.writeShort(this.classId, out);
        Coder.writeShort(this.weight, out);
        Coder.writeLong(this.bodySize, out);
        this.flags = 0;
        this.setFlag(this.contentType != null);
        this.setFlag(this.contentEncoding != null);
        this.setFlag(this.headers != null && this.headers.size() > 0);
        this.setFlag(this.deliveryMode != null);
        this.setFlag(this.priority != null);
        this.setFlag(this.correlationId != null);
        this.setFlag(this.replyTo != null);
        this.setFlag(this.expiration != null);
        this.setFlag(this.messageId != null);
        this.setFlag(this.timestamp != null);
        this.setFlag(this.type != null);
        this.setFlag(this.userId != null);
        this.setFlag(this.appId != null);
        this.setFlag(this.clusterId != null);
        Coder.writeShort(this.flags, out);
        if (this.contentType != null) {
            Coder.writeShortString(this.contentType, out);
        }
        if (this.contentEncoding != null) {
            Coder.writeShortString(this.contentEncoding, out);
        }
        if (this.headers != null && this.headers.size() > 0) {
            Coder.writeTable(this.headers, out);
        }
        if (this.deliveryMode != null) {
            Coder.writeByte(this.deliveryMode, out);
        }
        if (this.priority != null) {
            Coder.writeByte(this.priority, out);
        }
        if (this.correlationId != null) {
            Coder.writeShortString(this.correlationId, out);
        }
        if (this.replyTo != null) {
            Coder.writeShortString(this.replyTo, out);
        }
        if (this.expiration != null) {
            Coder.writeShortString(this.expiration, out);
        }
        if (this.messageId != null) {
            Coder.writeShortString(this.messageId, out);
        }
        if (this.timestamp != null) {
            Coder.writeLong(this.timestamp, out);
        }
        if (this.type != null) {
            Coder.writeShortString(this.type, out);
        }
        if (this.userId != null) {
            Coder.writeShortString(this.userId, out);
        }
        if (this.appId != null) {
            Coder.writeShortString(this.appId, out);
        }
        if (this.clusterId != null) {
            Coder.writeShortString(this.clusterId, out);
        }
    }

    private boolean isFlagSet(int bit) {
        return (this.flags & 1 << (bit = 15 - bit)) != 0;
    }

    public void readContent(DataInput in) throws IOException {
        this.classId = new Integer(Coder.readShort(in));
        this.weight = new Integer(Coder.readShort(in));
        this.bodySize = new Long(Coder.readLong(in));
        this.flags = Coder.readShort(in);
        if (this.isFlagSet(0)) {
            this.contentType = Coder.readShortString(in);
        }
        if (this.isFlagSet(1)) {
            this.contentEncoding = Coder.readShortString(in);
        }
        if (this.isFlagSet(2)) {
            this.headers = Coder.readTable(in);
        }
        if (this.isFlagSet(3)) {
            this.deliveryMode = new Integer(Coder.readByte(in));
        }
        if (this.isFlagSet(4)) {
            this.priority = new Integer(Coder.readByte(in));
        }
        if (this.isFlagSet(5)) {
            this.correlationId = Coder.readShortString(in);
        }
        if (this.isFlagSet(6)) {
            this.replyTo = Coder.readShortString(in);
        }
        if (this.isFlagSet(7)) {
            this.expiration = Coder.readShortString(in);
        }
        if (this.isFlagSet(8)) {
            this.messageId = Coder.readShortString(in);
        }
        if (this.isFlagSet(9)) {
            this.timestamp = Coder.readLong(in);
        }
        if (this.isFlagSet(10)) {
            this.type = Coder.readShortString(in);
        }
        if (this.isFlagSet(11)) {
            this.userId = Coder.readShortString(in);
        }
        if (this.isFlagSet(12)) {
            this.appId = Coder.readShortString(in);
        }
        if (this.isFlagSet(13)) {
            this.clusterId = Coder.readShortString(in);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ContentHeaderProperties");
        sb.append(" classId=").append(this.classId);
        sb.append(", weight=").append(this.weight);
        sb.append(", bodySize=").append(this.bodySize);
        sb.append(", contentType='").append(this.contentType).append('\'');
        sb.append(", contentEncoding='").append(this.contentEncoding).append('\'');
        sb.append(", headers=").append(this.headers);
        sb.append(", deliveryMode=").append(this.deliveryMode);
        sb.append(", priority=").append(this.priority);
        sb.append(", correlationId='").append(this.correlationId).append('\'');
        sb.append(", replyTo='").append(this.replyTo).append('\'');
        sb.append(", expiration='").append(this.expiration).append('\'');
        sb.append(", messageId='").append(this.messageId).append('\'');
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", type='").append(this.type).append('\'');
        sb.append(", userId='").append(this.userId).append('\'');
        sb.append(", appId='").append(this.appId).append('\'');
        sb.append(", clusterId='").append(this.clusterId).append('\'');
        sb.append(", flags=").append(this.flags);
        sb.append(", cnt=").append(this.cnt);
        sb.append(']');
        return sb.toString();
    }
}

