/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v091.types;

import com.swiftmq.amqp.v091.types.Coder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class Field {
    int type = 86;
    Object value = null;
    String svalue = null;

    public Field(int type, Object value) {
        this.type = type;
        this.value = value;
    }

    public Field() {
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getStringValue() {
        return this.svalue;
    }

    public Field readContent(DataInput in) throws IOException {
        this.type = in.readUnsignedByte();
        switch (this.type) {
            case 116: {
                this.value = new Boolean(in.readBoolean());
                break;
            }
            case 98: {
                this.value = new Integer(in.readByte());
                break;
            }
            case 66: {
                this.value = new Integer(in.readUnsignedByte());
                break;
            }
            case 85: {
                this.value = new Integer(Coder.readShort(in));
                break;
            }
            case 117: {
                this.value = new Integer(Coder.readUnsignedShort(in));
                break;
            }
            case 73: {
                this.value = new Integer(in.readInt());
                break;
            }
            case 105: {
                this.value = new Long(Coder.readUnsignedInt(in));
                break;
            }
            case 76: {
                this.value = new Long(Coder.readLong(in));
                break;
            }
            case 108: {
                byte[] b = new byte[8];
                in.readFully(b);
                this.value = b;
                break;
            }
            case 102: {
                this.value = new Float(Coder.readFloat(in));
                break;
            }
            case 100: {
                this.value = new Double(Coder.readDouble(in));
                break;
            }
            case 68: {
                byte[] d = new byte[5];
                in.readFully(d);
                this.value = d;
                break;
            }
            case 115: {
                this.value = Coder.readShort(in);
                break;
            }
            case 83: {
                this.value = Coder.readLongString(in);
                Charset charset = Charset.forName("UTF-8");
                this.svalue = charset.decode(ByteBuffer.wrap((byte[])this.value)).toString();
                break;
            }
            case 65: {
                this.value = Coder.readArray(in);
                break;
            }
            case 84: {
                this.value = Coder.readLong(in);
                break;
            }
            case 70: {
                this.value = Coder.readTable(in);
                break;
            }
        }
        return this;
    }

    public void writeContent(DataOutput out) throws IOException {
        out.writeByte(this.type);
        switch (this.type) {
            case 116: {
                Coder.writeByte((Boolean)this.value != false ? 1 : 0, out);
                break;
            }
            case 98: {
                Coder.writeByte(((Integer)this.value).byteValue(), out);
                break;
            }
            case 66: {
                Coder.writeByte((Integer)this.value, out);
                break;
            }
            case 85: {
                Coder.writeShort(((Integer)this.value).shortValue(), out);
                break;
            }
            case 117: {
                Coder.writeShort((Integer)this.value, out);
                break;
            }
            case 73: {
                Coder.writeInt((Integer)this.value, out);
                break;
            }
            case 105: {
                Coder.writeInt(((Long)this.value).intValue(), out);
                break;
            }
            case 76: {
                Coder.writeLong((Long)this.value, out);
                break;
            }
            case 108: {
                Coder.writeBytes((byte[])this.value, out);
                break;
            }
            case 102: {
                Coder.writeFloat(((Float)this.value).floatValue(), out);
                break;
            }
            case 100: {
                Coder.writeDouble((Double)this.value, out);
                break;
            }
            case 68: {
                Coder.writeBytes((byte[])this.value, out);
                break;
            }
            case 115: {
                Coder.writeShort(((Short)this.value).shortValue(), out);
                break;
            }
            case 83: {
                Coder.writeLongString((byte[])this.value, out);
                break;
            }
            case 65: {
                Coder.writeArray((List)this.value, out);
                break;
            }
            case 84: {
                Coder.writeLong((Long)this.value, out);
                break;
            }
            case 70: {
                Coder.writeTable((Map)this.value, out);
                break;
            }
        }
    }

    public String toString() {
        return "[Field type=" + (char)this.type + ", value=" + (this.svalue != null ? this.svalue : this.value) + "]";
    }
}

