/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v091.types;

import com.swiftmq.amqp.Writable;
import com.swiftmq.amqp.v091.generated.MethodReader;
import com.swiftmq.amqp.v091.types.Coder;
import com.swiftmq.amqp.v091.types.ContentHeaderProperties;
import com.swiftmq.tools.concurrent.AsyncCompletionCallback;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Frame
implements Writable {
    public static final int TYPE_METHOD = 1;
    public static final int TYPE_HEADER = 2;
    public static final int TYPE_BODY = 3;
    public static final int TYPE_HEARTBEAT = 8;
    public static final int FRAME_END = 206;
    int type = 0;
    int channel = 0;
    int size = 0;
    byte[] payload = null;
    Object payloadObject = null;
    int maxFrameSize = 0;
    Semaphore semaphore = null;
    AsyncCompletionCallback callback = null;

    public Frame(int type, int channel, int size, byte[] payload) {
        this.type = type;
        this.channel = channel;
        this.size = size;
        this.payload = payload;
    }

    public Frame(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public Frame generatePayloadObject() throws IOException {
        if (this.payloadObject != null || this.payload == null) {
            return this;
        }
        DataByteArrayInputStream dbis = new DataByteArrayInputStream();
        dbis.setBuffer(this.payload);
        switch (this.type) {
            case 1: {
                this.payloadObject = MethodReader.createMethod(dbis);
                break;
            }
            case 2: {
                ContentHeaderProperties prop = new ContentHeaderProperties();
                prop.readContent(dbis);
                this.payloadObject = prop;
                break;
            }
        }
        return this;
    }

    public Object getPayloadObject() throws IOException {
        if (this.payloadObject == null) {
            this.generatePayloadObject();
        }
        return this.payloadObject;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    @Override
    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    public void setSemaphore(Semaphore semaphore) {
        this.semaphore = semaphore;
    }

    @Override
    public AsyncCompletionCallback getCallback() {
        return this.callback;
    }

    public void setCallback(AsyncCompletionCallback callback) {
        this.callback = callback;
    }

    public void readContent(DataInput in) throws IOException {
        int fe;
        this.type = Coder.readByte(in);
        this.channel = Coder.readShort(in);
        this.size = Coder.readInt(in);
        if (this.type != 8) {
            if (this.size > 0) {
                if (this.size + 4 > this.maxFrameSize) {
                    throw new IOException("frame size (" + (this.size + 4) + ") exceeds max frame size (" + this.maxFrameSize + ")");
                }
                this.payload = Coder.readBytes(in, this.size);
            } else {
                this.payload = null;
            }
        }
        if ((fe = Coder.readUnsignedByte(in)) != 206) {
            throw new IOException("Invalid frame end detected: " + fe);
        }
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        Coder.writeByte(this.type, out);
        Coder.writeShort(this.channel, out);
        Coder.writeInt(this.size, out);
        if (this.type != 8 && this.payload != null) {
            Coder.writeBytes(this.payload, 0, this.size, out);
        }
        Coder.writeByte(206, out);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Frame");
        sb.append(" type=").append(this.type);
        sb.append(", channel=").append(this.channel);
        if (this.type != 8) {
            sb.append(", size=").append(this.size);
            if (this.type != 3) {
                sb.append(", payloadObject=").append(this.payloadObject == null ? "null" : this.payloadObject);
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

