/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.client;

import com.swiftmq.amqp.AMQPContext;
import com.swiftmq.amqp.OutboundHandler;
import com.swiftmq.amqp.Writable;
import com.swiftmq.amqp.integration.Tracer;
import com.swiftmq.amqp.v100.client.AuthenticationException;
import com.swiftmq.amqp.v100.client.ConnectionClosedException;
import com.swiftmq.amqp.v100.client.ConnectionDispatcher;
import com.swiftmq.amqp.v100.client.ExceptionListener;
import com.swiftmq.amqp.v100.client.Session;
import com.swiftmq.amqp.v100.client.SessionHandshakeException;
import com.swiftmq.amqp.v100.client.UnsupportedProtocolVersionException;
import com.swiftmq.amqp.v100.client.po.POAuthenticate;
import com.swiftmq.amqp.v100.client.po.POOpen;
import com.swiftmq.amqp.v100.client.po.POProtocolRequest;
import com.swiftmq.amqp.v100.client.po.POSendClose;
import com.swiftmq.amqp.v100.transport.AMQPFrame;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.Util;
import com.swiftmq.net.PlainSocketFactory;
import com.swiftmq.net.SocketFactory;
import com.swiftmq.net.SocketFactory2;
import com.swiftmq.net.client.BlockingConnection;
import com.swiftmq.net.client.ExceptionHandler;
import com.swiftmq.net.protocol.ProtocolInputHandler;
import com.swiftmq.net.protocol.ProtocolOutputHandler;
import com.swiftmq.net.protocol.raw.RawOutputHandler;
import com.swiftmq.swiftlet.threadpool.AsyncTask;
import com.swiftmq.swiftlet.threadpool.ThreadPool;
import com.swiftmq.tools.collection.ArrayListTool;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.pipeline.POObject;
import com.swiftmq.tools.queue.SingleProcessorQueue;
import com.swiftmq.tools.util.DataStreamOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Connection
implements ExceptionHandler {
    AMQPContext ctx = null;
    Tracer fTracer = null;
    String hostname = null;
    String openHostname = System.getProperty("swiftmq.amqp.open.hostname");
    int port;
    String mechanism = "PLAIN";
    String userName = null;
    String password = null;
    long idleTimeout = Integer.MAX_VALUE;
    long maxFrameSize = Integer.MAX_VALUE;
    com.swiftmq.net.client.Connection networkConnection = null;
    ConnectionDispatcher connectionDispatcher = null;
    ThreadPool connectionPool = null;
    ConnectionQueue connectionQueue = null;
    ConnectionTask connectionTask = null;
    DataStreamOutputStream dos = null;
    volatile boolean closed = false;
    ArrayList localChannels = new ArrayList();
    ArrayList remoteChannels = new ArrayList();
    Lock lock = new ReentrantLock();
    boolean doAuth = true;
    String containerId = null;
    boolean containerIdSet = false;
    boolean connected = false;
    int inputBufferSize = 131072;
    int inputBufferExtendSize = 65536;
    int outputBufferSize = 131072;
    int outputBufferExtendSize = 65536;
    SocketFactory socketFactory = new PlainSocketFactory();
    ExceptionListener exceptionListener = null;

    public Connection(AMQPContext ctx, String hostname, int port, String userName, String password) {
        this.ctx = ctx;
        this.hostname = hostname;
        this.port = port;
        this.userName = userName;
        this.password = password;
        String myHostname = "unknown";
        try {
            myHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.containerId = UUID.randomUUID().toString() + "@" + myHostname;
        this.fTracer = ctx.getFrameTracer();
    }

    public Connection(AMQPContext ctx, String hostname, int port, boolean doAuth) {
        this(ctx, hostname, port, null, null);
        this.doAuth = doAuth;
    }

    private void verifyState() throws ConnectionClosedException {
        if (this.closed) {
            throw new ConnectionClosedException("Connection is closed");
        }
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public long getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(long maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public void setMechanism(String mechanism) {
        this.mechanism = mechanism;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
        this.containerIdSet = true;
    }

    public String getOpenHostname() {
        return this.openHostname;
    }

    public void setOpenHostname(String openHostname) {
        this.openHostname = openHostname;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    public int getInputBufferExtendSize() {
        return this.inputBufferExtendSize;
    }

    public void setInputBufferExtendSize(int inputBufferExtendSize) {
        this.inputBufferExtendSize = inputBufferExtendSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public void setOutputBufferSize(int outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    public int getOutputBufferExtendSize() {
        return this.outputBufferExtendSize;
    }

    public void setOutputBufferExtendSize(int outputBufferExtendSize) {
        this.outputBufferExtendSize = outputBufferExtendSize;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public String getUserName() {
        return this.userName;
    }

    public void connect() throws IOException, UnsupportedProtocolVersionException, AuthenticationException, ConnectionClosedException {
        POObject po;
        Semaphore sem;
        this.verifyState();
        this.connectionDispatcher = new ConnectionDispatcher(this.ctx, this.hostname);
        if (this.socketFactory instanceof SocketFactory2) {
            ((SocketFactory2)this.socketFactory).setReceiveBufferSize(this.inputBufferSize);
        }
        this.networkConnection = new BlockingConnection(this.socketFactory.createSocket(this.hostname, this.port), this.connectionDispatcher, this){

            @Override
            protected ProtocolOutputHandler createOutputHandler(int outputBufferSize, int outputExtendSize) {
                return new RawOutputHandler(outputBufferSize, outputExtendSize){

                    @Override
                    public void flush() throws IOException {
                        super.flush();
                        this.invokeOutputListener();
                    }
                };
            }

            @Override
            protected ProtocolInputHandler createInputHandler() {
                return Connection.this.connectionDispatcher.getProtocolHandler();
            }
        };
        this.connectionDispatcher.setMyConnection(this);
        this.networkConnection.start();
        this.dos = new DataStreamOutputStream(this.networkConnection.getOutputStream());
        this.connectionPool = this.ctx.getConnectionPool();
        this.connectionTask = new ConnectionTask();
        this.connectionQueue = new ConnectionQueue();
        this.connectionDispatcher.setOutboundHandler(this.connectionQueue);
        this.connectionQueue.startQueue();
        if (this.doAuth) {
            this.connectionDispatcher.setSaslActive(true);
            sem = new Semaphore();
            po = new POProtocolRequest(sem, Util.SASL_INIT);
            this.connectionDispatcher.dispatch(po);
            sem.waitHere();
            sem.reset();
            if (!po.isSuccess()) {
                this.cancel();
                throw new UnsupportedProtocolVersionException(po.getException());
            }
            po = new POAuthenticate(sem, this.mechanism, this.userName, this.password);
            this.connectionDispatcher.dispatch(po);
            sem.waitHere();
            sem.reset();
            if (!po.isSuccess()) {
                this.cancel();
                throw new AuthenticationException(po.getException());
            }
        }
        sem = new Semaphore();
        po = new POProtocolRequest(sem, Util.AMQP_INIT);
        this.connectionDispatcher.dispatch(po);
        sem.waitHere();
        sem.reset();
        if (!po.isSuccess()) {
            this.cancel();
            throw new UnsupportedProtocolVersionException(po.getException());
        }
        po = new POOpen(sem, this.containerId, this.maxFrameSize, 255, this.idleTimeout);
        this.connectionDispatcher.dispatch(po);
        sem.waitHere();
        sem.reset();
        if (!po.isSuccess()) {
            this.cancel();
            throw new IOException(po.getException());
        }
        this.connected = true;
    }

    @Override
    public void onException(final IOException e) {
        new Thread(){

            @Override
            public void run() {
                Connection.this.cancel();
                if (Connection.this.exceptionListener != null) {
                    Connection.this.exceptionListener.onException(new ConnectionClosedException(e.toString()));
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session mapSessionToLocalChannel(long incomingWindowSize, long outgoingWindowSize) {
        try {
            this.lock.lock();
            Session session = new Session(this.ctx, this, incomingWindowSize, outgoingWindowSize);
            session.setChannel(ArrayListTool.setFirstFreeOrExpand(this.localChannels, session));
            Session session2 = session;
            return session2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Session createSession(long incomingWindowSize, long outgoingWindowSize) throws SessionHandshakeException, ConnectionClosedException {
        this.verifyState();
        if (!this.connected) {
            throw new SessionHandshakeException("Connection is not connected, call 'connect()'");
        }
        Session session = this.mapSessionToLocalChannel(incomingWindowSize, outgoingWindowSize);
        session.finishHandshake();
        return session;
    }

    protected void removeSession(Session session) {
        try {
            this.lock.lock();
            this.localChannels.set(session.getChannel(), null);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Session getSessionForLocalChannel(int localChannel) {
        try {
            this.lock.lock();
            if (localChannel >= 0 && localChannel < this.localChannels.size()) {
                Session session = (Session)this.localChannels.get(localChannel);
                return session;
            }
            Session session = null;
            return session;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void mapSessionToRemoteChannel(Session session, int remoteChannel) {
        try {
            this.lock.lock();
            Util.ensureSize(this.remoteChannels, remoteChannel + 1);
            this.remoteChannels.set(remoteChannel, session);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void unmapSessionFromRemoteChannel(int remoteChannel) {
        try {
            this.lock.lock();
            Util.ensureSize(this.remoteChannels, remoteChannel + 1);
            this.remoteChannels.set(remoteChannel, null);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Session getSessionForRemoteChannel(int remoteChannel) {
        try {
            this.lock.lock();
            if (remoteChannel >= 0 && remoteChannel < this.remoteChannels.size()) {
                Session session = (Session)this.remoteChannels.get(remoteChannel);
                return session;
            }
            Session session = null;
            return session;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected OutboundHandler getOutboundHandler() {
        return this.connectionQueue;
    }

    public void cancel() {
        if (this.closed) {
            return;
        }
        List cloned = null;
        try {
            this.lock.lock();
            if (this.closed) {
                return;
            }
            cloned = (List)this.localChannels.clone();
        }
        finally {
            this.lock.unlock();
        }
        for (int i = 0; i < cloned.size(); ++i) {
            Session session = (Session)cloned.get(i);
            if (session == null) continue;
            session.cancel();
        }
        if (this.connectionDispatcher != null) {
            this.connectionDispatcher.close();
        }
        if (this.connectionQueue != null) {
            this.connectionQueue.stopQueue();
        }
        if (this.networkConnection != null) {
            this.networkConnection.close();
        }
        this.closed = true;
    }

    public void close() {
        this.close(null, null);
    }

    protected void close(String condition, String description) {
        if (this.closed) {
            return;
        }
        if (condition == null) {
            Semaphore sem = new Semaphore();
            POSendClose po = new POSendClose(sem, condition == null ? null : new AMQPSymbol(condition), description == null ? null : new AMQPString(description));
            this.connectionDispatcher.dispatch(po);
            sem.waitHere();
        } else {
            POSendClose po = new POSendClose(null, condition == null ? null : new AMQPSymbol(condition), description == null ? null : new AMQPString(description));
            this.connectionDispatcher.dispatch(po);
        }
        this.cancel();
        if (this.exceptionListener != null && condition != null && description != null) {
            this.exceptionListener.onException(new ConnectionClosedException(condition + " / " + description));
        }
    }

    private class ConnectionTask
    implements AsyncTask {
        private ConnectionTask() {
        }

        @Override
        public boolean isValid() {
            return !Connection.this.closed;
        }

        @Override
        public String getDispatchToken() {
            return "connectiontask";
        }

        @Override
        public String getDescription() {
            return "Connection/ConnectionTask";
        }

        @Override
        public void run() {
            if (!Connection.this.closed && Connection.this.connectionQueue.dequeue()) {
                Connection.this.connectionPool.dispatchTask(this);
            }
        }

        @Override
        public void stop() {
        }
    }

    private class ConnectionQueue
    extends SingleProcessorQueue
    implements OutboundHandler {
        public ConnectionQueue() {
            super(100);
        }

        @Override
        protected void startProcessor() {
            if (!Connection.this.closed) {
                Connection.this.connectionPool.dispatchTask(Connection.this.connectionTask);
            }
        }

        @Override
        public void send(Writable writable) {
            this.enqueue(writable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(Object[] bulk, int n) {
            try {
                for (int i = 0; i < n; ++i) {
                    ((Writable)bulk[i]).writeContent(Connection.this.dos);
                    if (!Connection.this.fTracer.isEnabled()) continue;
                    if (bulk[i] instanceof AMQPFrame) {
                        Connection.this.fTracer.trace("amqp", "SND[" + ((AMQPFrame)bulk[i]).getChannel() + "] (size=" + ((AMQPFrame)bulk[i]).getPredictedSize() + "): " + bulk[i]);
                        continue;
                    }
                    Connection.this.fTracer.trace("amqp", "SND: " + bulk[i]);
                }
                Connection.this.dos.flush();
            }
            catch (Exception e) {
                Connection.this.cancel();
            }
            finally {
                for (int i = 0; i < n; ++i) {
                    Writable w = (Writable)bulk[i];
                    if (w.getSemaphore() != null) {
                        w.getSemaphore().notifySingleWaiter();
                        continue;
                    }
                    if (w.getCallback() == null) continue;
                    w.getCallback().done(true);
                }
            }
        }
    }
}

