/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.client;

import com.swiftmq.amqp.AMQPContext;
import com.swiftmq.amqp.OutboundHandler;
import com.swiftmq.amqp.ProtocolHeader;
import com.swiftmq.amqp.integration.Tracer;
import com.swiftmq.amqp.v100.client.Connection;
import com.swiftmq.amqp.v100.client.Session;
import com.swiftmq.amqp.v100.client.po.POAuthenticate;
import com.swiftmq.amqp.v100.client.po.POCheckIdleTimeout;
import com.swiftmq.amqp.v100.client.po.POConnectionClose;
import com.swiftmq.amqp.v100.client.po.POConnectionFrameReceived;
import com.swiftmq.amqp.v100.client.po.POOpen;
import com.swiftmq.amqp.v100.client.po.POProtocolRequest;
import com.swiftmq.amqp.v100.client.po.POProtocolResponse;
import com.swiftmq.amqp.v100.client.po.PORemoteSessionClose;
import com.swiftmq.amqp.v100.client.po.POSendClose;
import com.swiftmq.amqp.v100.client.po.POSendHeartBeat;
import com.swiftmq.amqp.v100.client.po.POSessionFrameReceived;
import com.swiftmq.amqp.v100.generated.FrameReader;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslChallengeFrame;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslCode;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslFrameIF;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslFrameVisitor;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslInitFrame;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslMechanismsFrame;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslOutcomeFrame;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslResponseFrame;
import com.swiftmq.amqp.v100.generated.transport.definitions.ConnectionError;
import com.swiftmq.amqp.v100.generated.transport.definitions.Error;
import com.swiftmq.amqp.v100.generated.transport.definitions.ErrorConditionFactory;
import com.swiftmq.amqp.v100.generated.transport.definitions.Milliseconds;
import com.swiftmq.amqp.v100.generated.transport.performatives.AttachFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.BeginFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.CloseFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.DetachFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.DispositionFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.EndFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.FlowFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameIF;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameVisitor;
import com.swiftmq.amqp.v100.generated.transport.performatives.OpenFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.TransferFrame;
import com.swiftmq.amqp.v100.transport.AMQPFrame;
import com.swiftmq.amqp.v100.transport.HeartbeatFrame;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBinary;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedShort;
import com.swiftmq.net.client.InboundHandler;
import com.swiftmq.net.protocol.amqp.AMQPInputHandler;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.pipeline.POObject;
import com.swiftmq.tools.pipeline.PipelineQueue;
import com.swiftmq.tools.timer.TimerEvent;
import com.swiftmq.tools.timer.TimerListener;
import com.swiftmq.tools.timer.TimerRegistry;
import com.swiftmq.tools.util.LengthCaptureDataInput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class ConnectionDispatcher
implements com.swiftmq.amqp.v100.client.ConnectionVisitor,
InboundHandler {
    static final HeartbeatFrame HEARTBEAT_FRAME = new HeartbeatFrame(0);
    AMQPContext ctx = null;
    Tracer fTracer = null;
    Tracer pTracer = null;
    Connection myConnection = null;
    String remoteHostname = null;
    String localHostname = null;
    OutboundHandler outboundHandler = null;
    PipelineQueue pipelineQueue = null;
    DispatchVisitor dispatchVisitor = new DispatchVisitor();
    ConnectionVisitor connectionVisitor = new ConnectionVisitor();
    AMQPInputHandler protocolHandler = new AMQPInputHandler();
    volatile boolean closed = false;
    volatile boolean closeInProgress = false;
    Lock closeLock = new ReentrantLock();
    volatile boolean awaitProtocolHeader = true;
    ProtocolHeader localProt = null;
    ProtocolHeader remoteProt = null;
    POProtocolRequest protPO = null;
    POAuthenticate authPO = null;
    POOpen openPO = null;
    OpenFrame remoteOpen = null;
    POSendClose closePO = null;
    CloseFrame remoteClose = null;
    SaslMechanismsFrame saslMechanisms = null;
    boolean saslActive = false;
    volatile long lastActivity = System.currentTimeMillis();
    long myIdleTimeout = -1L;
    TimerListener heartBeatSender = null;
    long heartBeatDelay = 0L;
    TimerListener idleTimeoutChecker = null;
    long idleTimeoutDelay = 0L;
    SaslClient saslClient = null;
    volatile boolean connectionDisabled = false;
    int maxLocalFrameSize = Integer.MAX_VALUE;
    int maxRemoteFrameSize = Integer.MAX_VALUE;

    public ConnectionDispatcher(AMQPContext ctx, String remoteHostname) {
        this.ctx = ctx;
        this.remoteHostname = remoteHostname;
        this.fTracer = ctx.getFrameTracer();
        this.pTracer = ctx.getProcessingTracer();
        try {
            this.localHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.localHostname = "unknown";
        }
        this.pipelineQueue = new PipelineQueue(ctx.getConnectionPool(), "ConnectionDispatcher", this);
    }

    private static boolean hasValue(AMQPType[] t, String value) throws IOException {
        for (int i = 0; i < t.length; ++i) {
            if (!((AMQPSymbol)t[i]).getValue().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public AMQPInputHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public void setMyConnection(Connection myConnection) {
        this.myConnection = myConnection;
    }

    public void setOutboundHandler(OutboundHandler outboundHandler) {
        this.outboundHandler = outboundHandler;
    }

    public int getMaxFrameSize() {
        return Math.max(512, Math.min(this.maxLocalFrameSize, this.maxRemoteFrameSize));
    }

    public void setSaslActive(boolean saslActive) {
        this.saslActive = saslActive;
    }

    private void checkCompatibility() {
        if (this.localProt != null && this.remoteProt != null) {
            if (!this.localProt.equals(this.remoteProt)) {
                this.protPO.setSuccess(false);
                this.protPO.setException("Incompatible AMQP protocols. Local=" + this.localProt + ", remote=" + this.remoteProt);
            } else {
                this.protPO.setSuccess(true);
            }
            this.localProt = null;
            this.remoteProt = null;
            if (this.protPO != null) {
                this.protPO.getSemaphore().notifySingleWaiter();
            }
            this.protPO = null;
        }
    }

    private void checkStartSaslInit() {
        AMQPArray mechanisms;
        if (this.authPO != null && this.saslMechanisms != null && (mechanisms = this.saslMechanisms.getSaslServerMechanisms()) != null) {
            try {
                AMQPType[] t = mechanisms.getValue();
                if (this.authPO.getUsername() != null && this.authPO.getPassword() != null) {
                    if (ConnectionDispatcher.hasValue(t, this.authPO.getMechanism())) {
                        this.saslClient = Sasl.createSaslClient(new String[]{this.authPO.getMechanism()}, null, "amqp", this.remoteHostname, null, new CBHandler(this.authPO.getUsername(), this.authPO.getPassword()));
                        byte[] response = this.saslClient.hasInitialResponse() ? this.saslClient.evaluateChallenge(new byte[0]) : null;
                        SaslInitFrame initFrame = new SaslInitFrame(0);
                        initFrame.setMechanism(new AMQPSymbol(this.authPO.getMechanism()));
                        initFrame.setHostname(new AMQPString(this.myConnection.hostname));
                        if (response != null) {
                            initFrame.setInitialResponse(new AMQPBinary(response));
                        }
                        this.outboundHandler.send(initFrame);
                        this.saslMechanisms = null;
                    } else {
                        this.authPO.setSuccess(false);
                        this.authPO.setException("Server doesn't support security mechanisms '" + this.authPO.getMechanism() + "'");
                        this.authPO.getSemaphore().notifySingleWaiter();
                        this.authPO = null;
                    }
                    this.saslMechanisms = null;
                } else if (ConnectionDispatcher.hasValue(t, "ANONYMOUS")) {
                    SaslInitFrame initFrame = new SaslInitFrame(0);
                    initFrame.setMechanism(new AMQPSymbol("ANONYMOUS"));
                    initFrame.setHostname(new AMQPString(this.localHostname));
                    this.outboundHandler.send(initFrame);
                    this.saslMechanisms = null;
                } else {
                    this.authPO.setSuccess(false);
                    this.authPO.setException("Remote server doesn't support ANONYMOUS login");
                    this.authPO.getSemaphore().notifySingleWaiter();
                    this.authPO = null;
                    this.saslMechanisms = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void checkBothSidesOpen() {
        if (this.openPO != null && this.remoteOpen != null) {
            this.openPO.setSuccess(true);
            this.openPO.getSemaphore().notifySingleWaiter();
            this.openPO = null;
        }
    }

    private void checkBothSidesClosed() {
        if (this.closePO != null && this.remoteClose != null) {
            this.closePO.setSuccess(true);
            this.closePO.getSemaphore().notifySingleWaiter();
            this.closePO = null;
            this.remoteClose = null;
        }
    }

    private void notifyWaitingPOs(POObject[] po) {
        for (int i = 0; i < po.length; ++i) {
            if (po[i] == null) continue;
            po[i].setSuccess(false);
            if (po[i].getException() == null) {
                po[i].setException("Connection was asynchronously closed");
            }
            po[i].getSemaphore().notifySingleWaiter();
        }
    }

    private void dispatchSession(int remoteChannel, POObject po) {
        Session session = this.myConnection.getSessionForRemoteChannel(remoteChannel);
        if (session != null) {
            session.dispatch(po);
        } else if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", invalid channel (no associated session): " + remoteChannel);
        }
    }

    public void dispatch(POObject po) {
        this.pipelineQueue.enqueue(po);
    }

    @Override
    public void dataAvailable(LengthCaptureDataInput in) {
        try {
            if (this.connectionDisabled) {
                if (this.fTracer.isEnabled()) {
                    this.fTracer.trace(this.toString(), "Connection is disabled, ignore inbound traffic");
                }
                return;
            }
            this.lastActivity = System.currentTimeMillis();
            if (this.awaitProtocolHeader) {
                ProtocolHeader header = new ProtocolHeader();
                header.readContent(in);
                this.awaitProtocolHeader = false;
                this.protocolHandler.setProtHeaderExpected(false);
                if (this.fTracer.isEnabled()) {
                    this.fTracer.trace("amqp", "RCV: " + header);
                }
                this.dispatch(new POProtocolResponse(header));
            } else if (this.saslActive) {
                SaslFrameIF frame = FrameReader.createSaslFrame(in);
                int size = frame.getPredictedSize();
                if (size > this.maxLocalFrameSize) {
                    if (this.fTracer.isEnabled()) {
                        this.fTracer.trace(this.toString(), ", dataAvailable, Frame size (" + size + ") > max frame size (" + this.maxLocalFrameSize + ")");
                    }
                    this.connectionDisabled = true;
                    new Disconnecter(ConnectionError.FRAMING_ERROR.getValue(), "Frame size (" + size + ") > max frame size (" + this.maxLocalFrameSize + ")").start();
                } else {
                    if (this.fTracer.isEnabled()) {
                        this.fTracer.trace("amqp", "RCV[" + ((AMQPFrame)frame).getChannel() + "] (size=" + size + "): " + frame);
                    }
                    frame.accept(this.dispatchVisitor);
                }
            } else {
                FrameIF frame = FrameReader.createFrame(in);
                int size = frame.getPredictedSize();
                if (size > this.maxLocalFrameSize) {
                    if (this.fTracer.isEnabled()) {
                        this.fTracer.trace(this.toString(), ", dataAvailable, Frame size (" + size + ") > max frame size (" + this.maxLocalFrameSize + ")");
                    }
                    this.connectionDisabled = true;
                    new Disconnecter(ConnectionError.FRAMING_ERROR.getValue(), "Frame size (" + size + ") > max frame size (" + this.maxLocalFrameSize + ")").start();
                } else {
                    if (this.fTracer.isEnabled()) {
                        this.fTracer.trace("amqp", "RCV[" + ((AMQPFrame)frame).getChannel() + "] (size=" + size + "): " + frame + (((AMQPFrame)frame).getPayload() != null ? " | payload size=" + ((AMQPFrame)frame).getPayload().length : ""));
                    }
                    frame.accept(this.dispatchVisitor);
                }
            }
        }
        catch (Exception e) {
            new Disconnecter(ConnectionError.FRAMING_ERROR.getValue(), e.toString()).start();
        }
    }

    @Override
    public void visit(POProtocolRequest po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        this.localProt = po.getHeader();
        this.protPO = po;
        this.outboundHandler.send(this.localProt);
        this.checkCompatibility();
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POProtocolResponse po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        this.remoteProt = po.getHeader();
        this.checkCompatibility();
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POAuthenticate po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        this.authPO = po;
        this.checkStartSaslInit();
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POOpen po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        this.openPO = po;
        try {
            OpenFrame openFrame = new OpenFrame(0);
            openFrame.setContainerId(new AMQPString(po.getContainerId()));
            openFrame.setChannelMax(new AMQPUnsignedShort(po.getMaxChannel()));
            if (this.myConnection.getOpenHostname() == null) {
                openFrame.setHostname(new AMQPString(this.remoteHostname));
            } else {
                openFrame.setHostname(new AMQPString(this.myConnection.getOpenHostname()));
            }
            this.maxLocalFrameSize = po.getMaxFrameSize() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)po.getMaxFrameSize();
            openFrame.setMaxFrameSize(new AMQPUnsignedInt(this.maxLocalFrameSize));
            this.myIdleTimeout = po.getIdleTimeout();
            if (this.myIdleTimeout > 0L) {
                openFrame.setIdleTimeOut(new Milliseconds(this.myIdleTimeout));
                this.idleTimeoutDelay = po.getIdleTimeout() / 2L;
                this.idleTimeoutChecker = new TimerListener(){

                    @Override
                    public void performTimeAction(TimerEvent evt) {
                        ConnectionDispatcher.this.dispatch(new POCheckIdleTimeout(null));
                    }
                };
                TimerRegistry.Singleton().addTimerListener(this.idleTimeoutDelay, this.idleTimeoutChecker);
            }
            this.outboundHandler.send(openFrame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.checkBothSidesOpen();
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POConnectionFrameReceived po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        if (po.isSasl()) {
            po.getFrame().accept(this.connectionVisitor);
        } else {
            po.getFrame().accept(this.connectionVisitor);
        }
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POSendHeartBeat po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        this.outboundHandler.send(HEARTBEAT_FRAME);
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POCheckIdleTimeout po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        long to = this.lastActivity + this.myIdleTimeout;
        if (System.currentTimeMillis() > to) {
            this.pTracer.trace(this.toString(), ", idleTimeout reached (" + this.myIdleTimeout + " ms). Closing connection!");
            new Disconnecter(ConnectionError.CONNECTION_FORCED.getValue(), "IdleTimeout reached (" + this.myIdleTimeout + " ms). Closing connection!").start();
        }
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POSendClose po) {
        block7: {
            if (this.pTracer.isEnabled()) {
                this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
            }
            if (po.getSemaphore() != null) {
                this.closePO = po;
            }
            try {
                CloseFrame closeFrame = new CloseFrame(0);
                if (po.getCondition() != null) {
                    Error error = new Error();
                    error.setCondition(ErrorConditionFactory.create(po.getCondition()));
                    if (po.getDescription() != null) {
                        error.setDescription(po.getDescription());
                    }
                    closeFrame.setError(error);
                }
                Semaphore sem = new Semaphore();
                closeFrame.setSemaphore(sem);
                this.outboundHandler.send(closeFrame);
                sem.waitHere();
            }
            catch (Exception e) {
                if (po.getSemaphore() == null) break block7;
                po.setException(e.toString());
                po.setSuccess(false);
                po.getSemaphore().notifySingleWaiter();
            }
        }
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(PORemoteSessionClose po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        po.getSession().close();
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POConnectionClose po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        this.notifyWaitingPOs(new POObject[]{this.protPO, this.authPO, this.openPO, this.closePO});
        this.closed = true;
        this.pipelineQueue.close();
        po.setSuccess(true);
        if (po.getSemaphore() != null) {
            po.getSemaphore().notifySingleWaiter();
        }
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    public void close() {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", close ...");
        }
        try {
            this.closeLock.lock();
            if (this.closeInProgress) {
                if (this.pTracer.isEnabled()) {
                    this.pTracer.trace(this.toString(), ", close in progress, return");
                }
                return;
            }
            this.closeInProgress = true;
            if (this.heartBeatSender != null) {
                TimerRegistry.Singleton().removeTimerListener(this.heartBeatDelay, this.heartBeatSender);
                this.heartBeatSender = null;
            }
            if (this.idleTimeoutChecker != null) {
                TimerRegistry.Singleton().removeTimerListener(this.idleTimeoutDelay, this.idleTimeoutChecker);
                this.idleTimeoutChecker = null;
            }
        }
        finally {
            this.closeLock.unlock();
        }
        Semaphore sem = new Semaphore();
        this.dispatch(new POConnectionClose(sem));
        sem.waitHere();
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", close done");
        }
    }

    public String toString() {
        return "ConnectionDispatcher";
    }

    private class Disconnecter
    extends Thread {
        String condition;
        String description;

        private Disconnecter(String condition, String description) {
            this.condition = condition;
            this.description = description;
        }

        @Override
        public void run() {
            ConnectionDispatcher.this.myConnection.close(this.condition, this.description);
        }
    }

    private class CBHandler
    implements CallbackHandler {
        String username = null;
        String password = null;

        private CBHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(this.username);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                if (callbacks[i] instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callbacks[i];
                    rc.setText(ConnectionDispatcher.this.remoteHostname);
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }

    private class ConnectionVisitor
    implements FrameVisitor,
    SaslFrameVisitor {
        private ConnectionVisitor() {
        }

        @Override
        public void visit(OpenFrame frame) {
            Milliseconds idleTimeout;
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            ConnectionDispatcher.this.remoteOpen = frame;
            ConnectionDispatcher.this.checkBothSidesOpen();
            if (frame.getMaxFrameSize() != null) {
                int n = ConnectionDispatcher.this.maxRemoteFrameSize = frame.getMaxFrameSize().getValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)frame.getMaxFrameSize().getValue();
            }
            if ((idleTimeout = frame.getIdleTimeOut()) != null) {
                ConnectionDispatcher.this.heartBeatDelay = idleTimeout.getValue() / 2L;
                if (ConnectionDispatcher.this.heartBeatDelay > 0L) {
                    ConnectionDispatcher.this.heartBeatSender = new TimerListener(){

                        @Override
                        public void performTimeAction(TimerEvent evt) {
                            ConnectionDispatcher.this.dispatch(new POSendHeartBeat(null));
                        }
                    };
                    TimerRegistry.Singleton().addTimerListener(ConnectionDispatcher.this.heartBeatDelay, ConnectionDispatcher.this.heartBeatSender);
                }
            }
        }

        @Override
        public void visit(BeginFrame frame) {
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            try {
                int remoteChannel = frame.getChannel();
                if (frame.getRemoteChannel() != null) {
                    Session session = ConnectionDispatcher.this.myConnection.getSessionForLocalChannel(frame.getRemoteChannel().getValue());
                    if (session != null) {
                        ConnectionDispatcher.this.myConnection.mapSessionToRemoteChannel(session, remoteChannel);
                        session.setRemoteChannel(remoteChannel);
                        session.dispatch(new POSessionFrameReceived(frame));
                    } else if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                        ConnectionDispatcher.this.pTracer.trace(this.toString(), ", invalid channel (no associated session): " + remoteChannel);
                    }
                } else if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                    ConnectionDispatcher.this.pTracer.trace(this.toString(), ", local channel field not set");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void visit(AttachFrame frame) {
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        @Override
        public void visit(FlowFrame frame) {
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        @Override
        public void visit(TransferFrame frame) {
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        @Override
        public void visit(DispositionFrame frame) {
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        @Override
        public void visit(DetachFrame frame) {
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        @Override
        public void visit(EndFrame frame) {
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            if (frame.getError() == null) {
                ConnectionDispatcher.this.dispatchSession(frame.getChannel(), new POSessionFrameReceived(frame));
            } else {
                Session session = ConnectionDispatcher.this.myConnection.getSessionForRemoteChannel(frame.getChannel());
                if (session != null) {
                    session.remoteEnd(frame.getError());
                }
            }
        }

        @Override
        public void visit(CloseFrame frame) {
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            ConnectionDispatcher.this.remoteClose = frame;
            ConnectionDispatcher.this.checkBothSidesClosed();
        }

        @Override
        public void visit(SaslMechanismsFrame frame) {
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            ConnectionDispatcher.this.saslMechanisms = frame;
            ConnectionDispatcher.this.checkStartSaslInit();
        }

        @Override
        public void visit(SaslInitFrame frame) {
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        @Override
        public void visit(SaslChallengeFrame frame) {
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            try {
                byte[] response = ConnectionDispatcher.this.saslClient.evaluateChallenge(frame.getChallenge().getValue());
                SaslResponseFrame responseFrame = new SaslResponseFrame(0);
                responseFrame.setResponse(new AMQPBinary(response));
                ConnectionDispatcher.this.outboundHandler.send(responseFrame);
            }
            catch (SaslException e) {
                e.printStackTrace();
                ConnectionDispatcher.this.authPO.setSuccess(false);
                ConnectionDispatcher.this.authPO.setException(e.toString());
                ConnectionDispatcher.this.authPO.getSemaphore().notifySingleWaiter();
            }
        }

        @Override
        public void visit(SaslResponseFrame frame) {
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        @Override
        public void visit(SaslOutcomeFrame frame) {
            SaslCode code;
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            if ((code = frame.getMycode()).getValue() == SaslCode.OK.getValue()) {
                ConnectionDispatcher.this.authPO.setSuccess(true);
            } else {
                ConnectionDispatcher.this.authPO.setSuccess(false);
                ConnectionDispatcher.this.authPO.setException("AuthenticationException: SASLOutcome code=" + code.getValue());
            }
            ConnectionDispatcher.this.authPO.getSemaphore().notifySingleWaiter();
        }

        @Override
        public void visit(HeartbeatFrame frame) {
            if (ConnectionDispatcher.this.pTracer.isEnabled()) {
                ConnectionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        public String toString() {
            return "ConnectionVisitor";
        }
    }

    private class DispatchVisitor
    implements FrameVisitor,
    SaslFrameVisitor {
        private DispatchVisitor() {
        }

        @Override
        public void visit(OpenFrame frame) {
            ConnectionDispatcher.this.dispatch(new POConnectionFrameReceived(frame));
        }

        @Override
        public void visit(BeginFrame frame) {
            ConnectionDispatcher.this.dispatch(new POConnectionFrameReceived(frame));
        }

        @Override
        public void visit(AttachFrame frame) {
            ConnectionDispatcher.this.dispatchSession(frame.getChannel(), new POSessionFrameReceived(frame));
        }

        @Override
        public void visit(FlowFrame frame) {
            ConnectionDispatcher.this.dispatchSession(frame.getChannel(), new POSessionFrameReceived(frame));
        }

        @Override
        public void visit(TransferFrame frame) {
            ConnectionDispatcher.this.dispatchSession(frame.getChannel(), new POSessionFrameReceived(frame));
        }

        @Override
        public void visit(DispositionFrame frame) {
            ConnectionDispatcher.this.dispatchSession(frame.getChannel(), new POSessionFrameReceived(frame));
        }

        @Override
        public void visit(DetachFrame frame) {
            ConnectionDispatcher.this.dispatchSession(frame.getChannel(), new POSessionFrameReceived(frame));
        }

        @Override
        public void visit(EndFrame frame) {
            ConnectionDispatcher.this.dispatch(new POConnectionFrameReceived(frame));
        }

        @Override
        public void visit(CloseFrame frame) {
            ConnectionDispatcher.this.dispatch(new POConnectionFrameReceived(frame));
        }

        @Override
        public void visit(SaslMechanismsFrame frame) {
            ConnectionDispatcher.this.dispatch(new POConnectionFrameReceived(frame, true));
        }

        @Override
        public void visit(SaslInitFrame frame) {
            ConnectionDispatcher.this.dispatch(new POConnectionFrameReceived(frame, true));
        }

        @Override
        public void visit(SaslChallengeFrame frame) {
            ConnectionDispatcher.this.dispatch(new POConnectionFrameReceived(frame, true));
        }

        @Override
        public void visit(SaslResponseFrame frame) {
            ConnectionDispatcher.this.dispatch(new POConnectionFrameReceived(frame, true));
        }

        @Override
        public void visit(SaslOutcomeFrame frame) {
            ConnectionDispatcher.this.dispatch(new POConnectionFrameReceived(frame, true));
            ConnectionDispatcher.this.awaitProtocolHeader = true;
            ConnectionDispatcher.this.protocolHandler.setProtHeaderExpected(true);
            ConnectionDispatcher.this.saslActive = false;
        }

        @Override
        public void visit(HeartbeatFrame frame) {
            ConnectionDispatcher.this.dispatch(new POConnectionFrameReceived(frame));
        }
    }
}

