/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.client;

import com.swiftmq.amqp.v100.client.AMQPException;
import com.swiftmq.amqp.v100.client.DeliveryMemory;
import com.swiftmq.amqp.v100.client.LinkClosedException;
import com.swiftmq.amqp.v100.client.Session;
import com.swiftmq.amqp.v100.client.po.POCloseLink;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressIF;
import com.swiftmq.amqp.v100.generated.transport.definitions.DeliveryTag;
import com.swiftmq.amqp.v100.generated.transport.definitions.Error;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.pipeline.POObject;
import java.util.Set;

public class Link {
    Session mySession;
    String name;
    int qoS = 0;
    volatile Set<AMQPSymbol> offeredCapabilities = null;
    volatile Set<AMQPSymbol> desiredCapabilities = null;
    volatile Set<AMQPSymbol> destinationCapabilities = null;
    volatile long maxMessageSize = 0L;
    volatile int handle;
    volatile long remoteHandle;
    volatile AddressIF remoteAddress;
    volatile POObject waitingPO = null;
    volatile POObject waitingClosePO = null;
    volatile boolean closed = false;
    DeliveryMemory deliveryMemory = null;
    volatile Error error = null;

    protected Link(Session mySession, String name, int qoS, DeliveryMemory deliveryMemory) {
        this.mySession = mySession;
        this.name = name;
        this.qoS = qoS;
        this.deliveryMemory = deliveryMemory;
    }

    protected void verifyState() throws LinkClosedException {
        if (this.closed) {
            throw new LinkClosedException("Link is closed" + (this.error != null ? ": " + this.error.getCondition().getValueString() + "/" + this.error.getDescription().getValue() : ""));
        }
    }

    public Session getMySession() {
        return this.mySession;
    }

    public String getName() {
        return this.name;
    }

    public int getQoS() {
        return this.qoS;
    }

    public int getHandle() {
        return this.handle;
    }

    protected void setHandle(int handle) {
        this.handle = handle;
    }

    public AddressIF getRemoteAddress() {
        return this.remoteAddress;
    }

    protected void setRemoteAddress(AddressIF remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public DeliveryMemory getDeliveryMemory() {
        return this.deliveryMemory;
    }

    protected void setDeliveryCount(long deliveryCount) {
    }

    protected long getRemoteHandle() {
        return this.remoteHandle;
    }

    protected void setRemoteHandle(long remoteHandle) {
        this.remoteHandle = remoteHandle;
    }

    public Set<AMQPSymbol> getOfferedCapabilities() {
        return this.offeredCapabilities;
    }

    public void setOfferedCapabilities(Set<AMQPSymbol> offeredCapabilities) {
        this.offeredCapabilities = offeredCapabilities;
    }

    public Set<AMQPSymbol> getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public void setDesiredCapabilities(Set<AMQPSymbol> desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
    }

    public Set<AMQPSymbol> getDestinationCapabilities() {
        return this.destinationCapabilities;
    }

    protected void setDestinationCapabilities(Set<AMQPSymbol> destinationCapabilities) {
        this.destinationCapabilities = destinationCapabilities;
    }

    public long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(long maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    protected POObject getWaitingPO() {
        return this.waitingPO;
    }

    protected void setWaitingPO(POObject waitingPO) {
        this.waitingPO = waitingPO;
    }

    protected POObject getWaitingClosePO() {
        return this.waitingClosePO;
    }

    protected void setWaitingClosePO(POObject waitingClosePO) {
        this.waitingClosePO = waitingClosePO;
    }

    protected DeliveryTag createDeliveryTag() {
        return null;
    }

    protected void cancel() {
        this.closed = true;
        if (this.waitingPO != null && this.waitingPO.getSemaphore() != null) {
            this.waitingPO.setSuccess(false);
            this.waitingPO.setException("Link has been cancelled");
            this.waitingPO.getSemaphore().notifySingleWaiter();
            this.waitingPO = null;
        }
        if (this.waitingClosePO != null && this.waitingClosePO.getSemaphore() != null) {
            this.waitingClosePO.setSuccess(false);
            this.waitingClosePO.setException("Link has been cancelled");
            this.waitingClosePO.getSemaphore().notifySingleWaiter();
            this.waitingClosePO = null;
        }
    }

    protected void remoteDetach(Error error) {
        this.error = error;
        this.mySession.detach(this);
        this.cancel();
        POCloseLink po = new POCloseLink(null, this);
        this.mySession.getSessionDispatcher().dispatch(po);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws AMQPException {
        if (this.closed) {
            return;
        }
        Semaphore sem = new Semaphore();
        POCloseLink po = new POCloseLink(sem, this);
        this.mySession.getSessionDispatcher().dispatch(po);
        sem.waitHere();
        this.mySession.detach(this);
        this.closed = true;
        if (!po.isSuccess()) {
            throw new AMQPException(po.getException());
        }
    }
}

