/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.client;

import com.swiftmq.amqp.v100.client.AMQPException;
import com.swiftmq.amqp.v100.client.DeliveryMemory;
import com.swiftmq.amqp.v100.client.Link;
import com.swiftmq.amqp.v100.client.Session;
import com.swiftmq.amqp.v100.client.UnsettledDelivery;
import com.swiftmq.amqp.v100.client.po.POSendMessage;
import com.swiftmq.amqp.v100.client.po.POSendResumedTransfer;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.Accepted;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateFactory;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateIF;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateVisitorAdapter;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressString;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Header;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdString;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Properties;
import com.swiftmq.amqp.v100.generated.transport.definitions.DeliveryTag;
import com.swiftmq.amqp.v100.generated.transport.definitions.Milliseconds;
import com.swiftmq.amqp.v100.messaging.AMQPMessage;
import com.swiftmq.amqp.v100.types.AMQPBinary;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPMap;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedByte;
import com.swiftmq.amqp.v100.types.Util;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.util.IdGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class Producer
extends Link {
    String target;
    boolean defaultPersistent = true;
    int defaultPriority = 5;
    long defaultTtl = -1L;
    volatile long linkCredit = 0L;
    volatile long deliveryCountSnd = 0L;
    volatile long deliveryCountRcv = 0L;
    volatile boolean drain = false;
    String uniqueId = IdGenerator.getInstance().nextId('/');
    long msgId = 0L;
    boolean transactionController = false;
    POSendMessage waitingForFlowReleasePO = null;

    protected Producer(Session mySession, String target, String name, int qoS, DeliveryMemory deliveryMemory) {
        super(mySession, name, qoS, deliveryMemory);
        this.target = target;
    }

    protected boolean isTransactionController() {
        return this.transactionController;
    }

    protected void setTransactionController(boolean transactionController) {
        this.transactionController = transactionController;
    }

    public String getTarget() {
        return this.target;
    }

    protected long getLinkCredit() {
        return this.deliveryCountRcv + this.linkCredit - this.deliveryCountSnd;
    }

    protected void setLinkCredit(long linkCredit) {
        this.linkCredit = linkCredit;
    }

    protected long getLastReceivedLinkCredit() {
        return this.linkCredit;
    }

    protected long getAvailable() {
        return this.getWaitingPO() != null ? 1L : 0L;
    }

    protected long getDeliveryCountSnd() {
        return this.deliveryCountSnd;
    }

    protected void setDeliveryCountRcv(long deliveryCountRcv) {
        this.deliveryCountRcv = deliveryCountRcv;
    }

    protected void incDeliveryCountSnd() {
        ++this.deliveryCountSnd;
    }

    protected boolean isDrain() {
        return this.drain;
    }

    protected void setDrain(boolean drain) {
        this.drain = drain;
        if (drain) {
            this.deliveryCountSnd += this.linkCredit;
            this.linkCredit = 0L;
        }
    }

    public POSendMessage getWaitingForFlowReleasePO() {
        return this.waitingForFlowReleasePO;
    }

    public void setWaitingForFlowReleasePO(POSendMessage waitingForFlowReleasePO) {
        this.waitingForFlowReleasePO = waitingForFlowReleasePO;
    }

    @Override
    protected DeliveryTag createDeliveryTag() {
        byte[] dtag = new byte[8];
        Util.writeLong(this.deliveryCountSnd, dtag, 0);
        return new DeliveryTag(dtag);
    }

    protected void recover(AMQPMap remoteUnsettled) {
        try {
            if (remoteUnsettled != null) {
                Map<AMQPType, AMQPType> map = remoteUnsettled.getValue();
                for (Map.Entry<AMQPType, AMQPType> entry : map.entrySet()) {
                    final DeliveryTag deliveryTag = new DeliveryTag(((AMQPBinary)entry.getKey()).getValue());
                    AMQPList deliveryState = (AMQPList)entry.getValue();
                    if (deliveryState == null) continue;
                    try {
                        DeliveryStateFactory.create(deliveryState).accept(new DeliveryStateVisitorAdapter(){

                            @Override
                            public void visit(Accepted impl) {
                                Producer.this.deliveryMemory.deliverySettled(deliveryTag);
                                Producer.this.mySession.dispatch(new POSendResumedTransfer(Producer.this, deliveryTag));
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.deliveryMemory.getNumberUnsettled() > 0) {
                Collection<UnsettledDelivery> unsettled = this.deliveryMemory.getUnsettled();
                for (UnsettledDelivery unsettledDelivery : unsettled) {
                    AMQPMessage msg;
                    if (unsettledDelivery.getMessage() == null || (msg = unsettledDelivery.getMessage()).getTxnIdIF() != null) continue;
                    POSendMessage po = new POSendMessage(null, this, msg, null, unsettledDelivery.getDeliveryTag());
                    po.setRecovery(true);
                    this.mySession.dispatch(po);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private synchronized String nextMsgId() {
        StringBuffer b = new StringBuffer(this.uniqueId);
        b.append('/');
        b.append(this.msgId++);
        return b.toString();
    }

    public DeliveryStateIF send(AMQPMessage msg, boolean persistent, int priority, long ttl) throws AMQPException {
        Properties props;
        this.verifyState();
        Header header = msg.getHeader();
        if (header == null) {
            header = new Header();
            msg.setHeader(header);
        }
        header.setDurable(new AMQPBoolean(persistent));
        header.setPriority(new AMQPUnsignedByte(priority));
        if (ttl >= 0L) {
            header.setTtl(new Milliseconds(ttl));
        }
        if ((props = msg.getProperties()) == null) {
            props = new Properties();
            msg.setProperties(props);
        }
        if (props.getMessageId() == null) {
            props.setMessageId(new MessageIdString(this.nextMsgId()));
        }
        props.setTo(new AddressString(this.target));
        String userName = this.mySession.myConnection.getUserName();
        if (userName != null) {
            props.setUserId(new AMQPBinary(userName.getBytes()));
        }
        Semaphore sem = new Semaphore();
        try {
            POSendMessage po = new POSendMessage(sem, this, msg, msg.getTxnIdIF(), msg.getDeliveryTag());
            this.mySession.dispatch(po);
            sem.waitHere();
            if (!po.isSuccess()) {
                throw new AMQPException(po.getException());
            }
            return po.getDeliveryState();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AMQPException(e.toString());
        }
    }

    public DeliveryStateIF send(AMQPMessage msg) throws AMQPException {
        return this.send(msg, this.defaultPersistent, this.defaultPriority, this.defaultTtl);
    }

    @Override
    protected void cancel() {
        if (this.waitingForFlowReleasePO != null && this.waitingForFlowReleasePO.getSemaphore() != null) {
            this.waitingForFlowReleasePO.setSuccess(false);
            this.waitingForFlowReleasePO.setException("Link has been cancelled");
            this.waitingForFlowReleasePO.getSemaphore().notifySingleWaiter();
            this.waitingForFlowReleasePO = null;
        }
        super.cancel();
    }
}

