/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.client;

import com.swiftmq.amqp.AMQPContext;
import com.swiftmq.amqp.v100.client.AMQPException;
import com.swiftmq.amqp.v100.client.Connection;
import com.swiftmq.amqp.v100.client.Consumer;
import com.swiftmq.amqp.v100.client.DefaultDeliveryMemory;
import com.swiftmq.amqp.v100.client.DeliveryMemory;
import com.swiftmq.amqp.v100.client.DurableConsumer;
import com.swiftmq.amqp.v100.client.Link;
import com.swiftmq.amqp.v100.client.Producer;
import com.swiftmq.amqp.v100.client.QoS;
import com.swiftmq.amqp.v100.client.SessionClosedException;
import com.swiftmq.amqp.v100.client.SessionDispatcher;
import com.swiftmq.amqp.v100.client.SessionHandshakeException;
import com.swiftmq.amqp.v100.client.TransactionController;
import com.swiftmq.amqp.v100.client.po.POAttachConsumer;
import com.swiftmq.amqp.v100.client.po.POAttachDurableConsumer;
import com.swiftmq.amqp.v100.client.po.POAttachProducer;
import com.swiftmq.amqp.v100.client.po.POBegin;
import com.swiftmq.amqp.v100.client.po.PORemoteSessionClose;
import com.swiftmq.amqp.v100.client.po.POSendEnd;
import com.swiftmq.amqp.v100.generated.messaging.addressing.TerminusExpiryPolicy;
import com.swiftmq.amqp.v100.generated.transport.definitions.Error;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.pipeline.POObject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Session {
    AMQPContext ctx = null;
    Connection myConnection = null;
    int channel = 0;
    int remoteChannel = 0;
    long incomingWindowSize = 1L;
    long outgoingWindowSize = 1L;
    SessionDispatcher sessionDispatcher = null;
    TransactionController transactionController = null;
    Set links = new HashSet();
    Lock lock = new ReentrantLock();
    volatile boolean closed = false;
    Error error = null;

    protected Session(AMQPContext ctx, Connection myConnection, long incomingWindowSize, long outgoingWindowSize) {
        this.ctx = ctx;
        this.myConnection = myConnection;
        this.incomingWindowSize = incomingWindowSize;
        this.outgoingWindowSize = outgoingWindowSize;
        this.sessionDispatcher = new SessionDispatcher(ctx, this, myConnection.getOutboundHandler());
    }

    protected void finishHandshake() throws SessionHandshakeException {
        Semaphore sem = new Semaphore();
        POBegin po = new POBegin(sem);
        this.sessionDispatcher.dispatch(po);
        sem.waitHere();
        sem.reset();
        if (!po.isSuccess()) {
            this.cancel();
            throw new SessionHandshakeException(po.getException());
        }
    }

    private void verifyState() throws SessionClosedException {
        if (this.closed) {
            throw new SessionClosedException("Session is closed" + (this.error != null ? ": " + this.error.getCondition().getValueString() + "/" + this.error.getDescription().getValue() : ""));
        }
    }

    public int getChannel() {
        return this.channel;
    }

    protected void setChannel(int channel) {
        this.channel = channel;
        this.sessionDispatcher.setMyChannel(channel);
    }

    protected SessionDispatcher getSessionDispatcher() {
        return this.sessionDispatcher;
    }

    protected void remoteClose() {
        this.myConnection.connectionDispatcher.dispatch(new PORemoteSessionClose(this));
    }

    protected int getRemoteChannel() {
        return this.remoteChannel;
    }

    protected void setRemoteChannel(int remoteChannel) {
        this.remoteChannel = remoteChannel;
    }

    public long getIncomingWindowSize() {
        return this.incomingWindowSize;
    }

    public long getOutgoingWindowSize() {
        return this.outgoingWindowSize;
    }

    public Producer createProducer(String target, int qoS) throws AMQPException {
        return this.createProducer(target, qoS, null);
    }

    public Producer createProducer(String target, int qoS, DeliveryMemory deliveryMemory) throws AMQPException {
        this.verifyState();
        QoS.verify(qoS);
        Semaphore sem = new Semaphore();
        POAttachProducer po = new POAttachProducer(sem, target, qoS, deliveryMemory == null ? new DefaultDeliveryMemory() : deliveryMemory);
        this.sessionDispatcher.dispatch(po);
        sem.waitHere();
        if (!po.isSuccess()) {
            throw new AMQPException(po.getException());
        }
        Producer p = (Producer)po.getLink();
        this.links.add(p);
        return p;
    }

    public Consumer createConsumer(String source, int linkCredit, int qoS, boolean noLocal, String selector) throws AMQPException {
        return this.createConsumer(source, linkCredit, qoS, noLocal, selector, null);
    }

    public Consumer createConsumer(String source, int linkCredit, int qoS, boolean noLocal, String selector, DeliveryMemory deliveryMemory) throws AMQPException {
        this.verifyState();
        QoS.verify(qoS);
        Semaphore sem = new Semaphore();
        POAttachConsumer po = new POAttachConsumer(sem, source, linkCredit, qoS, noLocal, selector, deliveryMemory == null ? new DefaultDeliveryMemory() : deliveryMemory);
        this.sessionDispatcher.dispatch(po);
        sem.waitHere();
        if (!po.isSuccess()) {
            throw new AMQPException(po.getException());
        }
        Consumer c = (Consumer)po.getLink();
        this.links.add(c);
        return c;
    }

    public Consumer createConsumer(String source, int qoS, boolean noLocal, String selector) throws AMQPException {
        this.verifyState();
        QoS.verify(qoS);
        Semaphore sem = new Semaphore();
        POAttachConsumer po = new POAttachConsumer(sem, source, -1, qoS, noLocal, selector, new DefaultDeliveryMemory());
        this.sessionDispatcher.dispatch(po);
        sem.waitHere();
        if (!po.isSuccess()) {
            throw new AMQPException(po.getException());
        }
        Consumer c = (Consumer)po.getLink();
        this.links.add(c);
        return c;
    }

    public Consumer createConsumer(int linkCredit, int qoS) throws AMQPException {
        this.verifyState();
        QoS.verify(qoS);
        Semaphore sem = new Semaphore();
        POAttachConsumer po = new POAttachConsumer(sem, null, linkCredit, qoS, false, null, new DefaultDeliveryMemory());
        this.sessionDispatcher.dispatch(po);
        sem.waitHere();
        if (!po.isSuccess()) {
            throw new AMQPException(po.getException());
        }
        Consumer c = (Consumer)po.getLink();
        this.links.add(c);
        return c;
    }

    public DurableConsumer createDurableConsumer(String linkName, String source, int linkCredit, int qoS, boolean noLocal, String selector) throws AMQPException {
        return this.createDurableConsumer(linkName, source, linkCredit, qoS, noLocal, selector, null);
    }

    public DurableConsumer createDurableConsumer(String linkName, String source, int linkCredit, int qoS, boolean noLocal, String selector, DeliveryMemory deliveryMemory) throws AMQPException {
        this.verifyState();
        if (linkName == null) {
            throw new AMQPException("Please specify the link name");
        }
        if (!this.myConnection.containerIdSet) {
            throw new AMQPException("Please specify a container id");
        }
        QoS.verify(qoS);
        Semaphore sem = new Semaphore();
        POAttachDurableConsumer po = new POAttachDurableConsumer(sem, linkName, source, linkCredit, qoS, noLocal, selector, TerminusExpiryPolicy.NEVER, deliveryMemory == null ? new DefaultDeliveryMemory() : deliveryMemory);
        this.sessionDispatcher.dispatch(po);
        sem.waitHere();
        if (!po.isSuccess()) {
            throw new AMQPException(po.getException());
        }
        DurableConsumer d = (DurableConsumer)po.getLink();
        this.links.add(d);
        return d;
    }

    protected void detach(Link link) {
        try {
            this.lock.lock();
            this.links.remove(link);
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized TransactionController getTransactionController() throws SessionClosedException {
        this.verifyState();
        if (this.transactionController == null) {
            this.transactionController = new TransactionController(this);
        }
        return this.transactionController;
    }

    protected void dispatch(POObject po) {
        this.sessionDispatcher.dispatch(po);
    }

    protected void remoteEnd(Error error) {
        this.error = error;
        this.cancel();
    }

    private Link[] getLinksCopy() {
        try {
            this.lock.lock();
            Link[] l = null;
            l = this.links.toArray(new Link[this.links.size()]);
            this.links.clear();
            Link[] linkArray = l;
            return linkArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void cancel() {
        if (this.closed) {
            return;
        }
        if (this.links.size() > 0) {
            Link[] l = this.getLinksCopy();
            for (int i = 0; i < l.length; ++i) {
                l[i].cancel();
            }
        }
        this.myConnection.removeSession(this);
        this.myConnection.unmapSessionFromRemoteChannel(this.remoteChannel);
        this.sessionDispatcher.close();
        this.closed = true;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.lock.lock();
            if (this.transactionController != null) {
                this.transactionController.close();
                this.transactionController = null;
            }
            Semaphore sem = new Semaphore();
            POSendEnd po = new POSendEnd(sem, null);
            this.sessionDispatcher.dispatch(po);
            sem.waitHere();
            this.cancel();
        }
        finally {
            this.lock.unlock();
        }
    }
}

