/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.client;

import com.swiftmq.amqp.AMQPContext;
import com.swiftmq.amqp.OutboundHandler;
import com.swiftmq.amqp.integration.Tracer;
import com.swiftmq.amqp.v100.client.Consumer;
import com.swiftmq.amqp.v100.client.DeliveryMemory;
import com.swiftmq.amqp.v100.client.DurableConsumer;
import com.swiftmq.amqp.v100.client.Link;
import com.swiftmq.amqp.v100.client.Producer;
import com.swiftmq.amqp.v100.client.Session;
import com.swiftmq.amqp.v100.client.SessionVisitor;
import com.swiftmq.amqp.v100.client.UnsettledDelivery;
import com.swiftmq.amqp.v100.client.po.POAttach;
import com.swiftmq.amqp.v100.client.po.POAttachConsumer;
import com.swiftmq.amqp.v100.client.po.POAttachDurableConsumer;
import com.swiftmq.amqp.v100.client.po.POAttachProducer;
import com.swiftmq.amqp.v100.client.po.POBegin;
import com.swiftmq.amqp.v100.client.po.POCloseLink;
import com.swiftmq.amqp.v100.client.po.POFillCache;
import com.swiftmq.amqp.v100.client.po.POSendDisposition;
import com.swiftmq.amqp.v100.client.po.POSendEnd;
import com.swiftmq.amqp.v100.client.po.POSendMessage;
import com.swiftmq.amqp.v100.client.po.POSendResumedTransfer;
import com.swiftmq.amqp.v100.client.po.POSessionClose;
import com.swiftmq.amqp.v100.client.po.POSessionFrameReceived;
import com.swiftmq.amqp.v100.generated.filter.filter_types.NoLocalFilter;
import com.swiftmq.amqp.v100.generated.filter.filter_types.SelectorFilter;
import com.swiftmq.amqp.v100.generated.messaging.addressing.FilterSet;
import com.swiftmq.amqp.v100.generated.messaging.addressing.Source;
import com.swiftmq.amqp.v100.generated.messaging.addressing.Target;
import com.swiftmq.amqp.v100.generated.messaging.addressing.TargetIF;
import com.swiftmq.amqp.v100.generated.messaging.addressing.TerminusDurability;
import com.swiftmq.amqp.v100.generated.messaging.addressing.TerminusExpiryPolicy;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.Accepted;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateIF;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.Rejected;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressString;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslChallengeFrame;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslInitFrame;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslMechanismsFrame;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslOutcomeFrame;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslResponseFrame;
import com.swiftmq.amqp.v100.generated.transactions.coordination.Coordinator;
import com.swiftmq.amqp.v100.generated.transactions.coordination.TransactionalState;
import com.swiftmq.amqp.v100.generated.transactions.coordination.TxnCapability;
import com.swiftmq.amqp.v100.generated.transactions.coordination.TxnIdIF;
import com.swiftmq.amqp.v100.generated.transport.definitions.DeliveryNumber;
import com.swiftmq.amqp.v100.generated.transport.definitions.DeliveryTag;
import com.swiftmq.amqp.v100.generated.transport.definitions.Error;
import com.swiftmq.amqp.v100.generated.transport.definitions.ErrorConditionFactory;
import com.swiftmq.amqp.v100.generated.transport.definitions.Fields;
import com.swiftmq.amqp.v100.generated.transport.definitions.Handle;
import com.swiftmq.amqp.v100.generated.transport.definitions.MessageFormat;
import com.swiftmq.amqp.v100.generated.transport.definitions.ReceiverSettleMode;
import com.swiftmq.amqp.v100.generated.transport.definitions.Role;
import com.swiftmq.amqp.v100.generated.transport.definitions.Seconds;
import com.swiftmq.amqp.v100.generated.transport.definitions.SenderSettleMode;
import com.swiftmq.amqp.v100.generated.transport.definitions.SequenceNo;
import com.swiftmq.amqp.v100.generated.transport.definitions.SessionError;
import com.swiftmq.amqp.v100.generated.transport.definitions.TransferNumber;
import com.swiftmq.amqp.v100.generated.transport.performatives.AttachFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.BeginFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.CloseFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.DetachFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.DispositionFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.EndFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.FlowFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameVisitor;
import com.swiftmq.amqp.v100.generated.transport.performatives.OpenFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.TransferFrame;
import com.swiftmq.amqp.v100.messaging.AMQPMessage;
import com.swiftmq.amqp.v100.transport.HeartbeatFrame;
import com.swiftmq.amqp.v100.transport.Packager;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPMap;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.tools.collection.ArrayListTool;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.pipeline.POObject;
import com.swiftmq.tools.pipeline.PipelineQueue;
import com.swiftmq.tools.util.IdGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SessionDispatcher
implements SessionVisitor {
    AMQPContext ctx = null;
    Tracer fTracer = null;
    Tracer pTracer = null;
    Session mySession = null;
    boolean transacted = false;
    int myChannel = 0;
    FrameVisitor visitor = new SessionDispatcherFrameVisitor();
    OutboundHandler outboundHandler = null;
    PipelineQueue pipelineQueue = null;
    POBegin beginPO = null;
    BeginFrame remoteBegin = null;
    POSendEnd endPO = null;
    EndFrame remoteEnd = null;
    volatile boolean closed = false;
    volatile boolean closeInProgress = false;
    Lock closeLock = new ReentrantLock();
    ArrayList handles = new ArrayList();
    Map remoteHandles = new HashMap();
    Map waitingPO = new HashMap();
    Map<Long, DeliveryMapping> unsettledOutgoingDeliveries = new HashMap<Long, DeliveryMapping>();
    Map<Long, DeliveryMapping> unsettledIncomingDeliveries = new HashMap<Long, DeliveryMapping>();
    List outboundDeliveries = new ArrayList();
    long nextLinkId = 0L;
    String uniqueSessionId = IdGenerator.getInstance().nextId('/');
    boolean windowChanged = false;
    long initialOutgoingId = 1L;
    long nextIncomingId = 0L;
    long incomingWindow = 0L;
    long nextOutgoingId = this.initialOutgoingId;
    long outgoingWindow = 0L;
    long remoteIncomingWindow = 0L;
    long remoteOutgoingWindow = 0L;
    long deliveryId = this.initialOutgoingId;

    public SessionDispatcher(AMQPContext ctx, Session mySession, OutboundHandler outboundHandler) {
        this.ctx = ctx;
        this.mySession = mySession;
        this.outboundHandler = outboundHandler;
        this.fTracer = ctx.getFrameTracer();
        this.pTracer = ctx.getProcessingTracer();
        this.pipelineQueue = new PipelineQueue(ctx.getSessionPool(), "SessionDispatcher", this);
        this.incomingWindow = mySession.getIncomingWindowSize();
        this.outgoingWindow = mySession.getOutgoingWindowSize();
    }

    private long nextDeliveryId() {
        this.deliveryId = this.deliveryId == Long.MAX_VALUE ? this.initialOutgoingId : ++this.deliveryId;
        return this.deliveryId;
    }

    private void checkBothSidesBegin() {
        if (this.beginPO != null && this.remoteBegin != null) {
            this.beginPO.setSuccess(true);
            this.beginPO.getSemaphore().notifySingleWaiter();
            this.beginPO = null;
        }
    }

    private void checkBothSidesEnd() {
        if (this.endPO != null && this.remoteEnd != null) {
            this.endPO.setSuccess(true);
            this.endPO.getSemaphore().notifySingleWaiter();
            this.endPO = null;
        } else if (this.endPO == null && this.remoteEnd != null) {
            this.mySession.remoteClose();
        }
    }

    private void sendFlow() {
        FlowFrame flowFrame = new FlowFrame(this.mySession.getChannel());
        flowFrame.setIncomingWindow(new AMQPUnsignedInt(this.incomingWindow));
        flowFrame.setNextIncomingId(new TransferNumber(this.nextIncomingId));
        flowFrame.setOutgoingWindow(new AMQPUnsignedInt(this.outgoingWindow));
        flowFrame.setNextOutgoingId(new TransferNumber(this.nextOutgoingId));
        flowFrame.setDrain(AMQPBoolean.FALSE);
        flowFrame.setEcho(AMQPBoolean.FALSE);
        this.outboundHandler.send(flowFrame);
    }

    private void doSend(POSendMessage po) {
        block19: {
            if (this.pTracer.isEnabled()) {
                this.pTracer.trace(this.toString(), ", doSend, po=" + po + ", dataLength=" + po.getPackager().getSize());
            }
            try {
                Producer producer = po.getProducer();
                producer.verifyState();
                Packager packager = po.getPackager();
                if (this.remoteIncomingWindow > 0L && this.outgoingWindow > 0L) {
                    do {
                        boolean wasFirstPacket = false;
                        boolean isAtMostOnce = producer.getQoS() == 0;
                        packager.setMaxFrameSize(this.mySession.myConnection.connectionDispatcher.getMaxFrameSize());
                        TransferFrame frame = new TransferFrame(this.mySession.getChannel());
                        frame.setHandle(new Handle(producer.getHandle()));
                        frame.setSettled(new AMQPBoolean(isAtMostOnce));
                        if (packager.getCurrentPacketNumber() == 0) {
                            DeliveryTag deliveryTag;
                            long dId = this.nextDeliveryId();
                            wasFirstPacket = true;
                            producer.incDeliveryCountSnd();
                            DeliveryTag deliveryTag2 = deliveryTag = po.getDeliveryTag() != null ? po.getDeliveryTag() : producer.createDeliveryTag();
                            if (!isAtMostOnce) {
                                if (po.getTxnId() == null && !po.isRecovery()) {
                                    producer.getDeliveryMemory().addUnsettledDelivery(new UnsettledDelivery(deliveryTag, null, po.getMessage()));
                                }
                                this.unsettledOutgoingDeliveries.put(dId, new DeliveryMapping(deliveryTag, producer));
                            }
                            frame.setDeliveryTag(deliveryTag);
                            frame.setDeliveryId(new DeliveryNumber(dId));
                            frame.setMessageFormat(new MessageFormat(0L));
                            TxnIdIF txnId = po.getTxnId();
                            if (txnId != null) {
                                TransactionalState txState = new TransactionalState();
                                txState.setTxnId(txnId);
                                frame.setState(txState);
                            }
                        }
                        packager.setMessageFormat(0L);
                        packager.getNextPacket(frame);
                        if (wasFirstPacket && this.outgoingWindow - (long)packager.getPredictedNumberPackets() < 0L) {
                            this.outgoingWindow += (long)packager.getPredictedNumberPackets();
                            this.sendFlow();
                            this.windowChanged = true;
                        }
                        if (this.pTracer.isEnabled()) {
                            this.pTracer.trace(this.toString(), ", doSend, remoteIncomingWindows=" + this.remoteIncomingWindow + ", outgoingWindow=" + this.outgoingWindow + ", sending message, wasFirstPacket=" + wasFirstPacket + ", maxSize=" + packager.getMaxPayloadLength() + ", packetSize=" + frame.getPayload().length + ", predictedNumberPackets=" + packager.getPredictedNumberPackets() + ", currentPacket=" + packager.getCurrentPacketNumber() + ", hasMore=" + packager.hasMore());
                        }
                        this.outboundHandler.send(frame);
                        ++this.nextOutgoingId;
                        --this.remoteIncomingWindow;
                        if (!isAtMostOnce) {
                            --this.outgoingWindow;
                        }
                        if (packager.hasMore()) continue;
                        if (producer.isTransactionController() || po.getTxnId() != null) {
                            producer.setWaitingPO(po);
                        } else {
                            po.setSuccess(true);
                            if (po.getSemaphore() != null) {
                                po.getSemaphore().notifySingleWaiter();
                            }
                        }
                        if (!this.windowChanged) break;
                        this.outgoingWindow = this.mySession.getOutgoingWindowSize();
                        this.sendFlow();
                        break;
                    } while (this.remoteIncomingWindow > 0L && this.outgoingWindow > 0L);
                    if (packager.hasMore()) {
                        if (this.pTracer.isEnabled()) {
                            this.pTracer.trace(this.toString(), ", doSend, remoteIncomingWindows=" + this.remoteIncomingWindow + ", outgoingWindow=" + this.outgoingWindow + ", has more but no window, storing message");
                        }
                        this.outboundDeliveries.add(po);
                    }
                } else {
                    if (this.pTracer.isEnabled()) {
                        this.pTracer.trace(this.toString(), ", doSend, po=" + po + ", remoteIncomingWindows=" + this.remoteIncomingWindow + ", outgoingWindow=" + this.outgoingWindow + ", no window, storing message");
                    }
                    this.outboundDeliveries.add(po);
                }
            }
            catch (Exception e) {
                po.setSuccess(false);
                po.setException(e.getMessage());
                if (po.getSemaphore() == null) break block19;
                po.getSemaphore().notifySingleWaiter();
            }
        }
    }

    private void settleOutbound(long from, long to, boolean settled, DeliveryStateIF deliveryState) {
        if (from <= to) {
            long current = from;
            while (current <= to) {
                DeliveryMapping deliveryMapping = this.unsettledOutgoingDeliveries.remove(current);
                if (deliveryMapping != null) {
                    deliveryMapping.link.getDeliveryMemory().deliverySettled(deliveryMapping.deliveryTag);
                    if (deliveryMapping.link.getWaitingPO() != null) {
                        POSendMessage po = (POSendMessage)deliveryMapping.link.getWaitingPO();
                        po.setSuccess(true);
                        po.setDeliveryState(deliveryState);
                        po.getSemaphore().notifySingleWaiter();
                        deliveryMapping.link.setWaitingPO(null);
                    }
                    if (deliveryMapping.link.getDeliveryMemory().getNumberUnsettled() == 0 && deliveryMapping.link.getWaitingClosePO() != null) {
                        this.dispatch(deliveryMapping.link.getWaitingClosePO());
                        deliveryMapping.link.setWaitingClosePO(null);
                    }
                }
                ++current;
                ++this.outgoingWindow;
            }
            if (deliveryState != null && !settled && deliveryState instanceof Accepted) {
                DispositionFrame dispoFrame = new DispositionFrame(this.mySession.getChannel());
                dispoFrame.setRole(Role.SENDER);
                dispoFrame.setFirst(new DeliveryNumber(from));
                dispoFrame.setLast(new DeliveryNumber(to));
                dispoFrame.setSettled(AMQPBoolean.TRUE);
                dispoFrame.setState(new Accepted());
                this.outboundHandler.send(dispoFrame);
            }
        }
    }

    private void settleInbound(long from, long to, boolean settled) {
        if (from <= to) {
            for (long current = from; current <= to; ++current) {
                DeliveryMapping deliveryMapping = this.unsettledIncomingDeliveries.remove(current);
                if (deliveryMapping == null) continue;
                deliveryMapping.link.getDeliveryMemory().deliverySettled(deliveryMapping.deliveryTag);
                if (deliveryMapping.link.getDeliveryMemory().getNumberUnsettled() != 0 || deliveryMapping.link.getWaitingClosePO() == null) continue;
                this.dispatch(deliveryMapping.link.getWaitingClosePO());
                deliveryMapping.link.setWaitingClosePO(null);
            }
        }
    }

    private void notifyWaitingPOs(POObject[] po) {
        String msg = "Session was asynchronously closed";
        for (int i = 0; i < this.handles.size(); ++i) {
            Link link = (Link)this.handles.get(i);
            if (link == null) continue;
            if (link.getWaitingPO() != null && link.getWaitingPO().getSemaphore() != null) {
                link.getWaitingPO().setSuccess(false);
                link.getWaitingPO().setException(msg);
                link.getWaitingPO().getSemaphore().notifySingleWaiter();
            }
            if (link.getWaitingClosePO() == null || link.getWaitingClosePO().getSemaphore() == null) continue;
            link.getWaitingClosePO().setSuccess(false);
            link.getWaitingClosePO().setException(msg);
            link.getWaitingClosePO().getSemaphore().notifySingleWaiter();
        }
        Iterator iter = this.waitingPO.entrySet().iterator();
        while (iter.hasNext()) {
            POObject wpo = (POObject)iter.next().getValue();
            if (wpo == null || wpo.getSemaphore() == null) continue;
            wpo.setSuccess(false);
            wpo.setException(msg);
            wpo.getSemaphore().notifySingleWaiter();
        }
        for (int i = 0; i < po.length; ++i) {
            if (po[i] == null || po[i].getSemaphore() == null) continue;
            po[i].setSuccess(false);
            po[i].setException(msg);
            po[i].getSemaphore().notifySingleWaiter();
        }
    }

    private void removeDeliveries(Link link, Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            DeliveryMapping deliveryMapping = (DeliveryMapping)entry.getValue();
            if (deliveryMapping.link != link) continue;
            iter.remove();
        }
    }

    private AMQPMap getUnsettledMap(DeliveryMemory deliveryMemory) throws IOException {
        Collection<UnsettledDelivery> unsettledDeliveries = deliveryMemory.getUnsettled();
        if (unsettledDeliveries == null || unsettledDeliveries.size() == 0) {
            return null;
        }
        HashMap<AMQPType, AMQPType> dmap = new HashMap<AMQPType, AMQPType>(unsettledDeliveries.size());
        for (UnsettledDelivery unsettledDelivery : unsettledDeliveries) {
            dmap.put(unsettledDelivery.getDeliveryTag(), unsettledDelivery.getDeliveryStateIF() != null ? (AMQPType)((Object)unsettledDelivery.getDeliveryStateIF()) : new AMQPNull());
        }
        return new AMQPMap(dmap);
    }

    public void setMyChannel(int myChannel) {
        this.myChannel = myChannel;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public void dispatch(POObject po) {
        this.pipelineQueue.enqueue(po);
    }

    @Override
    public void visit(POBegin po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        this.beginPO = po;
        try {
            BeginFrame beginFrame = new BeginFrame(this.mySession.getChannel());
            beginFrame.setHandleMax(new Handle(Integer.MAX_VALUE));
            beginFrame.setNextOutgoingId(new TransferNumber(this.nextOutgoingId));
            beginFrame.setIncomingWindow(new AMQPUnsignedInt(this.incomingWindow));
            beginFrame.setOutgoingWindow(new AMQPUnsignedInt(this.outgoingWindow));
            this.outboundHandler.send(beginFrame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.checkBothSidesBegin();
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POAttachProducer po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        String name = null;
        DeliveryMemory deliveryMemory = po.getDeliveryMemory();
        if (deliveryMemory.getLinkName() != null) {
            name = deliveryMemory.getLinkName();
        } else {
            name = this.uniqueSessionId + "/" + po.getTarget() + "/" + this.nextLinkId++;
            deliveryMemory.setLinkName(name);
        }
        Producer producer = new Producer(this.mySession, po.getTarget(), name, po.getQoS(), deliveryMemory);
        int handle = ArrayListTool.setFirstFreeOrExpand(this.handles, producer);
        producer.setHandle(handle);
        po.setLink(producer);
        this.waitingPO.put(name, po);
        try {
            AttachFrame attachFrame = new AttachFrame(this.mySession.getChannel());
            attachFrame.setName(new AMQPString(name));
            attachFrame.setHandle(new Handle(handle));
            attachFrame.setRole(Role.SENDER);
            switch (producer.getQoS()) {
                case 1: {
                    attachFrame.setRcvSettleMode(ReceiverSettleMode.FIRST);
                    break;
                }
                case 0: {
                    attachFrame.setSndSettleMode(SenderSettleMode.SETTLED);
                    break;
                }
                case 2: {
                    attachFrame.setRcvSettleMode(ReceiverSettleMode.SECOND);
                }
            }
            Source source = new Source();
            source.setAddress(new AddressString(name));
            source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
            source.setTimeout(new Seconds(0L));
            attachFrame.setSource(source);
            String t = po.getTarget();
            if (t.equals(Coordinator.DESCRIPTOR_NAME)) {
                Coordinator coordinator = new Coordinator();
                coordinator.setCapabilities(new AMQPArray(163, new AMQPType[]{TxnCapability.LOCAL_TRANSACTIONS}));
                attachFrame.setTarget(coordinator);
            } else {
                Target target = new Target();
                target.setAddress(new AddressString(t));
                target.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
                target.setTimeout(new Seconds(0L));
                attachFrame.setTarget(target);
            }
            attachFrame.setInitialDeliveryCount(new SequenceNo(producer.getDeliveryCountSnd()));
            attachFrame.setUnsettled(this.getUnsettledMap(producer.getDeliveryMemory()));
            this.outboundHandler.send(attachFrame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POAttachConsumer po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        String name = null;
        DeliveryMemory deliveryMemory = po.getDeliveryMemory();
        if (deliveryMemory.getLinkName() != null) {
            name = deliveryMemory.getLinkName();
        } else {
            name = this.uniqueSessionId + "/" + po.getSource() + "/" + this.nextLinkId++;
            deliveryMemory.setLinkName(name);
        }
        Consumer consumer = null;
        consumer = po.getLinkCredit() == -1 ? new Consumer(this.mySession, po.getSource(), name, po.getQoS(), deliveryMemory) : new Consumer(this.mySession, po.getSource(), name, po.getLinkCredit(), po.getQoS(), deliveryMemory);
        int handle = ArrayListTool.setFirstFreeOrExpand(this.handles, consumer);
        consumer.setHandle(handle);
        po.setLink(consumer);
        this.waitingPO.put(name, po);
        try {
            AttachFrame attachFrame = new AttachFrame(this.mySession.getChannel());
            attachFrame.setName(new AMQPString(name));
            attachFrame.setHandle(new Handle(handle));
            attachFrame.setRole(Role.RECEIVER);
            if (consumer.getQoS() == 0) {
                attachFrame.setSndSettleMode(SenderSettleMode.SETTLED);
            }
            Source source = new Source();
            String s = po.getSource();
            if (s != null) {
                source.setAddress(new AddressString(s));
            } else {
                source.setDynamic(AMQPBoolean.TRUE);
            }
            source.setDurable(TerminusDurability.NONE);
            source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
            source.setTimeout(new Seconds(0L));
            HashMap<AMQPSymbol, AMQPType> m = null;
            if (po.isNoLocal()) {
                m = new HashMap<AMQPSymbol, AMQPType>();
                m.put(new AMQPSymbol("no-local-filter"), new NoLocalFilter());
            }
            if (po.getSelector() != null) {
                if (m == null) {
                    m = new HashMap();
                }
                m.put(new AMQPSymbol("jms-selector-filter"), new SelectorFilter(po.getSelector()));
            }
            if (m != null) {
                source.setFilter(new FilterSet(m));
            }
            attachFrame.setSource(source);
            Target target = new Target();
            target.setAddress(new AddressString(name));
            target.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
            target.setTimeout(new Seconds(0L));
            attachFrame.setTarget(target);
            attachFrame.setUnsettled(this.getUnsettledMap(consumer.getDeliveryMemory()));
            this.outboundHandler.send(attachFrame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POAttachDurableConsumer po) {
        DeliveryMemory deliveryMemory;
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        if ((deliveryMemory = po.getDeliveryMemory()).getLinkName() != null) {
            deliveryMemory.setLinkName(po.getLinkName());
        }
        DurableConsumer consumer = new DurableConsumer(this.mySession, po.getSource(), po.getLinkName(), po.getLinkCredit(), po.getQoS(), deliveryMemory);
        int handle = ArrayListTool.setFirstFreeOrExpand(this.handles, consumer);
        consumer.setHandle(handle);
        po.setLink(consumer);
        this.waitingPO.put(po.getLinkName(), po);
        try {
            AttachFrame attachFrame = new AttachFrame(this.mySession.getChannel());
            attachFrame.setName(new AMQPString(po.getLinkName()));
            attachFrame.setHandle(new Handle(handle));
            attachFrame.setRole(Role.RECEIVER);
            if (consumer.getQoS() == 0) {
                attachFrame.setSndSettleMode(SenderSettleMode.SETTLED);
            }
            Source source = new Source();
            String s = po.getSource();
            if (s != null) {
                source.setAddress(new AddressString(s));
            } else {
                source.setDynamic(AMQPBoolean.TRUE);
            }
            source.setDurable(TerminusDurability.CONFIGURATION);
            source.setExpiryPolicy(po.getExpiryPolicy());
            source.setTimeout(new Seconds(0L));
            HashMap<AMQPSymbol, AMQPType> m = null;
            if (po.isNoLocal()) {
                m = new HashMap<AMQPSymbol, AMQPType>();
                m.put(new AMQPSymbol("no-local-filter"), new NoLocalFilter());
            }
            if (po.getSelector() != null) {
                if (m == null) {
                    m = new HashMap();
                }
                m.put(new AMQPSymbol("jms-selector-filter"), new SelectorFilter(po.getSelector()));
            }
            if (m != null) {
                source.setFilter(new FilterSet(m));
            }
            attachFrame.setSource(source);
            Target target = new Target();
            target.setAddress(new AddressString(this.uniqueSessionId + "/" + po.getSource() + "/" + this.nextLinkId++));
            target.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
            target.setTimeout(new Seconds(0L));
            attachFrame.setTarget(target);
            attachFrame.setUnsettled(this.getUnsettledMap(consumer.getDeliveryMemory()));
            this.outboundHandler.send(attachFrame);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POSendMessage po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        Producer producer = po.getProducer();
        long linkCredit = producer.getLinkCredit();
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + ", linkCredit=" + linkCredit);
        }
        if (linkCredit <= 0L) {
            producer.setWaitingForFlowReleasePO(po);
        } else {
            this.doSend(po);
        }
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POSendResumedTransfer po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        TransferFrame frame = new TransferFrame(this.mySession.getChannel());
        frame.setHandle(new Handle(po.getProducer().getHandle()));
        frame.setSettled(new AMQPBoolean(true));
        frame.setResume(new AMQPBoolean(true));
        frame.setDeliveryId(new DeliveryNumber(this.nextOutgoingId++));
        frame.setDeliveryTag(po.getDeliveryTag());
        frame.setState(new Accepted());
        this.outboundHandler.send(frame);
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POSendDisposition po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        boolean settled = po.getConsumer().getQoS() == 1 || po.getConsumer().getQoS() == 0;
        DispositionFrame dispoFrame = new DispositionFrame(this.mySession.getChannel());
        dispoFrame.setRole(Role.RECEIVER);
        dispoFrame.setBatchable(AMQPBoolean.TRUE);
        dispoFrame.setFirst(new DeliveryNumber(po.getDeliveryId()));
        dispoFrame.setSettled(new AMQPBoolean(settled));
        dispoFrame.setState(po.getDeliveryState());
        if (po.getConsumer().getQoS() == 2) {
            if (!(po.getDeliveryState() instanceof TransactionalState)) {
                po.getConsumer().getDeliveryMemory().addUnsettledDelivery(new UnsettledDelivery(po.getDeliveryTag(), po.getDeliveryState(), null));
            }
            this.unsettledIncomingDeliveries.put(po.getDeliveryId(), new DeliveryMapping(po.getDeliveryTag(), po.getConsumer()));
        }
        this.outboundHandler.send(dispoFrame);
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POFillCache po) {
        TxnIdIF txnIdIF;
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        Consumer c = po.getConsumer();
        FlowFrame flowFrame = new FlowFrame(this.mySession.getChannel());
        flowFrame.setHandle(new Handle(c.getHandle()));
        flowFrame.setAvailable(new AMQPUnsignedInt(0L));
        flowFrame.setDrain(AMQPBoolean.FALSE);
        flowFrame.setNextIncomingId(new TransferNumber(this.nextIncomingId));
        flowFrame.setNextOutgoingId(new TransferNumber(this.nextOutgoingId));
        flowFrame.setLinkCredit(new AMQPUnsignedInt(po.getLinkCredit()));
        flowFrame.setIncomingWindow(new AMQPUnsignedInt(this.incomingWindow));
        flowFrame.setOutgoingWindow(new AMQPUnsignedInt(this.outgoingWindow));
        if (po.getLastDeliveryId() != -1L) {
            flowFrame.setDeliveryCount(new SequenceNo(po.getLastDeliveryId()));
        }
        if ((txnIdIF = po.getTxnIdIF()) != null) {
            HashMap<AMQPSymbol, TxnIdIF> map = new HashMap<AMQPSymbol, TxnIdIF>();
            map.put(new AMQPSymbol("txn-id"), txnIdIF);
            try {
                flowFrame.setProperties(new Fields(map));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.outboundHandler.send(flowFrame);
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POSessionFrameReceived po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        po.getFrame().accept(this.visitor);
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POSendEnd po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        this.endPO = po;
        try {
            EndFrame endFrame = new EndFrame(this.mySession.getChannel());
            if (po.getCondition() != null) {
                Error error = new Error();
                error.setCondition(ErrorConditionFactory.create(new AMQPSymbol(po.getCondition())));
                endFrame.setError(error);
            }
            this.outboundHandler.send(endFrame);
            this.checkBothSidesEnd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POCloseLink po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        Link link = po.getLink();
        link.setWaitingClosePO(po);
        if (link.getDeliveryMemory().getNumberUnsettled() == 0 && link.getWaitingPO() == null) {
            DetachFrame detachFrame = new DetachFrame(this.mySession.getChannel());
            detachFrame.setHandle(new Handle(link.getHandle()));
            detachFrame.setClosed(new AMQPBoolean(true));
            this.outboundHandler.send(detachFrame);
        }
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    @Override
    public void visit(POSessionClose po) {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " ...");
        }
        this.notifyWaitingPOs(new POObject[]{this.beginPO, this.endPO});
        this.handles.clear();
        this.remoteHandles.clear();
        this.unsettledOutgoingDeliveries.clear();
        this.unsettledIncomingDeliveries.clear();
        for (int i = 0; i < this.outboundDeliveries.size(); ++i) {
            POSendMessage sm = (POSendMessage)this.outboundDeliveries.get(i);
            if (sm.getSemaphore() == null) continue;
            sm.setSuccess(false);
            sm.setException("Session was asynchronously closed");
            sm.getSemaphore().notifySingleWaiter();
        }
        this.outboundDeliveries.clear();
        this.waitingPO.clear();
        this.closed = true;
        this.pipelineQueue.close();
        po.setSuccess(true);
        if (po.getSemaphore() != null) {
            po.getSemaphore().notifySingleWaiter();
        }
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", visit, po=" + po + " done");
        }
    }

    public void close() {
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", close ...");
        }
        if (this.closeInProgress) {
            if (this.pTracer.isEnabled()) {
                this.pTracer.trace(this.toString(), ", close in progress, return");
            }
            return;
        }
        this.closeLock.lock();
        this.closeInProgress = true;
        this.closeLock.unlock();
        Semaphore sem = new Semaphore();
        this.dispatch(new POSessionClose(sem));
        sem.waitHere();
        if (this.pTracer.isEnabled()) {
            this.pTracer.trace(this.toString(), ", close done");
        }
    }

    public String toString() {
        return "SessionDispatcher, channel=" + this.myChannel;
    }

    private class DeliveryMapping {
        DeliveryTag deliveryTag;
        Link link;

        private DeliveryMapping(DeliveryTag deliveryTag, Link link) {
            this.deliveryTag = deliveryTag;
            this.link = link;
        }
    }

    private class SessionDispatcherFrameVisitor
    implements FrameVisitor {
        private SessionDispatcherFrameVisitor() {
        }

        @Override
        public void visit(OpenFrame frame) {
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        @Override
        public void visit(BeginFrame frame) {
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            if (frame.getNextOutgoingId() != null) {
                SessionDispatcher.this.nextIncomingId = frame.getNextOutgoingId().getValue();
            }
            if (frame.getIncomingWindow() != null) {
                SessionDispatcher.this.remoteIncomingWindow = frame.getIncomingWindow().getValue();
            }
            if (frame.getOutgoingWindow() != null) {
                SessionDispatcher.this.remoteOutgoingWindow = frame.getOutgoingWindow().getValue();
            }
            SessionDispatcher.this.remoteBegin = frame;
            SessionDispatcher.this.checkBothSidesBegin();
        }

        @Override
        public void visit(AttachFrame frame) {
            String name;
            POAttach po;
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            if ((po = (POAttach)SessionDispatcher.this.waitingPO.remove(name = frame.getName().getValue())) != null) {
                Semaphore sem;
                Link link = po.getLink();
                SequenceNo idc = frame.getInitialDeliveryCount();
                if (idc != null) {
                    link.setDeliveryCount(idc.getValue());
                } else {
                    link.setDeliveryCount(0L);
                }
                link.setRemoteHandle(frame.getHandle().getValue());
                Source source = (Source)frame.getSource();
                if (source != null) {
                    link.setRemoteAddress(source.getAddress());
                }
                try {
                    link.setOfferedCapabilities(this.toSet(frame.getOfferedCapabilities()));
                    link.setDesiredCapabilities(this.toSet(frame.getDesiredCapabilities()));
                    if (frame.getRole().getValue() == Role.SENDER.getValue()) {
                        if (frame.getSource() != null) {
                            po.setSuccess(true);
                            link.setDestinationCapabilities(this.toSet(((Source)frame.getSource()).getCapabilities()));
                            if (frame.getMaxMessageSize() != null) {
                                link.setMaxMessageSize(frame.getMaxMessageSize().getValue());
                            }
                        } else {
                            po.setSuccess(false);
                            po.setException("Invalid destination");
                        }
                    } else {
                        TargetIF target = frame.getTarget();
                        if (target != null) {
                            po.setSuccess(true);
                            if (target instanceof Coordinator) {
                                link.setDestinationCapabilities(this.toSet(((Coordinator)target).getCapabilities()));
                            } else {
                                link.setDestinationCapabilities(this.toSet(((Target)target).getCapabilities()));
                                if (frame.getMaxMessageSize() != null) {
                                    link.setMaxMessageSize(frame.getMaxMessageSize().getValue());
                                }
                            }
                        } else {
                            po.setSuccess(false);
                            po.setException("Invalid destination");
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SessionDispatcher.this.remoteHandles.put(link.getRemoteHandle(), link);
                if (link instanceof Producer) {
                    ((Producer)link).recover(frame.getUnsettled());
                }
                if ((sem = po.getSemaphore()) != null) {
                    sem.notifySingleWaiter();
                }
            }
        }

        private Set toSet(AMQPArray capabilities) throws IOException {
            AMQPType[] t;
            HashSet<String> set = null;
            if (capabilities != null && (t = capabilities.getValue()) != null && t.length > 0) {
                set = new HashSet<String>();
                for (int i = 0; i < t.length; ++i) {
                    set.add(((AMQPSymbol)t[i]).getValue());
                }
            }
            return set;
        }

        @Override
        public void visit(FlowFrame frame) {
            Link link;
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            if (frame.getNextOutgoingId() != null) {
                SessionDispatcher.this.nextIncomingId = frame.getNextOutgoingId().getValue();
            }
            if (frame.getIncomingWindow() != null) {
                SessionDispatcher.this.remoteIncomingWindow = frame.getIncomingWindow().getValue();
            }
            if (frame.getOutgoingWindow() != null) {
                SessionDispatcher.this.remoteOutgoingWindow = frame.getOutgoingWindow().getValue();
            }
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame + ", old remoteIncomingWindow=" + SessionDispatcher.this.remoteIncomingWindow + ", nextIncomingId=" + SessionDispatcher.this.nextIncomingId + ", nextOutgoingId=" + SessionDispatcher.this.nextOutgoingId);
            }
            SessionDispatcher.this.remoteIncomingWindow = frame.getNextIncomingId() != null ? frame.getNextIncomingId().getValue() + SessionDispatcher.this.remoteIncomingWindow - SessionDispatcher.this.nextOutgoingId : SessionDispatcher.this.initialOutgoingId + SessionDispatcher.this.remoteIncomingWindow - SessionDispatcher.this.nextOutgoingId;
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame + ", new remoteIncomingWindow=" + SessionDispatcher.this.remoteIncomingWindow);
            }
            this.sendOutboundDeliveries();
            if (frame.getHandle() != null && (link = (Link)SessionDispatcher.this.remoteHandles.get(frame.getHandle().getValue())) != null && link instanceof Producer) {
                POSendMessage po;
                SequenceNo dcount;
                AMQPUnsignedInt linkCredit;
                Producer p = (Producer)link;
                AMQPBoolean drain = frame.getDrain();
                if (drain != null) {
                    p.setDrain(drain.getValue());
                }
                if ((linkCredit = frame.getLinkCredit()) != null) {
                    p.setLinkCredit(linkCredit.getValue());
                }
                if ((dcount = frame.getDeliveryCount()) != null) {
                    p.setDeliveryCountRcv(dcount.getValue());
                }
                boolean echoB = false;
                AMQPBoolean echo = frame.getEcho();
                if (echo != null) {
                    echoB = echo.getValue();
                }
                if ((po = p.getWaitingForFlowReleasePO()) != null && (p.getLinkCredit() > 0L || p.isDrain())) {
                    SessionDispatcher.this.doSend(po);
                    p.setWaitingForFlowReleasePO(null);
                }
                if (echoB) {
                    FlowFrame flowFrame = new FlowFrame(SessionDispatcher.this.mySession.getChannel());
                    flowFrame.setHandle(new Handle(p.getHandle()));
                    flowFrame.setAvailable(new AMQPUnsignedInt(p.getAvailable()));
                    flowFrame.setDeliveryCount(new SequenceNo(p.getDeliveryCountSnd()));
                    flowFrame.setDrain(new AMQPBoolean(p.isDrain()));
                    flowFrame.setNextOutgoingId(new TransferNumber(SessionDispatcher.this.nextOutgoingId));
                    flowFrame.setLinkCredit(new AMQPUnsignedInt(p.getLastReceivedLinkCredit()));
                    SessionDispatcher.this.outboundHandler.send(flowFrame);
                }
            }
        }

        private void sendOutboundDeliveries() {
            if (SessionDispatcher.this.outboundDeliveries.size() > 0) {
                POSendMessage[] pos = SessionDispatcher.this.outboundDeliveries.toArray(new POSendMessage[SessionDispatcher.this.outboundDeliveries.size()]);
                SessionDispatcher.this.outboundDeliveries.clear();
                for (int i = 0; i < pos.length; ++i) {
                    SessionDispatcher.this.doSend(pos[i]);
                }
            }
        }

        @Override
        public void visit(TransferFrame frame) {
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            try {
                Consumer c = (Consumer)SessionDispatcher.this.remoteHandles.get(frame.getHandle().getValue());
                if (c != null) {
                    AMQPBoolean resumed = frame.getResume();
                    if (resumed != null && resumed.getValue()) {
                        AMQPBoolean settled;
                        if (SessionDispatcher.this.pTracer.isEnabled()) {
                            SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame + ", RESUMED!");
                        }
                        if ((settled = frame.getSettled()) != null && settled.getValue()) {
                            if (SessionDispatcher.this.pTracer.isEnabled()) {
                                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame + ", RESUMED, settle: " + frame.getDeliveryTag());
                            }
                            c.getDeliveryMemory().deliverySettled(frame.getDeliveryTag());
                            if (c.getDeliveryMemory().getNumberUnsettled() == 0 && c.getWaitingClosePO() != null) {
                                POObject closePO = c.getWaitingClosePO();
                                c.setWaitingClosePO(null);
                                SessionDispatcher.this.dispatch(closePO);
                            }
                        }
                        ++SessionDispatcher.this.nextIncomingId;
                        return;
                    }
                    TransferFrame current = c.getCurrentMessage();
                    if (current == null) {
                        current = frame;
                        c.setCurrentMessage(current);
                    } else {
                        current.addMorePayload(frame.getPayload());
                        if (frame.getSettled() != null) {
                            current.setSettled(frame.getSettled());
                        }
                    }
                    if (frame.getMore() == null || !frame.getMore().getValue()) {
                        c.setCurrentMessage(null);
                        AMQPMessage msg = null;
                        if (current.getMorePayloads() == null) {
                            msg = new AMQPMessage(current.getPayload());
                        } else {
                            List morePayloads = current.getMorePayloads();
                            byte[][] multiBuffer = new byte[morePayloads.size() + 1][];
                            multiBuffer[0] = current.getPayload();
                            int totalLength = multiBuffer[0].length;
                            for (int i = 0; i < morePayloads.size(); ++i) {
                                byte[] b;
                                multiBuffer[i + 1] = b = (byte[])morePayloads.get(i);
                                totalLength += b.length;
                            }
                            msg = new AMQPMessage(multiBuffer, totalLength);
                        }
                        boolean settled = false;
                        if (current.getSettled() != null) {
                            settled = current.getSettled().getValue();
                        }
                        msg.setSettled(settled);
                        msg.setDeliveryId(current.getDeliveryId().getValue());
                        msg.setDeliveryTag(current.getDeliveryTag());
                        DeliveryStateIF deliveryStateIF = current.getState();
                        if (deliveryStateIF != null && deliveryStateIF instanceof TransactionalState) {
                            msg.setTxnIdIF(((TransactionalState)deliveryStateIF).getTxnId());
                        }
                        c.addToCache(msg);
                    }
                } else {
                    DispositionFrame dispoFrame = new DispositionFrame(SessionDispatcher.this.mySession.getChannel());
                    dispoFrame.setRole(Role.RECEIVER);
                    dispoFrame.setFirst(new DeliveryNumber(frame.getDeliveryId().getValue()));
                    dispoFrame.setSettled(AMQPBoolean.FALSE);
                    Rejected rejected = new Rejected();
                    Error error = new Error();
                    error.setCondition(SessionError.UNATTACHED_HANDLE);
                    rejected.setError(error);
                    dispoFrame.setState(rejected);
                    SessionDispatcher.this.outboundHandler.send(dispoFrame);
                }
                ++SessionDispatcher.this.nextIncomingId;
                --SessionDispatcher.this.incomingWindow;
                if (SessionDispatcher.this.pTracer.isEnabled()) {
                    SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame + ", incomingWindow=" + SessionDispatcher.this.incomingWindow);
                }
                if (SessionDispatcher.this.incomingWindow == 0L) {
                    SessionDispatcher.this.incomingWindow = SessionDispatcher.this.mySession.getIncomingWindowSize();
                    FlowFrame flowFrame = new FlowFrame(SessionDispatcher.this.mySession.getChannel());
                    flowFrame.setIncomingWindow(new AMQPUnsignedInt(SessionDispatcher.this.incomingWindow));
                    flowFrame.setNextIncomingId(new TransferNumber(SessionDispatcher.this.nextIncomingId));
                    flowFrame.setOutgoingWindow(new AMQPUnsignedInt(SessionDispatcher.this.outgoingWindow));
                    flowFrame.setNextOutgoingId(new TransferNumber(SessionDispatcher.this.nextOutgoingId));
                    flowFrame.setDrain(AMQPBoolean.FALSE);
                    flowFrame.setEcho(AMQPBoolean.FALSE);
                    SessionDispatcher.this.outboundHandler.send(flowFrame);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void visit(DispositionFrame frame) {
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            if (frame.getRole().getValue() == Role.SENDER.getValue()) {
                if (frame.getSettled().getValue()) {
                    long from = frame.getFirst().getValue();
                    long to = frame.getFirst().getValue();
                    if (frame.getLast() != null) {
                        to = frame.getLast().getValue();
                    }
                    SessionDispatcher.this.settleInbound(from, to, true);
                }
            } else {
                if (frame.getLast() == null) {
                    SessionDispatcher.this.settleOutbound(frame.getFirst().getValue(), frame.getFirst().getValue(), frame.getSettled().getValue(), frame.getState());
                } else {
                    SessionDispatcher.this.settleOutbound(frame.getFirst().getValue(), frame.getLast().getValue(), frame.getSettled().getValue(), frame.getState());
                }
                this.sendOutboundDeliveries();
            }
        }

        @Override
        public void visit(DetachFrame frame) {
            Link link;
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            if ((link = (Link)SessionDispatcher.this.remoteHandles.remove(frame.getHandle().getValue())) != null) {
                if (link instanceof Producer) {
                    SessionDispatcher.this.removeDeliveries(link, SessionDispatcher.this.unsettledOutgoingDeliveries);
                } else {
                    SessionDispatcher.this.removeDeliveries(link, SessionDispatcher.this.unsettledIncomingDeliveries);
                }
                SessionDispatcher.this.handles.set(link.getHandle(), null);
                POObject po = link.getWaitingClosePO();
                Error error = frame.getError();
                if (error != null) {
                    link.remoteDetach(frame.getError());
                }
                if (po != null && po.getSemaphore() != null) {
                    if (error != null) {
                        po.setSuccess(false);
                        po.setException(error.getCondition().getValueString() + "/" + error.getDescription().getValue());
                    } else {
                        po.setSuccess(true);
                    }
                    po.getSemaphore().notifySingleWaiter();
                }
                this.sendOutboundDeliveries();
            }
        }

        @Override
        public void visit(EndFrame frame) {
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
            SessionDispatcher.this.remoteEnd = frame;
            SessionDispatcher.this.checkBothSidesEnd();
        }

        @Override
        public void visit(CloseFrame frame) {
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        public void visit(SaslMechanismsFrame frame) {
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        public void visit(SaslInitFrame frame) {
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        public void visit(SaslChallengeFrame frame) {
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        public void visit(SaslResponseFrame frame) {
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        public void visit(SaslOutcomeFrame frame) {
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        @Override
        public void visit(HeartbeatFrame frame) {
            if (SessionDispatcher.this.pTracer.isEnabled()) {
                SessionDispatcher.this.pTracer.trace(this.toString(), ", visit=" + frame);
            }
        }

        public String toString() {
            return "SessionDispatcherFrameVisitor";
        }
    }
}

