/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.client;

import com.swiftmq.amqp.v100.client.AMQPException;
import com.swiftmq.amqp.v100.client.Producer;
import com.swiftmq.amqp.v100.client.Session;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateIF;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.Rejected;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AmqpValue;
import com.swiftmq.amqp.v100.generated.transactions.coordination.Coordinator;
import com.swiftmq.amqp.v100.generated.transactions.coordination.Declare;
import com.swiftmq.amqp.v100.generated.transactions.coordination.Declared;
import com.swiftmq.amqp.v100.generated.transactions.coordination.Discharge;
import com.swiftmq.amqp.v100.generated.transactions.coordination.TxnCapability;
import com.swiftmq.amqp.v100.generated.transactions.coordination.TxnIdIF;
import com.swiftmq.amqp.v100.generated.transport.definitions.Error;
import com.swiftmq.amqp.v100.messaging.AMQPMessage;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import java.util.Set;

public class TransactionController {
    Session mySession;
    Producer producer;
    volatile boolean supportLocalTransactions = true;
    volatile boolean supportDistributedTransactions = false;
    volatile boolean supportPromotableTransactions = false;
    volatile boolean supportMultiTxnsPerSsn = false;
    volatile boolean supportMultiSsnsPerTxn = false;

    protected TransactionController(Session mySession) {
        this.mySession = mySession;
    }

    public synchronized TxnIdIF createTxnId() throws AMQPException {
        if (this.producer == null) {
            this.producer = this.mySession.createProducer(Coordinator.DESCRIPTOR_NAME, 1);
            this.producer.setTransactionController(true);
            Set<AMQPSymbol> capa = this.producer.getDestinationCapabilities();
            if (capa != null) {
                if (capa.contains(TxnCapability.LOCAL_TRANSACTIONS.getValue())) {
                    this.supportLocalTransactions = true;
                }
                this.supportDistributedTransactions = capa.contains(TxnCapability.DISTRIBUTED_TRANSACTIONS.getValue());
                this.supportPromotableTransactions = capa.contains(TxnCapability.PROMOTABLE_TRANSACTIONS.getValue());
                this.supportMultiTxnsPerSsn = capa.contains(TxnCapability.MULTI_TXNS_PER_SSN.getValue());
                this.supportMultiSsnsPerTxn = capa.contains(TxnCapability.MULTI_SSNS_PER_TXN.getValue());
            }
        }
        AMQPMessage msg = new AMQPMessage();
        msg.setAmqpValue(new AmqpValue(new Declare()));
        Declared declared = (Declared)this.producer.send(msg);
        return declared == null ? null : declared.getTxnId();
    }

    private synchronized void discharge(TxnIdIF txnId, boolean fail) throws AMQPException {
        AMQPMessage msg = new AMQPMessage();
        Discharge discharge = new Discharge();
        discharge.setTxnId(txnId);
        discharge.setFail(new AMQPBoolean(fail));
        msg.setAmqpValue(new AmqpValue(discharge));
        DeliveryStateIF deliveryState = this.producer.send(msg);
        if (deliveryState instanceof Rejected) {
            Rejected rejected = (Rejected)deliveryState;
            Error error = rejected.getError();
            if (error != null) {
                throw new AMQPException(error.getValueString());
            }
            throw new AMQPException("Unknown transactiom error");
        }
    }

    public void commit(TxnIdIF txnId) throws AMQPException {
        this.discharge(txnId, false);
    }

    public void rollback(TxnIdIF txnId) throws AMQPException {
        this.discharge(txnId, true);
    }

    public boolean isSupportLocalTransactions() {
        return this.supportLocalTransactions;
    }

    public boolean isSupportDistributedTransactions() {
        return this.supportDistributedTransactions;
    }

    public boolean isSupportPromotableTransactions() {
        return this.supportPromotableTransactions;
    }

    public boolean isSupportMultiTxnsPerSsn() {
        return this.supportMultiTxnsPerSsn;
    }

    public boolean isSupportMultiSsnsPerTxn() {
        return this.supportMultiSsnsPerTxn;
    }

    protected void close() {
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (AMQPException aMQPException) {
                // empty catch block
            }
            this.producer = null;
        }
    }

    public String toString() {
        return "[TransaactionController, supportLocalTransactions=" + this.supportLocalTransactions + ", supportDistributedTransactions=" + this.supportDistributedTransactions + ", supportPromotableTransactions=" + this.supportPromotableTransactions + ", supportMultiTxnsPerSsn=" + this.supportMultiTxnsPerSsn + ", supportMultiSsnsPerTxn=" + this.supportMultiSsnsPerTxn + "]";
    }
}

