/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.client.po;

import com.swiftmq.amqp.v100.client.Producer;
import com.swiftmq.amqp.v100.client.SessionVisitor;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateIF;
import com.swiftmq.amqp.v100.generated.transactions.coordination.TxnIdIF;
import com.swiftmq.amqp.v100.generated.transport.definitions.DeliveryTag;
import com.swiftmq.amqp.v100.messaging.AMQPMessage;
import com.swiftmq.amqp.v100.transport.Packager;
import com.swiftmq.tools.concurrent.Semaphore;
import com.swiftmq.tools.pipeline.POObject;
import com.swiftmq.tools.pipeline.POVisitor;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.io.IOException;

public class POSendMessage
extends POObject {
    Producer producer;
    AMQPMessage message;
    TxnIdIF txnId;
    DeliveryStateIF deliveryState = null;
    DeliveryTag deliveryTag = null;
    Packager packager = new Packager();
    boolean recovery = false;

    public POSendMessage(Semaphore semaphore, Producer producer, AMQPMessage message, TxnIdIF txnId, DeliveryTag deliveryTag) throws IOException {
        super(null, semaphore);
        this.producer = producer;
        this.message = message;
        this.txnId = txnId;
        this.deliveryTag = deliveryTag;
        DataByteArrayOutputStream dbos = new DataByteArrayOutputStream();
        message.writeContent(dbos);
        this.packager.setChannel(producer.getMySession().getChannel());
        this.packager.setHandle(producer.getHandle());
        this.packager.setSettled(producer.getQoS() == 0);
        this.packager.setData(dbos.getBuffer(), dbos.getCount());
        dbos = null;
    }

    public Producer getProducer() {
        return this.producer;
    }

    public synchronized DeliveryStateIF getDeliveryState() {
        return this.deliveryState;
    }

    public synchronized void setDeliveryState(DeliveryStateIF deliveryState) {
        this.deliveryState = deliveryState;
    }

    public DeliveryTag getDeliveryTag() {
        return this.deliveryTag;
    }

    public TxnIdIF getTxnId() {
        return this.txnId;
    }

    public AMQPMessage getMessage() {
        return this.message;
    }

    public Packager getPackager() {
        return this.packager;
    }

    public boolean isRecovery() {
        return this.recovery;
    }

    public void setRecovery(boolean recovery) {
        this.recovery = recovery;
    }

    @Override
    public void accept(POVisitor visitor) {
        ((SessionVisitor)visitor).visit(this);
    }

    public String toString() {
        return "[POSendMessage, producer=" + this.producer + ", message=" + this.message + ", txnId=" + this.txnId + ", deliveryState=" + this.deliveryState + ", deliveryTag=" + this.deliveryTag + ", recovery=" + this.recovery + "]";
    }
}

