/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated;

import com.swiftmq.amqp.v100.generated.security.sasl.SaslFrameFactory;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslFrameIF;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameFactory;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameIF;
import com.swiftmq.amqp.v100.transport.AMQPFrame;
import com.swiftmq.amqp.v100.transport.HeartbeatFrame;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.tools.util.LengthCaptureDataInput;
import java.io.IOException;

public class FrameReader {
    public static FrameIF createFrame(LengthCaptureDataInput in) throws Exception {
        long bodySize;
        long frameSize = 0L;
        byte dataOffset = 0;
        byte typeCode = 0;
        int channel = 0;
        byte[] extendedHeader = null;
        in.startCaptureLength();
        frameSize = in.readInt();
        dataOffset = in.readByte();
        typeCode = in.readByte();
        if (typeCode != AMQPFrame.TYPE_CODE_AMQP_FRAME && typeCode != AMQPFrame.TYPE_CODE_SASL_FRAME) {
            throw new IOException("Invalid frame type (" + typeCode + "), not an AMQP or SASL frame!");
        }
        channel = in.readUnsignedShort();
        byte doff = dataOffset;
        if (doff < 2) {
            throw new Exception("Malformed frame, data offset is " + doff);
        }
        if (doff > 2) {
            extendedHeader = new byte[doff * 4 - 8];
            in.readFully(extendedHeader);
        }
        if ((bodySize = frameSize - (long)(doff * 4)) > 0L) {
            if (bodySize > Integer.MAX_VALUE) {
                throw new Exception("Frame body size (" + bodySize + ") is greater than Integer.MAX_VALUE (" + Integer.MAX_VALUE + ")");
            }
        } else {
            return new HeartbeatFrame(channel);
        }
        AMQPFrame frame = (AMQPFrame)FrameFactory.create(channel, AMQPTypeDecoder.decode(in));
        int plLength = (int)(frameSize - in.stopCaptureLength());
        if (plLength > 0) {
            byte[] b = new byte[plLength];
            in.readFully(b);
            frame.setPayload(b);
        }
        return frame;
    }

    public static SaslFrameIF createSaslFrame(LengthCaptureDataInput in) throws Exception {
        long bodySize;
        long frameSize = 0L;
        byte dataOffset = 0;
        byte typeCode = 0;
        int channel = 0;
        byte[] extendedHeader = null;
        in.startCaptureLength();
        frameSize = in.readInt();
        dataOffset = in.readByte();
        typeCode = in.readByte();
        if (typeCode != AMQPFrame.TYPE_CODE_AMQP_FRAME && typeCode != AMQPFrame.TYPE_CODE_SASL_FRAME) {
            throw new IOException("Invalid frame type (" + typeCode + "), not an AMQP or SASL frame!");
        }
        channel = in.readUnsignedShort();
        byte doff = dataOffset;
        if (doff < 2) {
            throw new Exception("Malformed frame, data offset is " + doff);
        }
        if (doff > 2) {
            extendedHeader = new byte[doff * 4 - 8];
            in.readFully(extendedHeader);
        }
        if ((bodySize = frameSize - (long)(doff * 4)) > 0L) {
            if (bodySize > Integer.MAX_VALUE) {
                throw new Exception("Frame body size (" + bodySize + ") is greater than Integer.MAX_VALUE (" + Integer.MAX_VALUE + ")");
            }
        } else {
            return new HeartbeatFrame(channel);
        }
        AMQPFrame frame = (AMQPFrame)SaslFrameFactory.create(channel, AMQPTypeDecoder.decode(in));
        int plLength = (int)(frameSize - in.stopCaptureLength());
        if (plLength > 0) {
            byte[] b = new byte[plLength];
            in.readFully(b);
            frame.setPayload(b);
        }
        return frame;
    }
}

