/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.filter.filter_types;

import com.swiftmq.amqp.v100.generated.filter.filter_types.FilterIF;
import com.swiftmq.amqp.v100.generated.filter.filter_types.NoLocalFilter;
import com.swiftmq.amqp.v100.generated.filter.filter_types.SelectorFilter;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.IOException;
import java.util.List;

public class FilterFactory {
    public static FilterIF create(AMQPType bare) throws Exception {
        if (bare.getCode() == 64) {
            return null;
        }
        AMQPDescribedConstructor constructor = bare.getConstructor();
        if (constructor == null) {
            throw new IOException("Missing constructor: " + bare);
        }
        AMQPType descriptor = constructor.getDescriptor();
        int code = descriptor.getCode();
        if (AMQPTypeDecoder.isULong(code)) {
            long type = ((AMQPUnsignedLong)descriptor).getValue();
            if (type == NoLocalFilter.DESCRIPTOR_CODE) {
                return new NoLocalFilter((List)((AMQPList)bare).getValue());
            }
            if (type == SelectorFilter.DESCRIPTOR_CODE) {
                return new SelectorFilter(((AMQPString)bare).getValue());
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        if (AMQPTypeDecoder.isSymbol(code)) {
            String type = ((AMQPSymbol)descriptor).getValue();
            if (type.equals(NoLocalFilter.DESCRIPTOR_NAME)) {
                return new NoLocalFilter((List)((AMQPList)bare).getValue());
            }
            if (type.equals(SelectorFilter.DESCRIPTOR_NAME)) {
                return new SelectorFilter(((AMQPString)bare).getValue());
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        throw new Exception("Invalid type of constructor descriptor (actual type=" + code + ", expected=symbold or ulong), bare= " + bare);
    }

    public static FilterIF[] toNativeArray(AMQPArray array) throws Exception {
        if (array == null) {
            return null;
        }
        AMQPType[] value = array.getValue();
        if (value == null) {
            return null;
        }
        FilterIF[] n = new FilterIF[value.length];
        for (int i = 0; i < value.length; ++i) {
            n[i] = FilterFactory.create(value[i]);
        }
        return n;
    }
}

