/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.messaging.addressing;

import com.swiftmq.amqp.v100.generated.messaging.addressing.DeleteOnClose;
import com.swiftmq.amqp.v100.generated.messaging.addressing.DeleteOnNoLinks;
import com.swiftmq.amqp.v100.generated.messaging.addressing.DeleteOnNoLinksOrMessages;
import com.swiftmq.amqp.v100.generated.messaging.addressing.DeleteOnNoMessages;
import com.swiftmq.amqp.v100.generated.messaging.addressing.LifetimePolicyIF;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.IOException;
import java.util.List;

public class LifetimePolicyFactory {
    public static LifetimePolicyIF create(AMQPType bare) throws Exception {
        if (bare.getCode() == 64) {
            return null;
        }
        AMQPDescribedConstructor constructor = bare.getConstructor();
        if (constructor == null) {
            throw new IOException("Missing constructor: " + bare);
        }
        AMQPType descriptor = constructor.getDescriptor();
        int code = descriptor.getCode();
        if (AMQPTypeDecoder.isULong(code)) {
            long type = ((AMQPUnsignedLong)descriptor).getValue();
            if (type == DeleteOnClose.DESCRIPTOR_CODE) {
                return new DeleteOnClose((List)((AMQPList)bare).getValue());
            }
            if (type == DeleteOnNoLinks.DESCRIPTOR_CODE) {
                return new DeleteOnNoLinks((List)((AMQPList)bare).getValue());
            }
            if (type == DeleteOnNoMessages.DESCRIPTOR_CODE) {
                return new DeleteOnNoMessages((List)((AMQPList)bare).getValue());
            }
            if (type == DeleteOnNoLinksOrMessages.DESCRIPTOR_CODE) {
                return new DeleteOnNoLinksOrMessages((List)((AMQPList)bare).getValue());
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        if (AMQPTypeDecoder.isSymbol(code)) {
            String type = ((AMQPSymbol)descriptor).getValue();
            if (type.equals(DeleteOnClose.DESCRIPTOR_NAME)) {
                return new DeleteOnClose((List)((AMQPList)bare).getValue());
            }
            if (type.equals(DeleteOnNoLinks.DESCRIPTOR_NAME)) {
                return new DeleteOnNoLinks((List)((AMQPList)bare).getValue());
            }
            if (type.equals(DeleteOnNoMessages.DESCRIPTOR_NAME)) {
                return new DeleteOnNoMessages((List)((AMQPList)bare).getValue());
            }
            if (type.equals(DeleteOnNoLinksOrMessages.DESCRIPTOR_NAME)) {
                return new DeleteOnNoLinksOrMessages((List)((AMQPList)bare).getValue());
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        throw new Exception("Invalid type of constructor descriptor (actual type=" + code + ", expected=symbold or ulong), bare= " + bare);
    }

    public static LifetimePolicyIF[] toNativeArray(AMQPArray array) throws Exception {
        if (array == null) {
            return null;
        }
        AMQPType[] value = array.getValue();
        if (value == null) {
            return null;
        }
        LifetimePolicyIF[] n = new LifetimePolicyIF[value.length];
        for (int i = 0; i < value.length; ++i) {
            n[i] = LifetimePolicyFactory.create(value[i]);
        }
        return n;
    }
}

