/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.messaging.addressing;

import com.swiftmq.amqp.v100.generated.messaging.addressing.DistributionModeFactory;
import com.swiftmq.amqp.v100.generated.messaging.addressing.DistributionModeIF;
import com.swiftmq.amqp.v100.generated.messaging.addressing.FilterSet;
import com.swiftmq.amqp.v100.generated.messaging.addressing.NodeProperties;
import com.swiftmq.amqp.v100.generated.messaging.addressing.SourceIF;
import com.swiftmq.amqp.v100.generated.messaging.addressing.SourceVisitor;
import com.swiftmq.amqp.v100.generated.messaging.addressing.TerminusDurability;
import com.swiftmq.amqp.v100.generated.messaging.addressing.TerminusExpiryPolicy;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.OutcomeFactory;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.OutcomeIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressFactory;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressIF;
import com.swiftmq.amqp.v100.generated.transport.definitions.Seconds;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPMap;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Source
extends AMQPList
implements SourceIF {
    public static String DESCRIPTOR_NAME = "amqp:source:list";
    public static long DESCRIPTOR_CODE = 40L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    boolean dirty = false;
    AddressIF address = null;
    TerminusDurability durable = TerminusDurability.NONE;
    TerminusExpiryPolicy expiryPolicy = TerminusExpiryPolicy.SESSION_END;
    Seconds timeout = new Seconds(0L);
    AMQPBoolean dynamic = AMQPBoolean.FALSE;
    NodeProperties dynamicNodeProperties = null;
    DistributionModeIF distributionMode = null;
    FilterSet filter = null;
    OutcomeIF defaultOutcome = null;
    AMQPArray outcomes = null;
    AMQPArray capabilities = null;

    public Source(List initValue) throws Exception {
        super(initValue);
        if (initValue != null) {
            this.decode();
        }
    }

    public Source() {
        this.dirty = true;
    }

    @Override
    public boolean hasDescriptor() {
        return true;
    }

    @Override
    public void accept(SourceVisitor visitor) {
        visitor.visit(this);
    }

    public AddressIF getAddress() {
        return this.address;
    }

    public void setAddress(AddressIF address) {
        this.dirty = true;
        this.address = address;
    }

    public TerminusDurability getDurable() {
        return this.durable;
    }

    public void setDurable(TerminusDurability durable) {
        this.dirty = true;
        this.durable = durable;
    }

    public TerminusExpiryPolicy getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public void setExpiryPolicy(TerminusExpiryPolicy expiryPolicy) {
        this.dirty = true;
        this.expiryPolicy = expiryPolicy;
    }

    public Seconds getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Seconds timeout) {
        this.dirty = true;
        this.timeout = timeout;
    }

    public AMQPBoolean getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(AMQPBoolean dynamic) {
        this.dirty = true;
        this.dynamic = dynamic;
    }

    public NodeProperties getDynamicNodeProperties() {
        return this.dynamicNodeProperties;
    }

    public void setDynamicNodeProperties(NodeProperties dynamicNodeProperties) {
        this.dirty = true;
        this.dynamicNodeProperties = dynamicNodeProperties;
    }

    public DistributionModeIF getDistributionMode() {
        return this.distributionMode;
    }

    public void setDistributionMode(DistributionModeIF distributionMode) {
        this.dirty = true;
        this.distributionMode = distributionMode;
    }

    public FilterSet getFilter() {
        return this.filter;
    }

    public void setFilter(FilterSet filter) {
        this.dirty = true;
        this.filter = filter;
    }

    public OutcomeIF getDefaultOutcome() {
        return this.defaultOutcome;
    }

    public void setDefaultOutcome(OutcomeIF defaultOutcome) {
        this.dirty = true;
        this.defaultOutcome = defaultOutcome;
    }

    public AMQPArray getOutcomes() {
        return this.outcomes;
    }

    public void setOutcomes(AMQPArray outcomes) {
        this.dirty = true;
        this.outcomes = outcomes;
    }

    public AMQPArray getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(AMQPArray capabilities) {
        this.dirty = true;
        this.capabilities = capabilities;
    }

    @Override
    public int getPredictedSize() {
        int n;
        if (this.dirty) {
            AMQPDescribedConstructor _c = this.getConstructor();
            this.setConstructor(null);
            n = super.getPredictedSize();
            n += this.codeConstructor.getPredictedSize();
            n += this.address != null ? this.address.getPredictedSize() : 1;
            n += this.durable != null ? this.durable.getPredictedSize() : 1;
            n += this.expiryPolicy != null ? this.expiryPolicy.getPredictedSize() : 1;
            n += this.timeout != null ? this.timeout.getPredictedSize() : 1;
            n += this.dynamic != null ? this.dynamic.getPredictedSize() : 1;
            n += this.dynamicNodeProperties != null ? this.dynamicNodeProperties.getPredictedSize() : 1;
            n += this.distributionMode != null ? this.distributionMode.getPredictedSize() : 1;
            n += this.filter != null ? this.filter.getPredictedSize() : 1;
            n += this.defaultOutcome != null ? this.defaultOutcome.getPredictedSize() : 1;
            n += this.outcomes != null ? this.outcomes.getPredictedSize() : 1;
            n += this.capabilities != null ? this.capabilities.getPredictedSize() : 1;
            this.setConstructor(_c);
        } else {
            n = super.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() != 64) {
            this.address = AddressFactory.create(t);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.durable = new TerminusDurability(((AMQPUnsignedInt)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'durable' in 'Source' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.expiryPolicy = new TerminusExpiryPolicy(((AMQPSymbol)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'expiryPolicy' in 'Source' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.timeout = new Seconds(((AMQPUnsignedInt)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'timeout' in 'Source' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.dynamic = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'dynamic' in 'Source' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.dynamicNodeProperties = new NodeProperties((Map)((AMQPMap)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'dynamicNodeProperties' in 'Source' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() != 64) {
            this.distributionMode = DistributionModeFactory.create(t);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.filter = new FilterSet((Map)((AMQPMap)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'filter' in 'Source' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() != 64) {
            this.defaultOutcome = OutcomeFactory.create(t);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.outcomes = AMQPTypeDecoder.isArray(t.getCode()) ? (AMQPArray)t : this.singleToArray(t);
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'outcomes' in 'Source' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.capabilities = AMQPTypeDecoder.isArray(t.getCode()) ? (AMQPArray)t : this.singleToArray(t);
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'capabilities' in 'Source' type: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.address);
        this.addToList(l, this.durable);
        this.addToList(l, this.expiryPolicy);
        this.addToList(l, this.timeout);
        this.addToList(l, this.dynamic);
        this.addToList(l, this.dynamicNodeProperties);
        this.addToList(l, this.distributionMode);
        this.addToList(l, this.filter);
        this.addToList(l, this.defaultOutcome);
        this.addToList(l, this.outcomes);
        this.addToList(l, this.capabilities);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.setValue(l);
        this.dirty = false;
    }

    public AMQPDescribedConstructor getArrayConstructor() throws IOException {
        if (this.dirty) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.getCode());
        return this.codeConstructor;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        if (this.dirty) {
            this.encode();
        }
        if (this.getConstructor() != this.codeConstructor) {
            this.codeConstructor.setFormatCode(this.getCode());
            this.setConstructor(this.codeConstructor);
        }
        super.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[Source ");
        b.append(this.getDisplayString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.address != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("address=");
            b.append(this.address.getValueString());
        }
        if (this.durable != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("durable=");
            b.append(this.durable.getValueString());
        }
        if (this.expiryPolicy != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("expiryPolicy=");
            b.append(this.expiryPolicy.getValueString());
        }
        if (this.timeout != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("timeout=");
            b.append(this.timeout.getValueString());
        }
        if (this.dynamic != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("dynamic=");
            b.append(this.dynamic.getValueString());
        }
        if (this.dynamicNodeProperties != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("dynamicNodeProperties=");
            b.append(this.dynamicNodeProperties.getValueString());
        }
        if (this.distributionMode != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("distributionMode=");
            b.append(this.distributionMode.getValueString());
        }
        if (this.filter != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("filter=");
            b.append(this.filter.getValueString());
        }
        if (this.defaultOutcome != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("defaultOutcome=");
            b.append(this.defaultOutcome.getValueString());
        }
        if (this.outcomes != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("outcomes=");
            b.append(this.outcomes.getValueString());
        }
        if (this.capabilities != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("capabilities=");
            b.append(this.capabilities.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[Source " + this.getDisplayString() + "]";
    }
}

