/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.messaging.addressing;

import com.swiftmq.amqp.v100.generated.messaging.addressing.Source;
import com.swiftmq.amqp.v100.generated.messaging.addressing.SourceIF;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.IOException;
import java.util.List;

public class SourceFactory {
    public static SourceIF create(AMQPType bare) throws Exception {
        if (bare.getCode() == 64) {
            return null;
        }
        AMQPDescribedConstructor constructor = bare.getConstructor();
        if (constructor == null) {
            throw new IOException("Missing constructor: " + bare);
        }
        AMQPType descriptor = constructor.getDescriptor();
        int code = descriptor.getCode();
        if (AMQPTypeDecoder.isULong(code)) {
            long type = ((AMQPUnsignedLong)descriptor).getValue();
            if (type == Source.DESCRIPTOR_CODE) {
                return new Source((List)((AMQPList)bare).getValue());
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        if (AMQPTypeDecoder.isSymbol(code)) {
            String type = ((AMQPSymbol)descriptor).getValue();
            if (type.equals(Source.DESCRIPTOR_NAME)) {
                return new Source((List)((AMQPList)bare).getValue());
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        throw new Exception("Invalid type of constructor descriptor (actual type=" + code + ", expected=symbold or ulong), bare= " + bare);
    }

    public static SourceIF[] toNativeArray(AMQPArray array) throws Exception {
        if (array == null) {
            return null;
        }
        AMQPType[] value = array.getValue();
        if (value == null) {
            return null;
        }
        SourceIF[] n = new SourceIF[value.length];
        for (int i = 0; i < value.length; ++i) {
            n[i] = SourceFactory.create(value[i]);
        }
        return n;
    }
}

