/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.messaging.addressing;

import com.swiftmq.amqp.v100.generated.messaging.addressing.Target;
import com.swiftmq.amqp.v100.generated.messaging.addressing.TargetIF;
import com.swiftmq.amqp.v100.generated.transactions.coordination.Coordinator;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.IOException;
import java.util.List;

public class TargetFactory {
    public static TargetIF create(AMQPType bare) throws Exception {
        if (bare.getCode() == 64) {
            return null;
        }
        AMQPDescribedConstructor constructor = bare.getConstructor();
        if (constructor == null) {
            throw new IOException("Missing constructor: " + bare);
        }
        AMQPType descriptor = constructor.getDescriptor();
        int code = descriptor.getCode();
        if (AMQPTypeDecoder.isULong(code)) {
            long type = ((AMQPUnsignedLong)descriptor).getValue();
            if (type == Target.DESCRIPTOR_CODE) {
                return new Target((List)((AMQPList)bare).getValue());
            }
            if (type == Coordinator.DESCRIPTOR_CODE) {
                return new Coordinator((List)((AMQPList)bare).getValue());
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        if (AMQPTypeDecoder.isSymbol(code)) {
            String type = ((AMQPSymbol)descriptor).getValue();
            if (type.equals(Target.DESCRIPTOR_NAME)) {
                return new Target((List)((AMQPList)bare).getValue());
            }
            if (type.equals(Coordinator.DESCRIPTOR_NAME)) {
                return new Coordinator((List)((AMQPList)bare).getValue());
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        throw new Exception("Invalid type of constructor descriptor (actual type=" + code + ", expected=symbold or ulong), bare= " + bare);
    }

    public static TargetIF[] toNativeArray(AMQPArray array) throws Exception {
        if (array == null) {
            return null;
        }
        AMQPType[] value = array.getValue();
        if (value == null) {
            return null;
        }
        TargetIF[] n = new TargetIF[value.length];
        for (int i = 0; i < value.length; ++i) {
            n[i] = TargetFactory.create(value[i]);
        }
        return n;
    }
}

