/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.messaging.delivery_state;

import com.swiftmq.amqp.v100.generated.messaging.delivery_state.Accepted;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateIF;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.Modified;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.Received;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.Rejected;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.Released;
import com.swiftmq.amqp.v100.generated.transactions.coordination.Declared;
import com.swiftmq.amqp.v100.generated.transactions.coordination.TransactionalState;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.IOException;
import java.util.List;

public class DeliveryStateFactory {
    public static DeliveryStateIF create(AMQPType bare) throws Exception {
        if (bare.getCode() == 64) {
            return null;
        }
        AMQPDescribedConstructor constructor = bare.getConstructor();
        if (constructor == null) {
            throw new IOException("Missing constructor: " + bare);
        }
        AMQPType descriptor = constructor.getDescriptor();
        int code = descriptor.getCode();
        if (AMQPTypeDecoder.isULong(code)) {
            long type = ((AMQPUnsignedLong)descriptor).getValue();
            if (type == Received.DESCRIPTOR_CODE) {
                return new Received((List)((AMQPList)bare).getValue());
            }
            if (type == Accepted.DESCRIPTOR_CODE) {
                return new Accepted((List)((AMQPList)bare).getValue());
            }
            if (type == Rejected.DESCRIPTOR_CODE) {
                return new Rejected((List)((AMQPList)bare).getValue());
            }
            if (type == Released.DESCRIPTOR_CODE) {
                return new Released((List)((AMQPList)bare).getValue());
            }
            if (type == Modified.DESCRIPTOR_CODE) {
                return new Modified((List)((AMQPList)bare).getValue());
            }
            if (type == Declared.DESCRIPTOR_CODE) {
                return new Declared((List)((AMQPList)bare).getValue());
            }
            if (type == TransactionalState.DESCRIPTOR_CODE) {
                return new TransactionalState((List)((AMQPList)bare).getValue());
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        if (AMQPTypeDecoder.isSymbol(code)) {
            String type = ((AMQPSymbol)descriptor).getValue();
            if (type.equals(Received.DESCRIPTOR_NAME)) {
                return new Received((List)((AMQPList)bare).getValue());
            }
            if (type.equals(Accepted.DESCRIPTOR_NAME)) {
                return new Accepted((List)((AMQPList)bare).getValue());
            }
            if (type.equals(Rejected.DESCRIPTOR_NAME)) {
                return new Rejected((List)((AMQPList)bare).getValue());
            }
            if (type.equals(Released.DESCRIPTOR_NAME)) {
                return new Released((List)((AMQPList)bare).getValue());
            }
            if (type.equals(Modified.DESCRIPTOR_NAME)) {
                return new Modified((List)((AMQPList)bare).getValue());
            }
            if (type.equals(Declared.DESCRIPTOR_NAME)) {
                return new Declared((List)((AMQPList)bare).getValue());
            }
            if (type.equals(TransactionalState.DESCRIPTOR_NAME)) {
                return new TransactionalState((List)((AMQPList)bare).getValue());
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        throw new Exception("Invalid type of constructor descriptor (actual type=" + code + ", expected=symbold or ulong), bare= " + bare);
    }

    public static DeliveryStateIF[] toNativeArray(AMQPArray array) throws Exception {
        if (array == null) {
            return null;
        }
        AMQPType[] value = array.getValue();
        if (value == null) {
            return null;
        }
        DeliveryStateIF[] n = new DeliveryStateIF[value.length];
        for (int i = 0; i < value.length; ++i) {
            n[i] = DeliveryStateFactory.create(value[i]);
        }
        return n;
    }
}

