/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.messaging.delivery_state;

import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateIF;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateVisitor;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class Received
extends AMQPList
implements DeliveryStateIF {
    public static String DESCRIPTOR_NAME = "amqp:received:list";
    public static long DESCRIPTOR_CODE = 35L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    boolean dirty = false;
    AMQPUnsignedInt sectionNumber = null;
    AMQPUnsignedLong sectionOffset = null;

    public Received(List initValue) throws Exception {
        super(initValue);
        if (initValue != null) {
            this.decode();
        }
    }

    public Received() {
        this.dirty = true;
    }

    @Override
    public boolean hasDescriptor() {
        return true;
    }

    @Override
    public void accept(DeliveryStateVisitor visitor) {
        visitor.visit(this);
    }

    public AMQPUnsignedInt getSectionNumber() {
        return this.sectionNumber;
    }

    public void setSectionNumber(AMQPUnsignedInt sectionNumber) {
        this.dirty = true;
        this.sectionNumber = sectionNumber;
    }

    public AMQPUnsignedLong getSectionOffset() {
        return this.sectionOffset;
    }

    public void setSectionOffset(AMQPUnsignedLong sectionOffset) {
        this.dirty = true;
        this.sectionOffset = sectionOffset;
    }

    @Override
    public int getPredictedSize() {
        int n;
        if (this.dirty) {
            AMQPDescribedConstructor _c = this.getConstructor();
            this.setConstructor(null);
            n = super.getPredictedSize();
            n += this.codeConstructor.getPredictedSize();
            n += this.sectionNumber != null ? this.sectionNumber.getPredictedSize() : 1;
            n += this.sectionOffset != null ? this.sectionOffset.getPredictedSize() : 1;
            this.setConstructor(_c);
        } else {
            n = super.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'sectionNumber' in 'Received' type is NULL");
        }
        try {
            this.sectionNumber = (AMQPUnsignedInt)t;
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'sectionNumber' in 'Received' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'sectionOffset' in 'Received' type is NULL");
        }
        try {
            this.sectionOffset = (AMQPUnsignedLong)t;
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'sectionOffset' in 'Received' type: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.sectionNumber);
        this.addToList(l, this.sectionOffset);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.setValue(l);
        this.dirty = false;
    }

    public AMQPDescribedConstructor getArrayConstructor() throws IOException {
        if (this.dirty) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.getCode());
        return this.codeConstructor;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        if (this.dirty) {
            this.encode();
        }
        if (this.getConstructor() != this.codeConstructor) {
            this.codeConstructor.setFormatCode(this.getCode());
            this.setConstructor(this.codeConstructor);
        }
        super.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[Received ");
        b.append(this.getDisplayString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.sectionNumber != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("sectionNumber=");
            b.append(this.sectionNumber.getValueString());
        }
        if (this.sectionOffset != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("sectionOffset=");
            b.append(this.sectionOffset.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[Received " + this.getDisplayString() + "]";
    }
}

