/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.messaging.message_format;

import com.swiftmq.amqp.v100.generated.messaging.message_format.SectionIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.SectionVisitor;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AmqpValue
extends AMQPType
implements SectionIF {
    public static String DESCRIPTOR_NAME = "amqp:amqp-value:*";
    public static long DESCRIPTOR_CODE = 119L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    AMQPType value = null;

    public AmqpValue(AMQPType initValue) {
        super("*", 255);
        this.value = initValue;
    }

    public AMQPType getValue() {
        return this.value;
    }

    @Override
    public void accept(SectionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean hasDescriptor() {
        return true;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        this.codeConstructor.setFormatCode(255);
        this.codeConstructor.writeContent(out);
        this.value.writeContent(out);
    }

    @Override
    public int getPredictedSize() {
        int n = this.value.getPredictedSize();
        if (this.getConstructor() == null) {
            n += this.codeConstructor.getPredictedSize();
        }
        return n;
    }

    @Override
    public void readContent(DataInput in) throws IOException {
        throw new IOException("Invalid operation, readContent not implemented!");
    }

    @Override
    public String getValueString() {
        StringBuffer b = new StringBuffer("[AmqpValue ");
        b.append(this.value.getValueString());
        b.append("]");
        return b.toString();
    }

    @Override
    public String toString() {
        return "[AmqpValue " + this.value.toString() + "]";
    }
}

