/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.messaging.message_format;

import com.swiftmq.amqp.v100.generated.messaging.message_format.SectionIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.SectionVisitor;
import com.swiftmq.amqp.v100.generated.transport.definitions.Milliseconds;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedByte;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class Header
extends AMQPList
implements SectionIF {
    public static String DESCRIPTOR_NAME = "amqp:header:list";
    public static long DESCRIPTOR_CODE = 112L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    boolean dirty = false;
    AMQPBoolean durable = AMQPBoolean.FALSE;
    AMQPUnsignedByte priority = new AMQPUnsignedByte(4);
    Milliseconds ttl = null;
    AMQPBoolean firstAcquirer = AMQPBoolean.FALSE;
    AMQPUnsignedInt deliveryCount = new AMQPUnsignedInt(0L);

    public Header(List initValue) throws Exception {
        super(initValue);
        if (initValue != null) {
            this.decode();
        }
    }

    public Header() {
        this.dirty = true;
    }

    @Override
    public boolean hasDescriptor() {
        return true;
    }

    @Override
    public void accept(SectionVisitor visitor) {
        visitor.visit(this);
    }

    public AMQPBoolean getDurable() {
        return this.durable;
    }

    public void setDurable(AMQPBoolean durable) {
        this.dirty = true;
        this.durable = durable;
    }

    public AMQPUnsignedByte getPriority() {
        return this.priority;
    }

    public void setPriority(AMQPUnsignedByte priority) {
        this.dirty = true;
        this.priority = priority;
    }

    public Milliseconds getTtl() {
        return this.ttl;
    }

    public void setTtl(Milliseconds ttl) {
        this.dirty = true;
        this.ttl = ttl;
    }

    public AMQPBoolean getFirstAcquirer() {
        return this.firstAcquirer;
    }

    public void setFirstAcquirer(AMQPBoolean firstAcquirer) {
        this.dirty = true;
        this.firstAcquirer = firstAcquirer;
    }

    public AMQPUnsignedInt getDeliveryCount() {
        return this.deliveryCount;
    }

    public void setDeliveryCount(AMQPUnsignedInt deliveryCount) {
        this.dirty = true;
        this.deliveryCount = deliveryCount;
    }

    @Override
    public int getPredictedSize() {
        int n;
        if (this.dirty) {
            AMQPDescribedConstructor _c = this.getConstructor();
            this.setConstructor(null);
            n = super.getPredictedSize();
            n += this.codeConstructor.getPredictedSize();
            n += this.durable != null ? this.durable.getPredictedSize() : 1;
            n += this.priority != null ? this.priority.getPredictedSize() : 1;
            n += this.ttl != null ? this.ttl.getPredictedSize() : 1;
            n += this.firstAcquirer != null ? this.firstAcquirer.getPredictedSize() : 1;
            n += this.deliveryCount != null ? this.deliveryCount.getPredictedSize() : 1;
            this.setConstructor(_c);
        } else {
            n = super.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.durable = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'durable' in 'Header' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.priority = (AMQPUnsignedByte)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'priority' in 'Header' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.ttl = new Milliseconds(((AMQPUnsignedInt)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'ttl' in 'Header' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.firstAcquirer = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'firstAcquirer' in 'Header' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.deliveryCount = (AMQPUnsignedInt)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'deliveryCount' in 'Header' type: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.durable);
        this.addToList(l, this.priority);
        this.addToList(l, this.ttl);
        this.addToList(l, this.firstAcquirer);
        this.addToList(l, this.deliveryCount);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.setValue(l);
        this.dirty = false;
    }

    public AMQPDescribedConstructor getArrayConstructor() throws IOException {
        if (this.dirty) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.getCode());
        return this.codeConstructor;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        if (this.dirty) {
            this.encode();
        }
        if (this.getConstructor() != this.codeConstructor) {
            this.codeConstructor.setFormatCode(this.getCode());
            this.setConstructor(this.codeConstructor);
        }
        super.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[Header ");
        b.append(this.getDisplayString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.durable != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("durable=");
            b.append(this.durable.getValueString());
        }
        if (this.priority != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("priority=");
            b.append(this.priority.getValueString());
        }
        if (this.ttl != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("ttl=");
            b.append(this.ttl.getValueString());
        }
        if (this.firstAcquirer != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("firstAcquirer=");
            b.append(this.firstAcquirer.getValueString());
        }
        if (this.deliveryCount != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("deliveryCount=");
            b.append(this.deliveryCount.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[Header " + this.getDisplayString() + "]";
    }
}

