/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.messaging.message_format;

import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdBinary;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdString;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdUlong;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdUuid;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBinary;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import com.swiftmq.amqp.v100.types.AMQPUuid;

public class MessageIdFactory {
    public static MessageIdIF create(AMQPType bare) throws Exception {
        if (bare.getCode() == 64) {
            return null;
        }
        int type = bare.getCode();
        if (AMQPTypeDecoder.isULong(type)) {
            return new MessageIdUlong(((AMQPUnsignedLong)bare).getValue());
        }
        if (type == 152) {
            return new MessageIdUuid(((AMQPUuid)bare).getValue());
        }
        if (AMQPTypeDecoder.isBinary(type)) {
            return new MessageIdBinary(((AMQPBinary)bare).getValue());
        }
        if (AMQPTypeDecoder.isString(type)) {
            return new MessageIdString(((AMQPString)bare).getValue());
        }
        throw new Exception("Invalid type: " + type + ", bare=" + bare);
    }

    public static MessageIdIF[] toNativeArray(AMQPArray array) throws Exception {
        if (array == null) {
            return null;
        }
        AMQPType[] value = array.getValue();
        if (value == null) {
            return null;
        }
        MessageIdIF[] n = new MessageIdIF[value.length];
        for (int i = 0; i < value.length; ++i) {
            n[i] = MessageIdFactory.create(value[i]);
        }
        return n;
    }
}

