/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.messaging.message_format;

import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressFactory;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdFactory;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.SectionIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.SectionVisitor;
import com.swiftmq.amqp.v100.generated.transport.definitions.SequenceNo;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBinary;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPTimestamp;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class Properties
extends AMQPList
implements SectionIF {
    public static String DESCRIPTOR_NAME = "amqp:properties:list";
    public static long DESCRIPTOR_CODE = 115L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    boolean dirty = false;
    MessageIdIF messageId = null;
    AMQPBinary userId = null;
    AddressIF to = null;
    AMQPString subject = null;
    AddressIF replyTo = null;
    MessageIdIF correlationId = null;
    AMQPSymbol contentType = null;
    AMQPSymbol contentEncoding = null;
    AMQPTimestamp absoluteExpiryTime = null;
    AMQPTimestamp creationTime = null;
    AMQPString groupId = null;
    SequenceNo groupSequence = null;
    AMQPString replyToGroupId = null;

    public Properties(List initValue) throws Exception {
        super(initValue);
        if (initValue != null) {
            this.decode();
        }
    }

    public Properties() {
        this.dirty = true;
    }

    @Override
    public boolean hasDescriptor() {
        return true;
    }

    @Override
    public void accept(SectionVisitor visitor) {
        visitor.visit(this);
    }

    public MessageIdIF getMessageId() {
        return this.messageId;
    }

    public void setMessageId(MessageIdIF messageId) {
        this.dirty = true;
        this.messageId = messageId;
    }

    public AMQPBinary getUserId() {
        return this.userId;
    }

    public void setUserId(AMQPBinary userId) {
        this.dirty = true;
        this.userId = userId;
    }

    public AddressIF getTo() {
        return this.to;
    }

    public void setTo(AddressIF to) {
        this.dirty = true;
        this.to = to;
    }

    public AMQPString getSubject() {
        return this.subject;
    }

    public void setSubject(AMQPString subject) {
        this.dirty = true;
        this.subject = subject;
    }

    public AddressIF getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(AddressIF replyTo) {
        this.dirty = true;
        this.replyTo = replyTo;
    }

    public MessageIdIF getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(MessageIdIF correlationId) {
        this.dirty = true;
        this.correlationId = correlationId;
    }

    public AMQPSymbol getContentType() {
        return this.contentType;
    }

    public void setContentType(AMQPSymbol contentType) {
        this.dirty = true;
        this.contentType = contentType;
    }

    public AMQPSymbol getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(AMQPSymbol contentEncoding) {
        this.dirty = true;
        this.contentEncoding = contentEncoding;
    }

    public AMQPTimestamp getAbsoluteExpiryTime() {
        return this.absoluteExpiryTime;
    }

    public void setAbsoluteExpiryTime(AMQPTimestamp absoluteExpiryTime) {
        this.dirty = true;
        this.absoluteExpiryTime = absoluteExpiryTime;
    }

    public AMQPTimestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(AMQPTimestamp creationTime) {
        this.dirty = true;
        this.creationTime = creationTime;
    }

    public AMQPString getGroupId() {
        return this.groupId;
    }

    public void setGroupId(AMQPString groupId) {
        this.dirty = true;
        this.groupId = groupId;
    }

    public SequenceNo getGroupSequence() {
        return this.groupSequence;
    }

    public void setGroupSequence(SequenceNo groupSequence) {
        this.dirty = true;
        this.groupSequence = groupSequence;
    }

    public AMQPString getReplyToGroupId() {
        return this.replyToGroupId;
    }

    public void setReplyToGroupId(AMQPString replyToGroupId) {
        this.dirty = true;
        this.replyToGroupId = replyToGroupId;
    }

    @Override
    public int getPredictedSize() {
        int n;
        if (this.dirty) {
            AMQPDescribedConstructor _c = this.getConstructor();
            this.setConstructor(null);
            n = super.getPredictedSize();
            n += this.codeConstructor.getPredictedSize();
            n += this.messageId != null ? this.messageId.getPredictedSize() : 1;
            n += this.userId != null ? this.userId.getPredictedSize() : 1;
            n += this.to != null ? this.to.getPredictedSize() : 1;
            n += this.subject != null ? this.subject.getPredictedSize() : 1;
            n += this.replyTo != null ? this.replyTo.getPredictedSize() : 1;
            n += this.correlationId != null ? this.correlationId.getPredictedSize() : 1;
            n += this.contentType != null ? this.contentType.getPredictedSize() : 1;
            n += this.contentEncoding != null ? this.contentEncoding.getPredictedSize() : 1;
            n += this.absoluteExpiryTime != null ? this.absoluteExpiryTime.getPredictedSize() : 1;
            n += this.creationTime != null ? this.creationTime.getPredictedSize() : 1;
            n += this.groupId != null ? this.groupId.getPredictedSize() : 1;
            n += this.groupSequence != null ? this.groupSequence.getPredictedSize() : 1;
            n += this.replyToGroupId != null ? this.replyToGroupId.getPredictedSize() : 1;
            this.setConstructor(_c);
        } else {
            n = super.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() != 64) {
            this.messageId = MessageIdFactory.create(t);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.userId = (AMQPBinary)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'userId' in 'Properties' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() != 64) {
            this.to = AddressFactory.create(t);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.subject = (AMQPString)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'subject' in 'Properties' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() != 64) {
            this.replyTo = AddressFactory.create(t);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() != 64) {
            this.correlationId = MessageIdFactory.create(t);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.contentType = (AMQPSymbol)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'contentType' in 'Properties' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.contentEncoding = (AMQPSymbol)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'contentEncoding' in 'Properties' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.absoluteExpiryTime = (AMQPTimestamp)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'absoluteExpiryTime' in 'Properties' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.creationTime = (AMQPTimestamp)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'creationTime' in 'Properties' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.groupId = (AMQPString)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'groupId' in 'Properties' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.groupSequence = new SequenceNo(((AMQPUnsignedInt)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'groupSequence' in 'Properties' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.replyToGroupId = (AMQPString)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'replyToGroupId' in 'Properties' type: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.messageId);
        this.addToList(l, this.userId);
        this.addToList(l, this.to);
        this.addToList(l, this.subject);
        this.addToList(l, this.replyTo);
        this.addToList(l, this.correlationId);
        this.addToList(l, this.contentType);
        this.addToList(l, this.contentEncoding);
        this.addToList(l, this.absoluteExpiryTime);
        this.addToList(l, this.creationTime);
        this.addToList(l, this.groupId);
        this.addToList(l, this.groupSequence);
        this.addToList(l, this.replyToGroupId);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.setValue(l);
        this.dirty = false;
    }

    public AMQPDescribedConstructor getArrayConstructor() throws IOException {
        if (this.dirty) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.getCode());
        return this.codeConstructor;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        if (this.dirty) {
            this.encode();
        }
        if (this.getConstructor() != this.codeConstructor) {
            this.codeConstructor.setFormatCode(this.getCode());
            this.setConstructor(this.codeConstructor);
        }
        super.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[Properties ");
        b.append(this.getDisplayString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.messageId != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("messageId=");
            b.append(this.messageId.getValueString());
        }
        if (this.userId != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("userId=");
            b.append(this.userId.getValueString());
        }
        if (this.to != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("to=");
            b.append(this.to.getValueString());
        }
        if (this.subject != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("subject=");
            b.append(this.subject.getValueString());
        }
        if (this.replyTo != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("replyTo=");
            b.append(this.replyTo.getValueString());
        }
        if (this.correlationId != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("correlationId=");
            b.append(this.correlationId.getValueString());
        }
        if (this.contentType != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("contentType=");
            b.append(this.contentType.getValueString());
        }
        if (this.contentEncoding != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("contentEncoding=");
            b.append(this.contentEncoding.getValueString());
        }
        if (this.absoluteExpiryTime != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("absoluteExpiryTime=");
            b.append(this.absoluteExpiryTime.getValueString());
        }
        if (this.creationTime != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("creationTime=");
            b.append(this.creationTime.getValueString());
        }
        if (this.groupId != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("groupId=");
            b.append(this.groupId.getValueString());
        }
        if (this.groupSequence != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("groupSequence=");
            b.append(this.groupSequence.getValueString());
        }
        if (this.replyToGroupId != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("replyToGroupId=");
            b.append(this.replyToGroupId.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[Properties " + this.getDisplayString() + "]";
    }
}

