/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.messaging.message_format;

import com.swiftmq.amqp.v100.generated.messaging.message_format.AmqpSequence;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AmqpValue;
import com.swiftmq.amqp.v100.generated.messaging.message_format.ApplicationProperties;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Data;
import com.swiftmq.amqp.v100.generated.messaging.message_format.DeliveryAnnotations;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Footer;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Header;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageAnnotations;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Properties;
import com.swiftmq.amqp.v100.generated.messaging.message_format.SectionIF;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBinary;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPMap;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class SectionFactory {
    public static SectionIF create(AMQPType bare) throws Exception {
        if (bare.getCode() == 64) {
            return null;
        }
        AMQPDescribedConstructor constructor = bare.getConstructor();
        if (constructor == null) {
            throw new IOException("Missing constructor: " + bare);
        }
        AMQPType descriptor = constructor.getDescriptor();
        int code = descriptor.getCode();
        if (AMQPTypeDecoder.isULong(code)) {
            long type = ((AMQPUnsignedLong)descriptor).getValue();
            if (type == Header.DESCRIPTOR_CODE) {
                return new Header((List)((AMQPList)bare).getValue());
            }
            if (type == DeliveryAnnotations.DESCRIPTOR_CODE) {
                return new DeliveryAnnotations((Map)((AMQPMap)bare).getValue());
            }
            if (type == MessageAnnotations.DESCRIPTOR_CODE) {
                return new MessageAnnotations((Map)((AMQPMap)bare).getValue());
            }
            if (type == Properties.DESCRIPTOR_CODE) {
                return new Properties((List)((AMQPList)bare).getValue());
            }
            if (type == ApplicationProperties.DESCRIPTOR_CODE) {
                return new ApplicationProperties((Map)((AMQPMap)bare).getValue());
            }
            if (type == Data.DESCRIPTOR_CODE) {
                return new Data(((AMQPBinary)bare).getValue());
            }
            if (type == AmqpSequence.DESCRIPTOR_CODE) {
                return new AmqpSequence((List)((AMQPList)bare).getValue());
            }
            if (type == AmqpValue.DESCRIPTOR_CODE) {
                return new AmqpValue(bare);
            }
            if (type == Footer.DESCRIPTOR_CODE) {
                return new Footer((Map)((AMQPMap)bare).getValue());
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        if (AMQPTypeDecoder.isSymbol(code)) {
            String type = ((AMQPSymbol)descriptor).getValue();
            if (type.equals(Header.DESCRIPTOR_NAME)) {
                return new Header((List)((AMQPList)bare).getValue());
            }
            if (type.equals(DeliveryAnnotations.DESCRIPTOR_NAME)) {
                return new DeliveryAnnotations((Map)((AMQPMap)bare).getValue());
            }
            if (type.equals(MessageAnnotations.DESCRIPTOR_NAME)) {
                return new MessageAnnotations((Map)((AMQPMap)bare).getValue());
            }
            if (type.equals(Properties.DESCRIPTOR_NAME)) {
                return new Properties((List)((AMQPList)bare).getValue());
            }
            if (type.equals(ApplicationProperties.DESCRIPTOR_NAME)) {
                return new ApplicationProperties((Map)((AMQPMap)bare).getValue());
            }
            if (type.equals(Data.DESCRIPTOR_NAME)) {
                return new Data(((AMQPBinary)bare).getValue());
            }
            if (type.equals(AmqpSequence.DESCRIPTOR_NAME)) {
                return new AmqpSequence((List)((AMQPList)bare).getValue());
            }
            if (type.equals(AmqpValue.DESCRIPTOR_NAME)) {
                return new AmqpValue(bare);
            }
            if (type.equals(Footer.DESCRIPTOR_NAME)) {
                return new Footer((Map)((AMQPMap)bare).getValue());
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        throw new Exception("Invalid type of constructor descriptor (actual type=" + code + ", expected=symbold or ulong), bare= " + bare);
    }

    public static SectionIF[] toNativeArray(AMQPArray array) throws Exception {
        if (array == null) {
            return null;
        }
        AMQPType[] value = array.getValue();
        if (value == null) {
            return null;
        }
        SectionIF[] n = new SectionIF[value.length];
        for (int i = 0; i < value.length; ++i) {
            n[i] = SectionFactory.create(value[i]);
        }
        return n;
    }
}

