/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.security.sasl;

import com.swiftmq.amqp.v100.generated.security.sasl.SaslChallengeFrame;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslFrameIF;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslInitFrame;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslMechanismsFrame;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslOutcomeFrame;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslResponseFrame;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.IOException;

public class SaslFrameFactory {
    public static SaslFrameIF create(int channel, AMQPType bare) throws Exception {
        if (bare.getCode() == 64) {
            return null;
        }
        AMQPDescribedConstructor constructor = bare.getConstructor();
        if (constructor == null) {
            throw new IOException("Missing constructor: " + bare);
        }
        AMQPType descriptor = constructor.getDescriptor();
        int code = descriptor.getCode();
        if (AMQPTypeDecoder.isULong(code)) {
            long type = ((AMQPUnsignedLong)descriptor).getValue();
            if (type == SaslMechanismsFrame.DESCRIPTOR_CODE) {
                return new SaslMechanismsFrame(channel, (AMQPList)bare);
            }
            if (type == SaslInitFrame.DESCRIPTOR_CODE) {
                return new SaslInitFrame(channel, (AMQPList)bare);
            }
            if (type == SaslChallengeFrame.DESCRIPTOR_CODE) {
                return new SaslChallengeFrame(channel, (AMQPList)bare);
            }
            if (type == SaslResponseFrame.DESCRIPTOR_CODE) {
                return new SaslResponseFrame(channel, (AMQPList)bare);
            }
            if (type == SaslOutcomeFrame.DESCRIPTOR_CODE) {
                return new SaslOutcomeFrame(channel, (AMQPList)bare);
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        if (AMQPTypeDecoder.isSymbol(code)) {
            String type = ((AMQPSymbol)descriptor).getValue();
            if (type.equals(SaslMechanismsFrame.DESCRIPTOR_NAME)) {
                return new SaslMechanismsFrame(channel, (AMQPList)bare);
            }
            if (type.equals(SaslInitFrame.DESCRIPTOR_NAME)) {
                return new SaslInitFrame(channel, (AMQPList)bare);
            }
            if (type.equals(SaslChallengeFrame.DESCRIPTOR_NAME)) {
                return new SaslChallengeFrame(channel, (AMQPList)bare);
            }
            if (type.equals(SaslResponseFrame.DESCRIPTOR_NAME)) {
                return new SaslResponseFrame(channel, (AMQPList)bare);
            }
            if (type.equals(SaslOutcomeFrame.DESCRIPTOR_NAME)) {
                return new SaslOutcomeFrame(channel, (AMQPList)bare);
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        throw new Exception("Invalid type of constructor descriptor (actual type=" + code + ", expected=symbold or ulong), bare= " + bare);
    }
}

