/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.security.sasl;

import com.swiftmq.amqp.v100.generated.security.sasl.SaslFrameIF;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslFrameVisitor;
import com.swiftmq.amqp.v100.transport.AMQPFrame;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBinary;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class SaslInitFrame
extends AMQPFrame
implements SaslFrameIF {
    public static String DESCRIPTOR_NAME = "amqp:sasl-init:list";
    public static long DESCRIPTOR_CODE = 65L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    AMQPList body = null;
    boolean dirty = false;
    AMQPSymbol mechanism = null;
    AMQPBinary initialResponse = null;
    AMQPString hostname = null;

    public SaslInitFrame(int channel, AMQPList body) throws Exception {
        super(channel);
        this.setTypeCode(TYPE_CODE_SASL_FRAME);
        this.body = body;
        if (body != null) {
            this.decode();
        }
    }

    public SaslInitFrame(int channel) {
        super(channel);
        this.setTypeCode(TYPE_CODE_SASL_FRAME);
    }

    @Override
    public void accept(SaslFrameVisitor visitor) {
        visitor.visit(this);
    }

    public AMQPSymbol getMechanism() {
        return this.mechanism;
    }

    public void setMechanism(AMQPSymbol mechanism) {
        this.dirty = true;
        this.mechanism = mechanism;
    }

    public AMQPBinary getInitialResponse() {
        return this.initialResponse;
    }

    public void setInitialResponse(AMQPBinary initialResponse) {
        this.dirty = true;
        this.initialResponse = initialResponse;
    }

    public AMQPString getHostname() {
        return this.hostname;
    }

    public void setHostname(AMQPString hostname) {
        this.dirty = true;
        this.hostname = hostname;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.body == null) {
            n += 4;
            n += this.codeConstructor.getPredictedSize();
            n += this.mechanism != null ? this.mechanism.getPredictedSize() : 1;
            n += this.initialResponse != null ? this.initialResponse.getPredictedSize() : 1;
            n += this.hostname != null ? this.hostname.getPredictedSize() : 1;
        } else {
            n += this.body.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.body.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'mechanism' in 'SaslInit' frame is NULL");
        }
        try {
            this.mechanism = (AMQPSymbol)t;
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'mechanism' in 'SaslInit' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.initialResponse = (AMQPBinary)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'initialResponse' in 'SaslInit' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.hostname = (AMQPString)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'hostname' in 'SaslInit' frame: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.mechanism);
        this.addToList(l, this.initialResponse);
        this.addToList(l, this.hostname);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.body = new AMQPList(l);
        this.dirty = false;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.dirty || this.body == null) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.body.getCode());
        this.body.setConstructor(this.codeConstructor);
        this.body.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty || this.body == null) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[SaslInit ");
        b.append(super.getValueString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.mechanism != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("mechanism=");
            b.append(this.mechanism.getValueString());
        }
        if (this.initialResponse != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("initialResponse=");
            b.append(this.initialResponse.getValueString());
        }
        if (this.hostname != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("hostname=");
            b.append(this.hostname.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[SaslInit " + this.getDisplayString() + "]";
    }
}

