/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.security.sasl;

import com.swiftmq.amqp.v100.generated.security.sasl.SaslFrameIF;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslFrameVisitor;
import com.swiftmq.amqp.v100.transport.AMQPFrame;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class SaslMechanismsFrame
extends AMQPFrame
implements SaslFrameIF {
    public static String DESCRIPTOR_NAME = "amqp:sasl-mechanisms:list";
    public static long DESCRIPTOR_CODE = 64L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    AMQPList body = null;
    boolean dirty = false;
    AMQPArray saslServerMechanisms = null;

    public SaslMechanismsFrame(int channel, AMQPList body) throws Exception {
        super(channel);
        this.setTypeCode(TYPE_CODE_SASL_FRAME);
        this.body = body;
        if (body != null) {
            this.decode();
        }
    }

    public SaslMechanismsFrame(int channel) {
        super(channel);
        this.setTypeCode(TYPE_CODE_SASL_FRAME);
    }

    @Override
    public void accept(SaslFrameVisitor visitor) {
        visitor.visit(this);
    }

    public AMQPArray getSaslServerMechanisms() {
        return this.saslServerMechanisms;
    }

    public void setSaslServerMechanisms(AMQPArray saslServerMechanisms) {
        this.dirty = true;
        this.saslServerMechanisms = saslServerMechanisms;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.body == null) {
            n += 4;
            n += this.codeConstructor.getPredictedSize();
            n += this.saslServerMechanisms != null ? this.saslServerMechanisms.getPredictedSize() : 1;
        } else {
            n += this.body.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.body.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'saslServerMechanisms' in 'SaslMechanisms' frame is NULL");
        }
        try {
            this.saslServerMechanisms = AMQPTypeDecoder.isArray(t.getCode()) ? (AMQPArray)t : this.singleToArray(t);
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'saslServerMechanisms' in 'SaslMechanisms' frame: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.saslServerMechanisms);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.body = new AMQPList(l);
        this.dirty = false;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.dirty || this.body == null) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.body.getCode());
        this.body.setConstructor(this.codeConstructor);
        this.body.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty || this.body == null) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[SaslMechanisms ");
        b.append(super.getValueString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.saslServerMechanisms != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("saslServerMechanisms=");
            b.append(this.saslServerMechanisms.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[SaslMechanisms " + this.getDisplayString() + "]";
    }
}

