/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.security.sasl;

import com.swiftmq.amqp.v100.generated.security.sasl.SaslCode;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslFrameIF;
import com.swiftmq.amqp.v100.generated.security.sasl.SaslFrameVisitor;
import com.swiftmq.amqp.v100.transport.AMQPFrame;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBinary;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedByte;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class SaslOutcomeFrame
extends AMQPFrame
implements SaslFrameIF {
    public static String DESCRIPTOR_NAME = "amqp:sasl-outcome:list";
    public static long DESCRIPTOR_CODE = 68L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    AMQPList body = null;
    boolean dirty = false;
    SaslCode mycode = null;
    AMQPBinary additionalData = null;

    public SaslOutcomeFrame(int channel, AMQPList body) throws Exception {
        super(channel);
        this.setTypeCode(TYPE_CODE_SASL_FRAME);
        this.body = body;
        if (body != null) {
            this.decode();
        }
    }

    public SaslOutcomeFrame(int channel) {
        super(channel);
        this.setTypeCode(TYPE_CODE_SASL_FRAME);
    }

    @Override
    public void accept(SaslFrameVisitor visitor) {
        visitor.visit(this);
    }

    public SaslCode getMycode() {
        return this.mycode;
    }

    public void setMycode(SaslCode mycode) {
        this.dirty = true;
        this.mycode = mycode;
    }

    public AMQPBinary getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(AMQPBinary additionalData) {
        this.dirty = true;
        this.additionalData = additionalData;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.body == null) {
            n += 4;
            n += this.codeConstructor.getPredictedSize();
            n += this.mycode != null ? this.mycode.getPredictedSize() : 1;
            n += this.additionalData != null ? this.additionalData.getPredictedSize() : 1;
        } else {
            n += this.body.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.body.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'mycode' in 'SaslOutcome' frame is NULL");
        }
        try {
            this.mycode = new SaslCode(((AMQPUnsignedByte)t).getValue());
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'mycode' in 'SaslOutcome' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.additionalData = (AMQPBinary)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'additionalData' in 'SaslOutcome' frame: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.mycode);
        this.addToList(l, this.additionalData);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.body = new AMQPList(l);
        this.dirty = false;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.dirty || this.body == null) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.body.getCode());
        this.body.setConstructor(this.codeConstructor);
        this.body.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty || this.body == null) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[SaslOutcome ");
        b.append(super.getValueString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.mycode != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("mycode=");
            b.append(this.mycode.getValueString());
        }
        if (this.additionalData != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("additionalData=");
            b.append(this.additionalData.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[SaslOutcome " + this.getDisplayString() + "]";
    }
}

