/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.transactions.coordination;

import com.swiftmq.amqp.v100.generated.messaging.addressing.TargetIF;
import com.swiftmq.amqp.v100.generated.messaging.addressing.TargetVisitor;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class Coordinator
extends AMQPList
implements TargetIF {
    public static String DESCRIPTOR_NAME = "amqp:coordinator:list";
    public static long DESCRIPTOR_CODE = 48L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    boolean dirty = false;
    AMQPArray capabilities = null;

    public Coordinator(List initValue) throws Exception {
        super(initValue);
        if (initValue != null) {
            this.decode();
        }
    }

    public Coordinator() {
        this.dirty = true;
    }

    @Override
    public boolean hasDescriptor() {
        return true;
    }

    @Override
    public void accept(TargetVisitor visitor) {
        visitor.visit(this);
    }

    public AMQPArray getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(AMQPArray capabilities) {
        this.dirty = true;
        this.capabilities = capabilities;
    }

    @Override
    public int getPredictedSize() {
        int n;
        if (this.dirty) {
            AMQPDescribedConstructor _c = this.getConstructor();
            this.setConstructor(null);
            n = super.getPredictedSize();
            n += this.codeConstructor.getPredictedSize();
            n += this.capabilities != null ? this.capabilities.getPredictedSize() : 1;
            this.setConstructor(_c);
        } else {
            n = super.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() != 64) {
            this.capabilities = AMQPTypeDecoder.isArray(t.getCode()) ? (AMQPArray)t : this.singleToArray(t);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.capabilities);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.setValue(l);
        this.dirty = false;
    }

    public AMQPDescribedConstructor getArrayConstructor() throws IOException {
        if (this.dirty) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.getCode());
        return this.codeConstructor;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        if (this.dirty) {
            this.encode();
        }
        if (this.getConstructor() != this.codeConstructor) {
            this.codeConstructor.setFormatCode(this.getCode());
            this.setConstructor(this.codeConstructor);
        }
        super.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[Coordinator ");
        b.append(this.getDisplayString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.capabilities != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("capabilities=");
            b.append(this.capabilities.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[Coordinator " + this.getDisplayString() + "]";
    }
}

