/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.transport.definitions;

import com.swiftmq.amqp.v100.generated.transport.definitions.ErrorConditionFactory;
import com.swiftmq.amqp.v100.generated.transport.definitions.ErrorConditionIF;
import com.swiftmq.amqp.v100.generated.transport.definitions.Fields;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPMap;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Error
extends AMQPList {
    public static String DESCRIPTOR_NAME = "amqp:error:list";
    public static long DESCRIPTOR_CODE = 29L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    boolean dirty = false;
    ErrorConditionIF condition = null;
    AMQPString description = null;
    Fields info = null;

    public Error(List initValue) throws Exception {
        super(initValue);
        if (initValue != null) {
            this.decode();
        }
    }

    public Error() {
        this.dirty = true;
    }

    @Override
    public boolean hasDescriptor() {
        return true;
    }

    public ErrorConditionIF getCondition() {
        return this.condition;
    }

    public void setCondition(ErrorConditionIF condition) {
        this.dirty = true;
        this.condition = condition;
    }

    public AMQPString getDescription() {
        return this.description;
    }

    public void setDescription(AMQPString description) {
        this.dirty = true;
        this.description = description;
    }

    public Fields getInfo() {
        return this.info;
    }

    public void setInfo(Fields info) {
        this.dirty = true;
        this.info = info;
    }

    @Override
    public int getPredictedSize() {
        int n;
        if (this.dirty) {
            AMQPDescribedConstructor _c = this.getConstructor();
            this.setConstructor(null);
            n = super.getPredictedSize();
            n += this.codeConstructor.getPredictedSize();
            n += this.condition != null ? this.condition.getPredictedSize() : 1;
            n += this.description != null ? this.description.getPredictedSize() : 1;
            n += this.info != null ? this.info.getPredictedSize() : 1;
            this.setConstructor(_c);
        } else {
            n = super.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'condition' in 'Error' type is NULL");
        }
        this.condition = ErrorConditionFactory.create(t);
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.description = (AMQPString)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'description' in 'Error' type: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.info = new Fields((Map)((AMQPMap)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'info' in 'Error' type: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.condition);
        this.addToList(l, this.description);
        this.addToList(l, this.info);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.setValue(l);
        this.dirty = false;
    }

    public AMQPDescribedConstructor getArrayConstructor() throws IOException {
        if (this.dirty) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.getCode());
        return this.codeConstructor;
    }

    @Override
    public void writeContent(DataOutput out) throws IOException {
        if (this.dirty) {
            this.encode();
        }
        if (this.getConstructor() != this.codeConstructor) {
            this.codeConstructor.setFormatCode(this.getCode());
            this.setConstructor(this.codeConstructor);
        }
        super.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[Error ");
        b.append(this.getDisplayString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.condition != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("condition=");
            b.append(this.condition.getValueString());
        }
        if (this.description != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("description=");
            b.append(this.description.getValueString());
        }
        if (this.info != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("info=");
            b.append(this.info.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[Error " + this.getDisplayString() + "]";
    }
}

