/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.transport.definitions;

import com.swiftmq.amqp.v100.generated.transactions.coordination.TransactionError;
import com.swiftmq.amqp.v100.generated.transport.definitions.AmqpError;
import com.swiftmq.amqp.v100.generated.transport.definitions.ConnectionError;
import com.swiftmq.amqp.v100.generated.transport.definitions.ErrorConditionIF;
import com.swiftmq.amqp.v100.generated.transport.definitions.LinkError;
import com.swiftmq.amqp.v100.generated.transport.definitions.SessionError;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;

public class ErrorConditionFactory {
    public static ErrorConditionIF create(AMQPType bare) throws Exception {
        if (bare.getCode() == 64) {
            return null;
        }
        int type = bare.getCode();
        if (AmqpError.POSSIBLE_VALUES.contains(((AMQPSymbol)bare).getValue())) {
            return new AmqpError(((AMQPSymbol)bare).getValue());
        }
        if (ConnectionError.POSSIBLE_VALUES.contains(((AMQPSymbol)bare).getValue())) {
            return new ConnectionError(((AMQPSymbol)bare).getValue());
        }
        if (SessionError.POSSIBLE_VALUES.contains(((AMQPSymbol)bare).getValue())) {
            return new SessionError(((AMQPSymbol)bare).getValue());
        }
        if (LinkError.POSSIBLE_VALUES.contains(((AMQPSymbol)bare).getValue())) {
            return new LinkError(((AMQPSymbol)bare).getValue());
        }
        if (TransactionError.POSSIBLE_VALUES.contains(((AMQPSymbol)bare).getValue())) {
            return new TransactionError(((AMQPSymbol)bare).getValue());
        }
        throw new Exception("Invalid type: " + type + ", bare=" + bare);
    }

    public static ErrorConditionIF[] toNativeArray(AMQPArray array) throws Exception {
        if (array == null) {
            return null;
        }
        AMQPType[] value = array.getValue();
        if (value == null) {
            return null;
        }
        ErrorConditionIF[] n = new ErrorConditionIF[value.length];
        for (int i = 0; i < value.length; ++i) {
            n[i] = ErrorConditionFactory.create(value[i]);
        }
        return n;
    }
}

