/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.transport.performatives;

import com.swiftmq.amqp.v100.generated.messaging.addressing.SourceFactory;
import com.swiftmq.amqp.v100.generated.messaging.addressing.SourceIF;
import com.swiftmq.amqp.v100.generated.messaging.addressing.TargetFactory;
import com.swiftmq.amqp.v100.generated.messaging.addressing.TargetIF;
import com.swiftmq.amqp.v100.generated.transport.definitions.Fields;
import com.swiftmq.amqp.v100.generated.transport.definitions.Handle;
import com.swiftmq.amqp.v100.generated.transport.definitions.ReceiverSettleMode;
import com.swiftmq.amqp.v100.generated.transport.definitions.Role;
import com.swiftmq.amqp.v100.generated.transport.definitions.SenderSettleMode;
import com.swiftmq.amqp.v100.generated.transport.definitions.SequenceNo;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameIF;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameVisitor;
import com.swiftmq.amqp.v100.transport.AMQPFrame;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPMap;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedByte;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class AttachFrame
extends AMQPFrame
implements FrameIF {
    public static String DESCRIPTOR_NAME = "amqp:attach:list";
    public static long DESCRIPTOR_CODE = 18L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    AMQPList body = null;
    boolean dirty = false;
    AMQPString name = null;
    Handle handle = null;
    Role role = null;
    SenderSettleMode sndSettleMode = SenderSettleMode.MIXED;
    ReceiverSettleMode rcvSettleMode = ReceiverSettleMode.FIRST;
    SourceIF source = null;
    TargetIF target = null;
    AMQPMap unsettled = null;
    AMQPBoolean incompleteUnsettled = AMQPBoolean.FALSE;
    SequenceNo initialDeliveryCount = null;
    AMQPUnsignedLong maxMessageSize = null;
    AMQPArray offeredCapabilities = null;
    AMQPArray desiredCapabilities = null;
    Fields properties = null;

    public AttachFrame(int channel, AMQPList body) throws Exception {
        super(channel);
        this.body = body;
        if (body != null) {
            this.decode();
        }
    }

    public AttachFrame(int channel) {
        super(channel);
    }

    @Override
    public void accept(FrameVisitor visitor) {
        visitor.visit(this);
    }

    public AMQPString getName() {
        return this.name;
    }

    public void setName(AMQPString name) {
        this.dirty = true;
        this.name = name;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public void setHandle(Handle handle) {
        this.dirty = true;
        this.handle = handle;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.dirty = true;
        this.role = role;
    }

    public SenderSettleMode getSndSettleMode() {
        return this.sndSettleMode;
    }

    public void setSndSettleMode(SenderSettleMode sndSettleMode) {
        this.dirty = true;
        this.sndSettleMode = sndSettleMode;
    }

    public ReceiverSettleMode getRcvSettleMode() {
        return this.rcvSettleMode;
    }

    public void setRcvSettleMode(ReceiverSettleMode rcvSettleMode) {
        this.dirty = true;
        this.rcvSettleMode = rcvSettleMode;
    }

    public SourceIF getSource() {
        return this.source;
    }

    public void setSource(SourceIF source) {
        this.dirty = true;
        this.source = source;
    }

    public TargetIF getTarget() {
        return this.target;
    }

    public void setTarget(TargetIF target) {
        this.dirty = true;
        this.target = target;
    }

    public AMQPMap getUnsettled() {
        return this.unsettled;
    }

    public void setUnsettled(AMQPMap unsettled) {
        this.dirty = true;
        this.unsettled = unsettled;
    }

    public AMQPBoolean getIncompleteUnsettled() {
        return this.incompleteUnsettled;
    }

    public void setIncompleteUnsettled(AMQPBoolean incompleteUnsettled) {
        this.dirty = true;
        this.incompleteUnsettled = incompleteUnsettled;
    }

    public SequenceNo getInitialDeliveryCount() {
        return this.initialDeliveryCount;
    }

    public void setInitialDeliveryCount(SequenceNo initialDeliveryCount) {
        this.dirty = true;
        this.initialDeliveryCount = initialDeliveryCount;
    }

    public AMQPUnsignedLong getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(AMQPUnsignedLong maxMessageSize) {
        this.dirty = true;
        this.maxMessageSize = maxMessageSize;
    }

    public AMQPArray getOfferedCapabilities() {
        return this.offeredCapabilities;
    }

    public void setOfferedCapabilities(AMQPArray offeredCapabilities) {
        this.dirty = true;
        this.offeredCapabilities = offeredCapabilities;
    }

    public AMQPArray getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public void setDesiredCapabilities(AMQPArray desiredCapabilities) {
        this.dirty = true;
        this.desiredCapabilities = desiredCapabilities;
    }

    public Fields getProperties() {
        return this.properties;
    }

    public void setProperties(Fields properties) {
        this.dirty = true;
        this.properties = properties;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.body == null) {
            n += 4;
            n += this.codeConstructor.getPredictedSize();
            n += this.name != null ? this.name.getPredictedSize() : 1;
            n += this.handle != null ? this.handle.getPredictedSize() : 1;
            n += this.role != null ? this.role.getPredictedSize() : 1;
            n += this.sndSettleMode != null ? this.sndSettleMode.getPredictedSize() : 1;
            n += this.rcvSettleMode != null ? this.rcvSettleMode.getPredictedSize() : 1;
            n += this.source != null ? this.source.getPredictedSize() : 1;
            n += this.target != null ? this.target.getPredictedSize() : 1;
            n += this.unsettled != null ? this.unsettled.getPredictedSize() : 1;
            n += this.incompleteUnsettled != null ? this.incompleteUnsettled.getPredictedSize() : 1;
            n += this.initialDeliveryCount != null ? this.initialDeliveryCount.getPredictedSize() : 1;
            n += this.maxMessageSize != null ? this.maxMessageSize.getPredictedSize() : 1;
            n += this.offeredCapabilities != null ? this.offeredCapabilities.getPredictedSize() : 1;
            n += this.desiredCapabilities != null ? this.desiredCapabilities.getPredictedSize() : 1;
            n += this.properties != null ? this.properties.getPredictedSize() : 1;
        } else {
            n += this.body.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.body.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'name' in 'Attach' frame is NULL");
        }
        try {
            this.name = (AMQPString)t;
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'name' in 'Attach' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'handle' in 'Attach' frame is NULL");
        }
        try {
            this.handle = new Handle(((AMQPUnsignedInt)t).getValue());
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'handle' in 'Attach' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'role' in 'Attach' frame is NULL");
        }
        try {
            this.role = new Role(((AMQPBoolean)t).getValue());
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'role' in 'Attach' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.sndSettleMode = new SenderSettleMode(((AMQPUnsignedByte)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'sndSettleMode' in 'Attach' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.rcvSettleMode = new ReceiverSettleMode(((AMQPUnsignedByte)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'rcvSettleMode' in 'Attach' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() != 64) {
            this.source = SourceFactory.create(t);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() != 64) {
            this.target = TargetFactory.create(t);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.unsettled = (AMQPMap)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'unsettled' in 'Attach' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.incompleteUnsettled = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'incompleteUnsettled' in 'Attach' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.initialDeliveryCount = new SequenceNo(((AMQPUnsignedInt)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'initialDeliveryCount' in 'Attach' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.maxMessageSize = (AMQPUnsignedLong)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'maxMessageSize' in 'Attach' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.offeredCapabilities = AMQPTypeDecoder.isArray(t.getCode()) ? (AMQPArray)t : this.singleToArray(t);
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'offeredCapabilities' in 'Attach' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.desiredCapabilities = AMQPTypeDecoder.isArray(t.getCode()) ? (AMQPArray)t : this.singleToArray(t);
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'desiredCapabilities' in 'Attach' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.properties = new Fields((Map)((AMQPMap)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'properties' in 'Attach' frame: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.name);
        this.addToList(l, this.handle);
        this.addToList(l, this.role);
        this.addToList(l, this.sndSettleMode);
        this.addToList(l, this.rcvSettleMode);
        this.addToList(l, this.source);
        this.addToList(l, this.target);
        this.addToList(l, this.unsettled);
        this.addToList(l, this.incompleteUnsettled);
        this.addToList(l, this.initialDeliveryCount);
        this.addToList(l, this.maxMessageSize);
        this.addToList(l, this.offeredCapabilities);
        this.addToList(l, this.desiredCapabilities);
        this.addToList(l, this.properties);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.body = new AMQPList(l);
        this.dirty = false;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.dirty || this.body == null) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.body.getCode());
        this.body.setConstructor(this.codeConstructor);
        this.body.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty || this.body == null) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[Attach ");
        b.append(super.getValueString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.name != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("name=");
            b.append(this.name.getValueString());
        }
        if (this.handle != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("handle=");
            b.append(this.handle.getValueString());
        }
        if (this.role != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("role=");
            b.append(this.role.getValueString());
        }
        if (this.sndSettleMode != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("sndSettleMode=");
            b.append(this.sndSettleMode.getValueString());
        }
        if (this.rcvSettleMode != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("rcvSettleMode=");
            b.append(this.rcvSettleMode.getValueString());
        }
        if (this.source != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("source=");
            b.append(this.source.getValueString());
        }
        if (this.target != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("target=");
            b.append(this.target.getValueString());
        }
        if (this.unsettled != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("unsettled=");
            b.append(this.unsettled.getValueString());
        }
        if (this.incompleteUnsettled != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("incompleteUnsettled=");
            b.append(this.incompleteUnsettled.getValueString());
        }
        if (this.initialDeliveryCount != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("initialDeliveryCount=");
            b.append(this.initialDeliveryCount.getValueString());
        }
        if (this.maxMessageSize != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("maxMessageSize=");
            b.append(this.maxMessageSize.getValueString());
        }
        if (this.offeredCapabilities != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("offeredCapabilities=");
            b.append(this.offeredCapabilities.getValueString());
        }
        if (this.desiredCapabilities != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("desiredCapabilities=");
            b.append(this.desiredCapabilities.getValueString());
        }
        if (this.properties != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("properties=");
            b.append(this.properties.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[Attach " + this.getDisplayString() + "]";
    }
}

