/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.transport.performatives;

import com.swiftmq.amqp.v100.generated.transport.definitions.Fields;
import com.swiftmq.amqp.v100.generated.transport.definitions.Handle;
import com.swiftmq.amqp.v100.generated.transport.definitions.TransferNumber;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameIF;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameVisitor;
import com.swiftmq.amqp.v100.transport.AMQPFrame;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPMap;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import com.swiftmq.amqp.v100.types.AMQPUnsignedShort;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class BeginFrame
extends AMQPFrame
implements FrameIF {
    public static String DESCRIPTOR_NAME = "amqp:begin:list";
    public static long DESCRIPTOR_CODE = 17L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    AMQPList body = null;
    boolean dirty = false;
    AMQPUnsignedShort remoteChannel = null;
    TransferNumber nextOutgoingId = null;
    AMQPUnsignedInt incomingWindow = null;
    AMQPUnsignedInt outgoingWindow = null;
    Handle handleMax = new Handle(0xFFFFFFFFL);
    AMQPArray offeredCapabilities = null;
    AMQPArray desiredCapabilities = null;
    Fields properties = null;

    public BeginFrame(int channel, AMQPList body) throws Exception {
        super(channel);
        this.body = body;
        if (body != null) {
            this.decode();
        }
    }

    public BeginFrame(int channel) {
        super(channel);
    }

    @Override
    public void accept(FrameVisitor visitor) {
        visitor.visit(this);
    }

    public AMQPUnsignedShort getRemoteChannel() {
        return this.remoteChannel;
    }

    public void setRemoteChannel(AMQPUnsignedShort remoteChannel) {
        this.dirty = true;
        this.remoteChannel = remoteChannel;
    }

    public TransferNumber getNextOutgoingId() {
        return this.nextOutgoingId;
    }

    public void setNextOutgoingId(TransferNumber nextOutgoingId) {
        this.dirty = true;
        this.nextOutgoingId = nextOutgoingId;
    }

    public AMQPUnsignedInt getIncomingWindow() {
        return this.incomingWindow;
    }

    public void setIncomingWindow(AMQPUnsignedInt incomingWindow) {
        this.dirty = true;
        this.incomingWindow = incomingWindow;
    }

    public AMQPUnsignedInt getOutgoingWindow() {
        return this.outgoingWindow;
    }

    public void setOutgoingWindow(AMQPUnsignedInt outgoingWindow) {
        this.dirty = true;
        this.outgoingWindow = outgoingWindow;
    }

    public Handle getHandleMax() {
        return this.handleMax;
    }

    public void setHandleMax(Handle handleMax) {
        this.dirty = true;
        this.handleMax = handleMax;
    }

    public AMQPArray getOfferedCapabilities() {
        return this.offeredCapabilities;
    }

    public void setOfferedCapabilities(AMQPArray offeredCapabilities) {
        this.dirty = true;
        this.offeredCapabilities = offeredCapabilities;
    }

    public AMQPArray getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public void setDesiredCapabilities(AMQPArray desiredCapabilities) {
        this.dirty = true;
        this.desiredCapabilities = desiredCapabilities;
    }

    public Fields getProperties() {
        return this.properties;
    }

    public void setProperties(Fields properties) {
        this.dirty = true;
        this.properties = properties;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.body == null) {
            n += 4;
            n += this.codeConstructor.getPredictedSize();
            n += this.remoteChannel != null ? this.remoteChannel.getPredictedSize() : 1;
            n += this.nextOutgoingId != null ? this.nextOutgoingId.getPredictedSize() : 1;
            n += this.incomingWindow != null ? this.incomingWindow.getPredictedSize() : 1;
            n += this.outgoingWindow != null ? this.outgoingWindow.getPredictedSize() : 1;
            n += this.handleMax != null ? this.handleMax.getPredictedSize() : 1;
            n += this.offeredCapabilities != null ? this.offeredCapabilities.getPredictedSize() : 1;
            n += this.desiredCapabilities != null ? this.desiredCapabilities.getPredictedSize() : 1;
            n += this.properties != null ? this.properties.getPredictedSize() : 1;
        } else {
            n += this.body.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.body.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.remoteChannel = (AMQPUnsignedShort)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'remoteChannel' in 'Begin' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'nextOutgoingId' in 'Begin' frame is NULL");
        }
        try {
            this.nextOutgoingId = new TransferNumber(((AMQPUnsignedInt)t).getValue());
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'nextOutgoingId' in 'Begin' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'incomingWindow' in 'Begin' frame is NULL");
        }
        try {
            this.incomingWindow = (AMQPUnsignedInt)t;
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'incomingWindow' in 'Begin' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'outgoingWindow' in 'Begin' frame is NULL");
        }
        try {
            this.outgoingWindow = (AMQPUnsignedInt)t;
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'outgoingWindow' in 'Begin' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.handleMax = new Handle(((AMQPUnsignedInt)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'handleMax' in 'Begin' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.offeredCapabilities = AMQPTypeDecoder.isArray(t.getCode()) ? (AMQPArray)t : this.singleToArray(t);
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'offeredCapabilities' in 'Begin' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.desiredCapabilities = AMQPTypeDecoder.isArray(t.getCode()) ? (AMQPArray)t : this.singleToArray(t);
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'desiredCapabilities' in 'Begin' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.properties = new Fields((Map)((AMQPMap)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'properties' in 'Begin' frame: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.remoteChannel);
        this.addToList(l, this.nextOutgoingId);
        this.addToList(l, this.incomingWindow);
        this.addToList(l, this.outgoingWindow);
        this.addToList(l, this.handleMax);
        this.addToList(l, this.offeredCapabilities);
        this.addToList(l, this.desiredCapabilities);
        this.addToList(l, this.properties);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.body = new AMQPList(l);
        this.dirty = false;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.dirty || this.body == null) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.body.getCode());
        this.body.setConstructor(this.codeConstructor);
        this.body.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty || this.body == null) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[Begin ");
        b.append(super.getValueString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.remoteChannel != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("remoteChannel=");
            b.append(this.remoteChannel.getValueString());
        }
        if (this.nextOutgoingId != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("nextOutgoingId=");
            b.append(this.nextOutgoingId.getValueString());
        }
        if (this.incomingWindow != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("incomingWindow=");
            b.append(this.incomingWindow.getValueString());
        }
        if (this.outgoingWindow != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("outgoingWindow=");
            b.append(this.outgoingWindow.getValueString());
        }
        if (this.handleMax != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("handleMax=");
            b.append(this.handleMax.getValueString());
        }
        if (this.offeredCapabilities != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("offeredCapabilities=");
            b.append(this.offeredCapabilities.getValueString());
        }
        if (this.desiredCapabilities != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("desiredCapabilities=");
            b.append(this.desiredCapabilities.getValueString());
        }
        if (this.properties != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("properties=");
            b.append(this.properties.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[Begin " + this.getDisplayString() + "]";
    }
}

