/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.transport.performatives;

import com.swiftmq.amqp.v100.generated.transport.definitions.Error;
import com.swiftmq.amqp.v100.generated.transport.definitions.Handle;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameIF;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameVisitor;
import com.swiftmq.amqp.v100.transport.AMQPFrame;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DetachFrame
extends AMQPFrame
implements FrameIF {
    public static String DESCRIPTOR_NAME = "amqp:detach:list";
    public static long DESCRIPTOR_CODE = 22L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    AMQPList body = null;
    boolean dirty = false;
    Handle handle = null;
    AMQPBoolean closed = AMQPBoolean.FALSE;
    Error error = null;

    public DetachFrame(int channel, AMQPList body) throws Exception {
        super(channel);
        this.body = body;
        if (body != null) {
            this.decode();
        }
    }

    public DetachFrame(int channel) {
        super(channel);
    }

    @Override
    public void accept(FrameVisitor visitor) {
        visitor.visit(this);
    }

    public Handle getHandle() {
        return this.handle;
    }

    public void setHandle(Handle handle) {
        this.dirty = true;
        this.handle = handle;
    }

    public AMQPBoolean getClosed() {
        return this.closed;
    }

    public void setClosed(AMQPBoolean closed) {
        this.dirty = true;
        this.closed = closed;
    }

    public Error getError() {
        return this.error;
    }

    public void setError(Error error) {
        this.dirty = true;
        this.error = error;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.body == null) {
            n += 4;
            n += this.codeConstructor.getPredictedSize();
            n += this.handle != null ? this.handle.getPredictedSize() : 1;
            n += this.closed != null ? this.closed.getPredictedSize() : 1;
            n += this.error != null ? this.error.getPredictedSize() : 1;
        } else {
            n += this.body.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.body.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'handle' in 'Detach' frame is NULL");
        }
        try {
            this.handle = new Handle(((AMQPUnsignedInt)t).getValue());
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'handle' in 'Detach' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.closed = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'closed' in 'Detach' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.error = new Error((List)((AMQPList)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'error' in 'Detach' frame: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.handle);
        this.addToList(l, this.closed);
        this.addToList(l, this.error);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.body = new AMQPList(l);
        this.dirty = false;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.dirty || this.body == null) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.body.getCode());
        this.body.setConstructor(this.codeConstructor);
        this.body.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty || this.body == null) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[Detach ");
        b.append(super.getValueString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.handle != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("handle=");
            b.append(this.handle.getValueString());
        }
        if (this.closed != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("closed=");
            b.append(this.closed.getValueString());
        }
        if (this.error != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("error=");
            b.append(this.error.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[Detach " + this.getDisplayString() + "]";
    }
}

