/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.transport.performatives;

import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateFactory;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateIF;
import com.swiftmq.amqp.v100.generated.transport.definitions.DeliveryNumber;
import com.swiftmq.amqp.v100.generated.transport.definitions.Role;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameIF;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameVisitor;
import com.swiftmq.amqp.v100.transport.AMQPFrame;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DispositionFrame
extends AMQPFrame
implements FrameIF {
    public static String DESCRIPTOR_NAME = "amqp:disposition:list";
    public static long DESCRIPTOR_CODE = 21L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    AMQPList body = null;
    boolean dirty = false;
    Role role = null;
    DeliveryNumber first = null;
    DeliveryNumber last = null;
    AMQPBoolean settled = AMQPBoolean.FALSE;
    DeliveryStateIF state = null;
    AMQPBoolean batchable = AMQPBoolean.FALSE;

    public DispositionFrame(int channel, AMQPList body) throws Exception {
        super(channel);
        this.body = body;
        if (body != null) {
            this.decode();
        }
    }

    public DispositionFrame(int channel) {
        super(channel);
    }

    @Override
    public void accept(FrameVisitor visitor) {
        visitor.visit(this);
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.dirty = true;
        this.role = role;
    }

    public DeliveryNumber getFirst() {
        return this.first;
    }

    public void setFirst(DeliveryNumber first) {
        this.dirty = true;
        this.first = first;
    }

    public DeliveryNumber getLast() {
        return this.last;
    }

    public void setLast(DeliveryNumber last) {
        this.dirty = true;
        this.last = last;
    }

    public AMQPBoolean getSettled() {
        return this.settled;
    }

    public void setSettled(AMQPBoolean settled) {
        this.dirty = true;
        this.settled = settled;
    }

    public DeliveryStateIF getState() {
        return this.state;
    }

    public void setState(DeliveryStateIF state) {
        this.dirty = true;
        this.state = state;
    }

    public AMQPBoolean getBatchable() {
        return this.batchable;
    }

    public void setBatchable(AMQPBoolean batchable) {
        this.dirty = true;
        this.batchable = batchable;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.body == null) {
            n += 4;
            n += this.codeConstructor.getPredictedSize();
            n += this.role != null ? this.role.getPredictedSize() : 1;
            n += this.first != null ? this.first.getPredictedSize() : 1;
            n += this.last != null ? this.last.getPredictedSize() : 1;
            n += this.settled != null ? this.settled.getPredictedSize() : 1;
            n += this.state != null ? this.state.getPredictedSize() : 1;
            n += this.batchable != null ? this.batchable.getPredictedSize() : 1;
        } else {
            n += this.body.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.body.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'role' in 'Disposition' frame is NULL");
        }
        try {
            this.role = new Role(((AMQPBoolean)t).getValue());
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'role' in 'Disposition' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'first' in 'Disposition' frame is NULL");
        }
        try {
            this.first = new DeliveryNumber(((AMQPUnsignedInt)t).getValue());
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'first' in 'Disposition' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.last = new DeliveryNumber(((AMQPUnsignedInt)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'last' in 'Disposition' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.settled = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'settled' in 'Disposition' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() != 64) {
            this.state = DeliveryStateFactory.create(t);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.batchable = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'batchable' in 'Disposition' frame: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.role);
        this.addToList(l, this.first);
        this.addToList(l, this.last);
        this.addToList(l, this.settled);
        this.addToList(l, this.state);
        this.addToList(l, this.batchable);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.body = new AMQPList(l);
        this.dirty = false;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.dirty || this.body == null) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.body.getCode());
        this.body.setConstructor(this.codeConstructor);
        this.body.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty || this.body == null) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[Disposition ");
        b.append(super.getValueString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.role != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("role=");
            b.append(this.role.getValueString());
        }
        if (this.first != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("first=");
            b.append(this.first.getValueString());
        }
        if (this.last != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("last=");
            b.append(this.last.getValueString());
        }
        if (this.settled != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("settled=");
            b.append(this.settled.getValueString());
        }
        if (this.state != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("state=");
            b.append(this.state.getValueString());
        }
        if (this.batchable != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("batchable=");
            b.append(this.batchable.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[Disposition " + this.getDisplayString() + "]";
    }
}

