/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.transport.performatives;

import com.swiftmq.amqp.v100.generated.transport.definitions.Fields;
import com.swiftmq.amqp.v100.generated.transport.definitions.Handle;
import com.swiftmq.amqp.v100.generated.transport.definitions.SequenceNo;
import com.swiftmq.amqp.v100.generated.transport.definitions.TransferNumber;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameIF;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameVisitor;
import com.swiftmq.amqp.v100.transport.AMQPFrame;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPMap;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class FlowFrame
extends AMQPFrame
implements FrameIF {
    public static String DESCRIPTOR_NAME = "amqp:flow:list";
    public static long DESCRIPTOR_CODE = 19L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    AMQPList body = null;
    boolean dirty = false;
    TransferNumber nextIncomingId = null;
    AMQPUnsignedInt incomingWindow = null;
    TransferNumber nextOutgoingId = null;
    AMQPUnsignedInt outgoingWindow = null;
    Handle handle = null;
    SequenceNo deliveryCount = null;
    AMQPUnsignedInt linkCredit = null;
    AMQPUnsignedInt available = null;
    AMQPBoolean drain = AMQPBoolean.FALSE;
    AMQPBoolean echo = AMQPBoolean.FALSE;
    Fields properties = null;

    public FlowFrame(int channel, AMQPList body) throws Exception {
        super(channel);
        this.body = body;
        if (body != null) {
            this.decode();
        }
    }

    public FlowFrame(int channel) {
        super(channel);
    }

    @Override
    public void accept(FrameVisitor visitor) {
        visitor.visit(this);
    }

    public TransferNumber getNextIncomingId() {
        return this.nextIncomingId;
    }

    public void setNextIncomingId(TransferNumber nextIncomingId) {
        this.dirty = true;
        this.nextIncomingId = nextIncomingId;
    }

    public AMQPUnsignedInt getIncomingWindow() {
        return this.incomingWindow;
    }

    public void setIncomingWindow(AMQPUnsignedInt incomingWindow) {
        this.dirty = true;
        this.incomingWindow = incomingWindow;
    }

    public TransferNumber getNextOutgoingId() {
        return this.nextOutgoingId;
    }

    public void setNextOutgoingId(TransferNumber nextOutgoingId) {
        this.dirty = true;
        this.nextOutgoingId = nextOutgoingId;
    }

    public AMQPUnsignedInt getOutgoingWindow() {
        return this.outgoingWindow;
    }

    public void setOutgoingWindow(AMQPUnsignedInt outgoingWindow) {
        this.dirty = true;
        this.outgoingWindow = outgoingWindow;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public void setHandle(Handle handle) {
        this.dirty = true;
        this.handle = handle;
    }

    public SequenceNo getDeliveryCount() {
        return this.deliveryCount;
    }

    public void setDeliveryCount(SequenceNo deliveryCount) {
        this.dirty = true;
        this.deliveryCount = deliveryCount;
    }

    public AMQPUnsignedInt getLinkCredit() {
        return this.linkCredit;
    }

    public void setLinkCredit(AMQPUnsignedInt linkCredit) {
        this.dirty = true;
        this.linkCredit = linkCredit;
    }

    public AMQPUnsignedInt getAvailable() {
        return this.available;
    }

    public void setAvailable(AMQPUnsignedInt available) {
        this.dirty = true;
        this.available = available;
    }

    public AMQPBoolean getDrain() {
        return this.drain;
    }

    public void setDrain(AMQPBoolean drain) {
        this.dirty = true;
        this.drain = drain;
    }

    public AMQPBoolean getEcho() {
        return this.echo;
    }

    public void setEcho(AMQPBoolean echo) {
        this.dirty = true;
        this.echo = echo;
    }

    public Fields getProperties() {
        return this.properties;
    }

    public void setProperties(Fields properties) {
        this.dirty = true;
        this.properties = properties;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.body == null) {
            n += 4;
            n += this.codeConstructor.getPredictedSize();
            n += this.nextIncomingId != null ? this.nextIncomingId.getPredictedSize() : 1;
            n += this.incomingWindow != null ? this.incomingWindow.getPredictedSize() : 1;
            n += this.nextOutgoingId != null ? this.nextOutgoingId.getPredictedSize() : 1;
            n += this.outgoingWindow != null ? this.outgoingWindow.getPredictedSize() : 1;
            n += this.handle != null ? this.handle.getPredictedSize() : 1;
            n += this.deliveryCount != null ? this.deliveryCount.getPredictedSize() : 1;
            n += this.linkCredit != null ? this.linkCredit.getPredictedSize() : 1;
            n += this.available != null ? this.available.getPredictedSize() : 1;
            n += this.drain != null ? this.drain.getPredictedSize() : 1;
            n += this.echo != null ? this.echo.getPredictedSize() : 1;
            n += this.properties != null ? this.properties.getPredictedSize() : 1;
        } else {
            n += this.body.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.body.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.nextIncomingId = new TransferNumber(((AMQPUnsignedInt)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'nextIncomingId' in 'Flow' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'incomingWindow' in 'Flow' frame is NULL");
        }
        try {
            this.incomingWindow = (AMQPUnsignedInt)t;
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'incomingWindow' in 'Flow' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'nextOutgoingId' in 'Flow' frame is NULL");
        }
        try {
            this.nextOutgoingId = new TransferNumber(((AMQPUnsignedInt)t).getValue());
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'nextOutgoingId' in 'Flow' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'outgoingWindow' in 'Flow' frame is NULL");
        }
        try {
            this.outgoingWindow = (AMQPUnsignedInt)t;
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'outgoingWindow' in 'Flow' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.handle = new Handle(((AMQPUnsignedInt)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'handle' in 'Flow' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.deliveryCount = new SequenceNo(((AMQPUnsignedInt)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'deliveryCount' in 'Flow' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.linkCredit = (AMQPUnsignedInt)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'linkCredit' in 'Flow' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.available = (AMQPUnsignedInt)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'available' in 'Flow' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.drain = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'drain' in 'Flow' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.echo = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'echo' in 'Flow' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.properties = new Fields((Map)((AMQPMap)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'properties' in 'Flow' frame: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.nextIncomingId);
        this.addToList(l, this.incomingWindow);
        this.addToList(l, this.nextOutgoingId);
        this.addToList(l, this.outgoingWindow);
        this.addToList(l, this.handle);
        this.addToList(l, this.deliveryCount);
        this.addToList(l, this.linkCredit);
        this.addToList(l, this.available);
        this.addToList(l, this.drain);
        this.addToList(l, this.echo);
        this.addToList(l, this.properties);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.body = new AMQPList(l);
        this.dirty = false;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.dirty || this.body == null) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.body.getCode());
        this.body.setConstructor(this.codeConstructor);
        this.body.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty || this.body == null) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[Flow ");
        b.append(super.getValueString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.nextIncomingId != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("nextIncomingId=");
            b.append(this.nextIncomingId.getValueString());
        }
        if (this.incomingWindow != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("incomingWindow=");
            b.append(this.incomingWindow.getValueString());
        }
        if (this.nextOutgoingId != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("nextOutgoingId=");
            b.append(this.nextOutgoingId.getValueString());
        }
        if (this.outgoingWindow != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("outgoingWindow=");
            b.append(this.outgoingWindow.getValueString());
        }
        if (this.handle != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("handle=");
            b.append(this.handle.getValueString());
        }
        if (this.deliveryCount != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("deliveryCount=");
            b.append(this.deliveryCount.getValueString());
        }
        if (this.linkCredit != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("linkCredit=");
            b.append(this.linkCredit.getValueString());
        }
        if (this.available != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("available=");
            b.append(this.available.getValueString());
        }
        if (this.drain != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("drain=");
            b.append(this.drain.getValueString());
        }
        if (this.echo != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("echo=");
            b.append(this.echo.getValueString());
        }
        if (this.properties != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("properties=");
            b.append(this.properties.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[Flow " + this.getDisplayString() + "]";
    }
}

