/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.transport.performatives;

import com.swiftmq.amqp.v100.generated.transport.performatives.AttachFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.BeginFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.CloseFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.DetachFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.DispositionFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.EndFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.FlowFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameIF;
import com.swiftmq.amqp.v100.generated.transport.performatives.OpenFrame;
import com.swiftmq.amqp.v100.generated.transport.performatives.TransferFrame;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.IOException;

public class FrameFactory {
    public static FrameIF create(int channel, AMQPType bare) throws Exception {
        if (bare.getCode() == 64) {
            return null;
        }
        AMQPDescribedConstructor constructor = bare.getConstructor();
        if (constructor == null) {
            throw new IOException("Missing constructor: " + bare);
        }
        AMQPType descriptor = constructor.getDescriptor();
        int code = descriptor.getCode();
        if (AMQPTypeDecoder.isULong(code)) {
            long type = ((AMQPUnsignedLong)descriptor).getValue();
            if (type == OpenFrame.DESCRIPTOR_CODE) {
                return new OpenFrame(channel, (AMQPList)bare);
            }
            if (type == BeginFrame.DESCRIPTOR_CODE) {
                return new BeginFrame(channel, (AMQPList)bare);
            }
            if (type == AttachFrame.DESCRIPTOR_CODE) {
                return new AttachFrame(channel, (AMQPList)bare);
            }
            if (type == FlowFrame.DESCRIPTOR_CODE) {
                return new FlowFrame(channel, (AMQPList)bare);
            }
            if (type == TransferFrame.DESCRIPTOR_CODE) {
                return new TransferFrame(channel, (AMQPList)bare);
            }
            if (type == DispositionFrame.DESCRIPTOR_CODE) {
                return new DispositionFrame(channel, (AMQPList)bare);
            }
            if (type == DetachFrame.DESCRIPTOR_CODE) {
                return new DetachFrame(channel, (AMQPList)bare);
            }
            if (type == EndFrame.DESCRIPTOR_CODE) {
                return new EndFrame(channel, (AMQPList)bare);
            }
            if (type == CloseFrame.DESCRIPTOR_CODE) {
                return new CloseFrame(channel, (AMQPList)bare);
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        if (AMQPTypeDecoder.isSymbol(code)) {
            String type = ((AMQPSymbol)descriptor).getValue();
            if (type.equals(OpenFrame.DESCRIPTOR_NAME)) {
                return new OpenFrame(channel, (AMQPList)bare);
            }
            if (type.equals(BeginFrame.DESCRIPTOR_NAME)) {
                return new BeginFrame(channel, (AMQPList)bare);
            }
            if (type.equals(AttachFrame.DESCRIPTOR_NAME)) {
                return new AttachFrame(channel, (AMQPList)bare);
            }
            if (type.equals(FlowFrame.DESCRIPTOR_NAME)) {
                return new FlowFrame(channel, (AMQPList)bare);
            }
            if (type.equals(TransferFrame.DESCRIPTOR_NAME)) {
                return new TransferFrame(channel, (AMQPList)bare);
            }
            if (type.equals(DispositionFrame.DESCRIPTOR_NAME)) {
                return new DispositionFrame(channel, (AMQPList)bare);
            }
            if (type.equals(DetachFrame.DESCRIPTOR_NAME)) {
                return new DetachFrame(channel, (AMQPList)bare);
            }
            if (type.equals(EndFrame.DESCRIPTOR_NAME)) {
                return new EndFrame(channel, (AMQPList)bare);
            }
            if (type.equals(CloseFrame.DESCRIPTOR_NAME)) {
                return new CloseFrame(channel, (AMQPList)bare);
            }
            throw new Exception("Invalid descriptor type: " + type + ", bare=" + bare);
        }
        throw new Exception("Invalid type of constructor descriptor (actual type=" + code + ", expected=symbold or ulong), bare= " + bare);
    }
}

