/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.transport.performatives;

import com.swiftmq.amqp.v100.generated.transport.definitions.Fields;
import com.swiftmq.amqp.v100.generated.transport.definitions.Milliseconds;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameIF;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameVisitor;
import com.swiftmq.amqp.v100.transport.AMQPFrame;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPMap;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import com.swiftmq.amqp.v100.types.AMQPUnsignedShort;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class OpenFrame
extends AMQPFrame
implements FrameIF {
    public static String DESCRIPTOR_NAME = "amqp:open:list";
    public static long DESCRIPTOR_CODE = 16L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    AMQPList body = null;
    boolean dirty = false;
    AMQPString containerId = null;
    AMQPString hostname = null;
    AMQPUnsignedInt maxFrameSize = new AMQPUnsignedInt(0xFFFFFFFFL);
    AMQPUnsignedShort channelMax = new AMQPUnsignedShort(65535);
    Milliseconds idleTimeOut = null;
    AMQPArray outgoingLocales = null;
    AMQPArray incomingLocales = null;
    AMQPArray offeredCapabilities = null;
    AMQPArray desiredCapabilities = null;
    Fields properties = null;

    public OpenFrame(int channel, AMQPList body) throws Exception {
        super(channel);
        this.body = body;
        if (body != null) {
            this.decode();
        }
    }

    public OpenFrame(int channel) {
        super(channel);
    }

    @Override
    public void accept(FrameVisitor visitor) {
        visitor.visit(this);
    }

    public AMQPString getContainerId() {
        return this.containerId;
    }

    public void setContainerId(AMQPString containerId) {
        this.dirty = true;
        this.containerId = containerId;
    }

    public AMQPString getHostname() {
        return this.hostname;
    }

    public void setHostname(AMQPString hostname) {
        this.dirty = true;
        this.hostname = hostname;
    }

    public AMQPUnsignedInt getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(AMQPUnsignedInt maxFrameSize) {
        this.dirty = true;
        this.maxFrameSize = maxFrameSize;
    }

    public AMQPUnsignedShort getChannelMax() {
        return this.channelMax;
    }

    public void setChannelMax(AMQPUnsignedShort channelMax) {
        this.dirty = true;
        this.channelMax = channelMax;
    }

    public Milliseconds getIdleTimeOut() {
        return this.idleTimeOut;
    }

    public void setIdleTimeOut(Milliseconds idleTimeOut) {
        this.dirty = true;
        this.idleTimeOut = idleTimeOut;
    }

    public AMQPArray getOutgoingLocales() {
        return this.outgoingLocales;
    }

    public void setOutgoingLocales(AMQPArray outgoingLocales) {
        this.dirty = true;
        this.outgoingLocales = outgoingLocales;
    }

    public AMQPArray getIncomingLocales() {
        return this.incomingLocales;
    }

    public void setIncomingLocales(AMQPArray incomingLocales) {
        this.dirty = true;
        this.incomingLocales = incomingLocales;
    }

    public AMQPArray getOfferedCapabilities() {
        return this.offeredCapabilities;
    }

    public void setOfferedCapabilities(AMQPArray offeredCapabilities) {
        this.dirty = true;
        this.offeredCapabilities = offeredCapabilities;
    }

    public AMQPArray getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public void setDesiredCapabilities(AMQPArray desiredCapabilities) {
        this.dirty = true;
        this.desiredCapabilities = desiredCapabilities;
    }

    public Fields getProperties() {
        return this.properties;
    }

    public void setProperties(Fields properties) {
        this.dirty = true;
        this.properties = properties;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.body == null) {
            n += 4;
            n += this.codeConstructor.getPredictedSize();
            n += this.containerId != null ? this.containerId.getPredictedSize() : 1;
            n += this.hostname != null ? this.hostname.getPredictedSize() : 1;
            n += this.maxFrameSize != null ? this.maxFrameSize.getPredictedSize() : 1;
            n += this.channelMax != null ? this.channelMax.getPredictedSize() : 1;
            n += this.idleTimeOut != null ? this.idleTimeOut.getPredictedSize() : 1;
            n += this.outgoingLocales != null ? this.outgoingLocales.getPredictedSize() : 1;
            n += this.incomingLocales != null ? this.incomingLocales.getPredictedSize() : 1;
            n += this.offeredCapabilities != null ? this.offeredCapabilities.getPredictedSize() : 1;
            n += this.desiredCapabilities != null ? this.desiredCapabilities.getPredictedSize() : 1;
            n += this.properties != null ? this.properties.getPredictedSize() : 1;
        } else {
            n += this.body.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.body.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'containerId' in 'Open' frame is NULL");
        }
        try {
            this.containerId = (AMQPString)t;
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'containerId' in 'Open' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.hostname = (AMQPString)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'hostname' in 'Open' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.maxFrameSize = (AMQPUnsignedInt)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'maxFrameSize' in 'Open' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.channelMax = (AMQPUnsignedShort)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'channelMax' in 'Open' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.idleTimeOut = new Milliseconds(((AMQPUnsignedInt)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'idleTimeOut' in 'Open' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.outgoingLocales = AMQPTypeDecoder.isArray(t.getCode()) ? (AMQPArray)t : this.singleToArray(t);
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'outgoingLocales' in 'Open' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.incomingLocales = AMQPTypeDecoder.isArray(t.getCode()) ? (AMQPArray)t : this.singleToArray(t);
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'incomingLocales' in 'Open' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.offeredCapabilities = AMQPTypeDecoder.isArray(t.getCode()) ? (AMQPArray)t : this.singleToArray(t);
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'offeredCapabilities' in 'Open' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.desiredCapabilities = AMQPTypeDecoder.isArray(t.getCode()) ? (AMQPArray)t : this.singleToArray(t);
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'desiredCapabilities' in 'Open' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.properties = new Fields((Map)((AMQPMap)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'properties' in 'Open' frame: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.containerId);
        this.addToList(l, this.hostname);
        this.addToList(l, this.maxFrameSize);
        this.addToList(l, this.channelMax);
        this.addToList(l, this.idleTimeOut);
        this.addToList(l, this.outgoingLocales);
        this.addToList(l, this.incomingLocales);
        this.addToList(l, this.offeredCapabilities);
        this.addToList(l, this.desiredCapabilities);
        this.addToList(l, this.properties);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.body = new AMQPList(l);
        this.dirty = false;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.dirty || this.body == null) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.body.getCode());
        this.body.setConstructor(this.codeConstructor);
        this.body.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty || this.body == null) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[Open ");
        b.append(super.getValueString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.containerId != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("containerId=");
            b.append(this.containerId.getValueString());
        }
        if (this.hostname != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("hostname=");
            b.append(this.hostname.getValueString());
        }
        if (this.maxFrameSize != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("maxFrameSize=");
            b.append(this.maxFrameSize.getValueString());
        }
        if (this.channelMax != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("channelMax=");
            b.append(this.channelMax.getValueString());
        }
        if (this.idleTimeOut != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("idleTimeOut=");
            b.append(this.idleTimeOut.getValueString());
        }
        if (this.outgoingLocales != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("outgoingLocales=");
            b.append(this.outgoingLocales.getValueString());
        }
        if (this.incomingLocales != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("incomingLocales=");
            b.append(this.incomingLocales.getValueString());
        }
        if (this.offeredCapabilities != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("offeredCapabilities=");
            b.append(this.offeredCapabilities.getValueString());
        }
        if (this.desiredCapabilities != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("desiredCapabilities=");
            b.append(this.desiredCapabilities.getValueString());
        }
        if (this.properties != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("properties=");
            b.append(this.properties.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[Open " + this.getDisplayString() + "]";
    }
}

