/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.generated.transport.performatives;

import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateFactory;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateIF;
import com.swiftmq.amqp.v100.generated.transport.definitions.DeliveryNumber;
import com.swiftmq.amqp.v100.generated.transport.definitions.DeliveryTag;
import com.swiftmq.amqp.v100.generated.transport.definitions.Handle;
import com.swiftmq.amqp.v100.generated.transport.definitions.MessageFormat;
import com.swiftmq.amqp.v100.generated.transport.definitions.ReceiverSettleMode;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameIF;
import com.swiftmq.amqp.v100.generated.transport.performatives.FrameVisitor;
import com.swiftmq.amqp.v100.transport.AMQPFrame;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBinary;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPDescribedConstructor;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedByte;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class TransferFrame
extends AMQPFrame
implements FrameIF {
    public static String DESCRIPTOR_NAME = "amqp:transfer:list";
    public static long DESCRIPTOR_CODE = 20L;
    public AMQPDescribedConstructor codeConstructor = new AMQPDescribedConstructor(new AMQPUnsignedLong(DESCRIPTOR_CODE), 255);
    public AMQPDescribedConstructor nameConstructor = new AMQPDescribedConstructor(new AMQPSymbol(DESCRIPTOR_NAME), 255);
    AMQPList body = null;
    boolean dirty = false;
    Handle handle = null;
    DeliveryNumber deliveryId = null;
    DeliveryTag deliveryTag = null;
    MessageFormat messageFormat = null;
    AMQPBoolean settled = null;
    AMQPBoolean more = AMQPBoolean.FALSE;
    ReceiverSettleMode rcvSettleMode = null;
    DeliveryStateIF state = null;
    AMQPBoolean resume = AMQPBoolean.FALSE;
    AMQPBoolean aborted = AMQPBoolean.FALSE;
    AMQPBoolean batchable = AMQPBoolean.FALSE;

    public TransferFrame(int channel, AMQPList body) throws Exception {
        super(channel);
        this.body = body;
        if (body != null) {
            this.decode();
        }
    }

    public TransferFrame(int channel) {
        super(channel);
    }

    @Override
    public void accept(FrameVisitor visitor) {
        visitor.visit(this);
    }

    public Handle getHandle() {
        return this.handle;
    }

    public void setHandle(Handle handle) {
        this.dirty = true;
        this.handle = handle;
    }

    public DeliveryNumber getDeliveryId() {
        return this.deliveryId;
    }

    public void setDeliveryId(DeliveryNumber deliveryId) {
        this.dirty = true;
        this.deliveryId = deliveryId;
    }

    public DeliveryTag getDeliveryTag() {
        return this.deliveryTag;
    }

    public void setDeliveryTag(DeliveryTag deliveryTag) {
        this.dirty = true;
        this.deliveryTag = deliveryTag;
    }

    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    public void setMessageFormat(MessageFormat messageFormat) {
        this.dirty = true;
        this.messageFormat = messageFormat;
    }

    public AMQPBoolean getSettled() {
        return this.settled;
    }

    public void setSettled(AMQPBoolean settled) {
        this.dirty = true;
        this.settled = settled;
    }

    public AMQPBoolean getMore() {
        return this.more;
    }

    public void setMore(AMQPBoolean more) {
        this.dirty = true;
        this.more = more;
    }

    public ReceiverSettleMode getRcvSettleMode() {
        return this.rcvSettleMode;
    }

    public void setRcvSettleMode(ReceiverSettleMode rcvSettleMode) {
        this.dirty = true;
        this.rcvSettleMode = rcvSettleMode;
    }

    public DeliveryStateIF getState() {
        return this.state;
    }

    public void setState(DeliveryStateIF state) {
        this.dirty = true;
        this.state = state;
    }

    public AMQPBoolean getResume() {
        return this.resume;
    }

    public void setResume(AMQPBoolean resume) {
        this.dirty = true;
        this.resume = resume;
    }

    public AMQPBoolean getAborted() {
        return this.aborted;
    }

    public void setAborted(AMQPBoolean aborted) {
        this.dirty = true;
        this.aborted = aborted;
    }

    public AMQPBoolean getBatchable() {
        return this.batchable;
    }

    public void setBatchable(AMQPBoolean batchable) {
        this.dirty = true;
        this.batchable = batchable;
    }

    @Override
    public int getPredictedSize() {
        int n = super.getPredictedSize();
        if (this.body == null) {
            n += 4;
            n += this.codeConstructor.getPredictedSize();
            n += this.handle != null ? this.handle.getPredictedSize() : 1;
            n += this.deliveryId != null ? this.deliveryId.getPredictedSize() : 1;
            n += this.deliveryTag != null ? this.deliveryTag.getPredictedSize() : 1;
            n += this.messageFormat != null ? this.messageFormat.getPredictedSize() : 1;
            n += this.settled != null ? this.settled.getPredictedSize() : 1;
            n += this.more != null ? this.more.getPredictedSize() : 1;
            n += this.rcvSettleMode != null ? this.rcvSettleMode.getPredictedSize() : 1;
            n += this.state != null ? this.state.getPredictedSize() : 1;
            n += this.resume != null ? this.resume.getPredictedSize() : 1;
            n += this.aborted != null ? this.aborted.getPredictedSize() : 1;
            n += this.batchable != null ? this.batchable.getPredictedSize() : 1;
        } else {
            n += this.body.getPredictedSize();
        }
        return n;
    }

    private AMQPArray singleToArray(AMQPType t) throws IOException {
        return new AMQPArray(t.getCode(), new AMQPType[]{t});
    }

    private void decode() throws Exception {
        List<AMQPType> l = this.body.getValue();
        AMQPType t = null;
        int idx = 0;
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() == 64) {
            throw new Exception("Mandatory field 'handle' in 'Transfer' frame is NULL");
        }
        try {
            this.handle = new Handle(((AMQPUnsignedInt)t).getValue());
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'handle' in 'Transfer' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.deliveryId = new DeliveryNumber(((AMQPUnsignedInt)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'deliveryId' in 'Transfer' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.deliveryTag = new DeliveryTag(((AMQPBinary)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'deliveryTag' in 'Transfer' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.messageFormat = new MessageFormat(((AMQPUnsignedInt)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'messageFormat' in 'Transfer' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.settled = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'settled' in 'Transfer' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.more = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'more' in 'Transfer' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.rcvSettleMode = new ReceiverSettleMode(((AMQPUnsignedByte)t).getValue());
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'rcvSettleMode' in 'Transfer' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        if ((t = l.get(idx++)).getCode() != 64) {
            this.state = DeliveryStateFactory.create(t);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.resume = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'resume' in 'Transfer' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.aborted = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'aborted' in 'Transfer' frame: " + e);
        }
        if (idx >= l.size()) {
            return;
        }
        t = l.get(idx++);
        try {
            if (t.getCode() != 64) {
                this.batchable = (AMQPBoolean)t;
            }
        }
        catch (ClassCastException e) {
            throw new Exception("Invalid type of field 'batchable' in 'Transfer' frame: " + e);
        }
    }

    private void addToList(List list, Object value) {
        if (value != null) {
            list.add(value);
        } else {
            list.add(AMQPNull.NULL);
        }
    }

    private void encode() throws IOException {
        AMQPType t;
        ArrayList<AMQPType> l = new ArrayList<AMQPType>();
        this.addToList(l, this.handle);
        this.addToList(l, this.deliveryId);
        this.addToList(l, this.deliveryTag);
        this.addToList(l, this.messageFormat);
        this.addToList(l, this.settled);
        this.addToList(l, this.more);
        this.addToList(l, this.rcvSettleMode);
        this.addToList(l, this.state);
        this.addToList(l, this.resume);
        this.addToList(l, this.aborted);
        this.addToList(l, this.batchable);
        ListIterator iter = l.listIterator(l.size());
        while (iter.hasPrevious() && (t = (AMQPType)iter.previous()).getCode() == 64) {
            iter.remove();
        }
        this.body = new AMQPList(l);
        this.dirty = false;
    }

    @Override
    protected void writeBody(DataOutput out) throws IOException {
        if (this.dirty || this.body == null) {
            this.encode();
        }
        this.codeConstructor.setFormatCode(this.body.getCode());
        this.body.setConstructor(this.codeConstructor);
        this.body.writeContent(out);
    }

    @Override
    public String getValueString() {
        try {
            if (this.dirty || this.body == null) {
                this.encode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer b = new StringBuffer("[Transfer ");
        b.append(super.getValueString());
        b.append("]");
        return b.toString();
    }

    private String getDisplayString() {
        boolean _first = true;
        StringBuffer b = new StringBuffer();
        if (this.handle != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("handle=");
            b.append(this.handle.getValueString());
        }
        if (this.deliveryId != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("deliveryId=");
            b.append(this.deliveryId.getValueString());
        }
        if (this.deliveryTag != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("deliveryTag=");
            b.append(this.deliveryTag.getValueString());
        }
        if (this.messageFormat != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("messageFormat=");
            b.append(this.messageFormat.getValueString());
        }
        if (this.settled != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("settled=");
            b.append(this.settled.getValueString());
        }
        if (this.more != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("more=");
            b.append(this.more.getValueString());
        }
        if (this.rcvSettleMode != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("rcvSettleMode=");
            b.append(this.rcvSettleMode.getValueString());
        }
        if (this.state != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("state=");
            b.append(this.state.getValueString());
        }
        if (this.resume != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("resume=");
            b.append(this.resume.getValueString());
        }
        if (this.aborted != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("aborted=");
            b.append(this.aborted.getValueString());
        }
        if (this.batchable != null) {
            if (!_first) {
                b.append(", ");
            } else {
                _first = false;
            }
            b.append("batchable=");
            b.append(this.batchable.getValueString());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return "[Transfer " + this.getDisplayString() + ", body=" + this.body.getValueString() + "]";
    }
}

