/*
 * Decompiled with CFR 0.152.
 */
package com.swiftmq.amqp.v100.messaging;

import com.swiftmq.amqp.v100.client.Consumer;
import com.swiftmq.amqp.v100.client.InvalidStateException;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.Accepted;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.DeliveryStateIF;
import com.swiftmq.amqp.v100.generated.messaging.delivery_state.Rejected;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AmqpSequence;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AmqpValue;
import com.swiftmq.amqp.v100.generated.messaging.message_format.ApplicationProperties;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Data;
import com.swiftmq.amqp.v100.generated.messaging.message_format.DeliveryAnnotations;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Footer;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Header;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageAnnotations;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Properties;
import com.swiftmq.amqp.v100.generated.messaging.message_format.SectionFactory;
import com.swiftmq.amqp.v100.generated.messaging.message_format.SectionIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.SectionVisitorAdapter;
import com.swiftmq.amqp.v100.generated.transactions.coordination.TransactionalState;
import com.swiftmq.amqp.v100.generated.transactions.coordination.TxnIdIF;
import com.swiftmq.amqp.v100.generated.transport.definitions.DeliveryTag;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPTypeDecoder;
import com.swiftmq.tools.util.DataByteArrayInputStream;
import com.swiftmq.tools.util.DataStreamInputStream;
import com.swiftmq.tools.util.MultiByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class AMQPMessage {
    Header header = null;
    DeliveryAnnotations deliveryAnnotations = null;
    MessageAnnotations messageAnnotations = null;
    Properties properties = null;
    ApplicationProperties applicationProperties = null;
    List<Data> data = null;
    List<AmqpSequence> amqpSequence = null;
    AmqpValue amqpValue = null;
    Footer footer = null;
    BodyVisitor visitor = new BodyVisitor();
    Exception parseException = null;
    byte[] body = null;
    byte[][] multiBody = null;
    int totalSize = 0;
    int bodySize = 0;
    DeliveryTag deliveryTag = null;
    long deliveryId = -1L;
    boolean settled = false;
    TxnIdIF txnIdIF = null;
    Consumer consumer = null;

    public AMQPMessage(byte[] body) throws Exception {
        this.body = body;
        this.decode();
    }

    public AMQPMessage(byte[][] multiBody, int totalSize) throws Exception {
        this.multiBody = multiBody;
        this.totalSize = totalSize;
        this.decode();
    }

    public AMQPMessage() {
    }

    public int getBodySize() {
        return this.bodySize;
    }

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }

    public TxnIdIF getTxnIdIF() {
        return this.txnIdIF;
    }

    public void setTxnIdIF(TxnIdIF txnIdIF) {
        this.txnIdIF = txnIdIF;
    }

    public void accept() throws InvalidStateException {
        if (this.consumer == null) {
            throw new InvalidStateException("Message not associated with a consumer");
        }
        if (this.settled && this.txnIdIF == null) {
            throw new InvalidStateException("Accept not required; message has already been settled");
        }
        AMQPList deliveryStateIF = null;
        if (this.txnIdIF == null) {
            deliveryStateIF = new Accepted();
        } else {
            TransactionalState transactionalState = new TransactionalState();
            transactionalState.setTxnId(this.txnIdIF);
            transactionalState.setOutcome(new Accepted());
            deliveryStateIF = transactionalState;
        }
        this.consumer.sendDisposition(this, (DeliveryStateIF)((Object)deliveryStateIF));
    }

    public void reject() throws InvalidStateException {
        if (this.consumer == null) {
            throw new InvalidStateException("Message not associated with a consumer");
        }
        if (this.settled && this.txnIdIF == null) {
            throw new InvalidStateException("Reject not possible; message has already been settled");
        }
        AMQPList deliveryStateIF = null;
        if (this.txnIdIF == null) {
            deliveryStateIF = new Rejected();
        } else {
            TransactionalState transactionalState = new TransactionalState();
            transactionalState.setTxnId(this.txnIdIF);
            transactionalState.setOutcome(new Rejected());
            deliveryStateIF = transactionalState;
        }
        this.consumer.sendDisposition(this, (DeliveryStateIF)((Object)deliveryStateIF));
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
        this.body = null;
    }

    public DeliveryAnnotations getDeliveryAnnotations() {
        return this.deliveryAnnotations;
    }

    public void setDeliveryAnnotations(DeliveryAnnotations deliveryAnnotations) {
        this.deliveryAnnotations = deliveryAnnotations;
        this.body = null;
    }

    public MessageAnnotations getMessageAnnotations() {
        return this.messageAnnotations;
    }

    public void setMessageAnnotations(MessageAnnotations messageAnnotations) {
        this.messageAnnotations = messageAnnotations;
        this.body = null;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        this.body = null;
    }

    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        this.body = null;
    }

    public List<Data> getData() {
        return this.data;
    }

    public void addData(Data d) {
        if (this.data == null) {
            this.data = new ArrayList<Data>();
        }
        this.data.add(d);
        this.body = null;
        this.amqpSequence = null;
        this.amqpValue = null;
    }

    public List<AmqpSequence> getAmqpSequence() {
        return this.amqpSequence;
    }

    public void addAmqpSequence(AmqpSequence sequence) {
        if (this.amqpSequence == null) {
            this.amqpSequence = new ArrayList<AmqpSequence>();
        }
        this.amqpSequence.add(sequence);
        this.body = null;
        this.data = null;
        this.amqpValue = null;
    }

    public AmqpValue getAmqpValue() {
        return this.amqpValue;
    }

    public void setAmqpValue(AmqpValue amqpValue) {
        this.amqpValue = amqpValue;
        this.body = null;
        this.data = null;
        this.amqpSequence = null;
    }

    public Footer getFooter() {
        return this.footer;
    }

    public void setFooter(Footer footer) {
        this.footer = footer;
        this.body = null;
    }

    public long getDeliveryId() {
        return this.deliveryId;
    }

    public void setDeliveryId(long deliveryId) {
        this.deliveryId = deliveryId;
    }

    public boolean isSettled() {
        return this.settled;
    }

    public void setSettled(boolean settled) {
        this.settled = settled;
    }

    public DeliveryTag getDeliveryTag() {
        return this.deliveryTag;
    }

    public void setDeliveryTag(DeliveryTag deliveryTag) {
        this.deliveryTag = deliveryTag;
    }

    private void decode() throws Exception {
        InputStream dataInput = null;
        if (this.multiBody != null) {
            dataInput = new DataStreamInputStream(new MultiByteArrayInputStream(this.multiBody, this.totalSize));
            this.bodySize = this.totalSize;
        } else {
            dataInput = new DataByteArrayInputStream(this.body);
            this.bodySize = this.body.length;
        }
        this.parseSections((DataInput)((Object)dataInput));
    }

    private void parseSections(DataInput dis) throws Exception {
        SectionIF section = SectionFactory.create(AMQPTypeDecoder.decode(dis));
        try {
            while (this.parseException == null) {
                if (section != null) {
                    section.accept(this.visitor);
                }
                section = SectionFactory.create(AMQPTypeDecoder.decode(dis));
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (this.parseException != null) {
            throw this.parseException;
        }
    }

    private void write(AMQPType t, DataOutput out) throws IOException {
        if (t != null) {
            t.writeContent(out);
        }
    }

    public void writeContent(DataOutput out) throws IOException {
        if (this.body != null) {
            out.write(this.body);
        } else {
            this.write(this.header, out);
            this.write(this.deliveryAnnotations, out);
            this.write(this.messageAnnotations, out);
            this.write(this.properties, out);
            this.write(this.applicationProperties, out);
            if (this.data != null) {
                for (int i = 0; i < this.data.size(); ++i) {
                    this.data.get(i).writeContent(out);
                }
            } else if (this.amqpSequence != null) {
                for (int i = 0; i < this.amqpSequence.size(); ++i) {
                    this.amqpSequence.get(i).writeContent(out);
                }
            } else if (this.amqpValue != null) {
                this.write(this.amqpValue, out);
            }
            this.write(this.footer, out);
        }
    }

    private void appendValue(StringBuffer b, String name, AMQPType t) {
        if (t != null) {
            b.append(", ");
            b.append(name);
            b.append("=");
            b.append(t.getValueString());
        }
    }

    private String getDisplayString() {
        StringBuffer b = new StringBuffer();
        this.appendValue(b, "header", this.header);
        this.appendValue(b, "deliveryAnnotations", this.deliveryAnnotations);
        this.appendValue(b, "messageAnnotations", this.messageAnnotations);
        this.appendValue(b, "properties", this.properties);
        this.appendValue(b, "applicationProperties", this.applicationProperties);
        if (this.data != null) {
            for (int i = 0; i < this.data.size(); ++i) {
                this.appendValue(b, "data", this.data.get(i));
            }
        } else if (this.amqpSequence != null) {
            for (int i = 0; i < this.amqpSequence.size(); ++i) {
                this.appendValue(b, "amqpSequence", this.amqpSequence.get(i));
            }
        } else if (this.amqpValue != null) {
            this.appendValue(b, "amqpValue", this.amqpValue);
        }
        this.appendValue(b, "footer", this.footer);
        return b.toString();
    }

    public String toString() {
        return "[AMQPMessage" + this.getDisplayString() + "]";
    }

    private class BodyVisitor
    extends SectionVisitorAdapter {
        private BodyVisitor() {
        }

        @Override
        public void visit(Header impl) {
            if (AMQPMessage.this.header != null) {
                AMQPMessage.this.parseException = new Exception("Header already set!");
            }
            AMQPMessage.this.header = impl;
        }

        @Override
        public void visit(DeliveryAnnotations impl) {
            if (AMQPMessage.this.deliveryAnnotations != null) {
                AMQPMessage.this.parseException = new Exception("DeliveryAnnotations already set!");
            }
            AMQPMessage.this.deliveryAnnotations = impl;
        }

        @Override
        public void visit(MessageAnnotations impl) {
            if (AMQPMessage.this.messageAnnotations != null) {
                AMQPMessage.this.parseException = new Exception("MessageAnnotations already set!");
            }
            AMQPMessage.this.messageAnnotations = impl;
        }

        @Override
        public void visit(Properties impl) {
            if (AMQPMessage.this.properties != null) {
                AMQPMessage.this.parseException = new Exception("Properties already set!");
            }
            AMQPMessage.this.properties = impl;
        }

        @Override
        public void visit(ApplicationProperties impl) {
            if (AMQPMessage.this.applicationProperties != null) {
                AMQPMessage.this.parseException = new Exception("ApplicationProperties already set!");
            }
            AMQPMessage.this.applicationProperties = impl;
        }

        @Override
        public void visit(Data impl) {
            if (AMQPMessage.this.data == null) {
                AMQPMessage.this.data = new ArrayList<Data>();
            }
            AMQPMessage.this.data.add(impl);
        }

        @Override
        public void visit(AmqpSequence impl) {
            if (AMQPMessage.this.amqpSequence == null) {
                AMQPMessage.this.amqpSequence = new ArrayList<AmqpSequence>();
            }
            AMQPMessage.this.amqpSequence.add(impl);
        }

        @Override
        public void visit(AmqpValue impl) {
            if (AMQPMessage.this.amqpValue != null) {
                AMQPMessage.this.parseException = new Exception("Invalid body part (AmqpSequence), have already a single AmqpValue!");
            } else if (AMQPMessage.this.data != null) {
                AMQPMessage.this.parseException = new Exception("Invalid body part (AmqpValue), expecting Data!");
            } else if (AMQPMessage.this.amqpSequence != null) {
                AMQPMessage.this.parseException = new Exception("Invalid body part (AmqpValue), expecting AmqpSequence!");
            } else {
                AMQPMessage.this.amqpValue = impl;
                AMQPMessage.this.amqpValue.getValue().resetConstructor();
            }
        }

        @Override
        public void visit(Footer impl) {
            AMQPMessage.this.footer = impl;
        }
    }
}

